/*
 * ImageButton.java - image button
 *
 * crated: kwagen, 19970915
 *
 * changed: kwagen, 19970915
 * changed: mpichler, 19970916
 *
 * $Id: ImageButton.java,v 1.5 1997/09/29 07:54:14 jwolte Exp $
 */


package iicm.widgets;

import java.awt.*;
import java.awt.image.*;


/**
 * ImageButton - image button
 */

public class ImageButton extends Canvas
{
  protected String label_;
  protected Image img_;
  protected int width_, height_;  // including frame
  protected boolean state_;
  protected ImageButtonGroup group_ = null;

  /**
   * constructor
   * @param label label used when img is null
   * @param width image width, substituted by label width when img is null
   * @param height allows uniform button height if some images are not available,
   * width determined from image or label
   * @param state initial state flag
   * @param group ImageButtonGroup for radio buttons, null for toggle buttons
   */

  public ImageButton (String label, Image img, int width, int height, boolean state, ImageButtonGroup group)
  {
    label_ = label;
    // e.g.: (Toolkit.getDefaultToolkit ()).getImage (imgfile)
    img_ = img;
    setFont (Fontify.fntButton);
    if (img_ != null)
      width_ += width + 6;
    else
      width_ = getFontMetrics (Fontify.fntButton).stringWidth (label) + 10;
    height_ = height + 6;
    state_ = state;
    group_ = group;
    if (group != null)
      group.addButton (this);
  }

  /**
   * small helper to crop a subimage area out of an image.
   * will wait until cropping has been completed when target is non-null.
   */

  public static Image subimage (Image img, int x, int y, int w, int h, Component target)
  {
    if (img == null)
      return null;

    CropImageFilter filter = new CropImageFilter (x, y, w, h);
    Toolkit toolkit = Toolkit.getDefaultToolkit ();
    Image subimg = toolkit.createImage (new FilteredImageSource (img.getSource (), filter));
    if (target != null)
      waitForImage (subimg, target);
    return subimg;
  }

  /**
   * small helper to wait until an image is completely loaded
   * @return flag whether all was ok
   */

  public static boolean waitForImage (Image img, Component target)
  {
    if (img == null)
      return true;

    MediaTracker tracker = new MediaTracker (target);
    tracker.addImage (img, 0);
    try
    { tracker.waitForID (0);
    }
    catch (InterruptedException e)  { }
    return !tracker.isErrorID (0);
  }

  public Dimension minimumSize ()
  {
    return new Dimension (width_, height_);
  }

  public Dimension preferredSize ()
  {
    return new Dimension (width_, height_);
  }

//   public boolean imageUpdate (Image img, int flags, int x, int y, int w, int h)
//   {
//     if ((flags & ABORT) > 0 || (flags & ERROR) > 0)
//       System.out.println ("file not found: " + imgfile_);
//     return super.imageUpdate (img, flags, x, y, w, h);
//   }

  public void update (Graphics g)
  {
    paint (g);
  }

  public void paint (Graphics g)
  {
    Color bg = getBackground ();
    Color hilbg = bg;
    if (state_)
      hilbg = new Color ((int) (bg.getRed ()*1.2), (int) (bg.getGreen ()*1.2), (int) (bg.getBlue ()*1.2));

    if (img_ == null || img_.getWidth (this) <= 0)  // won't look pretty
    {
      g.setColor (hilbg);
      g.fillRect (0, 0, width_, height_);
      g.setColor (getForeground ());
      g.drawString (label_, 5, height_-10);
    }
    else  // image
      g.drawImage (img_, 3, 3, width_-6, height_-6, hilbg, this);

    boolean raised = !state_;
/*
    // motif-like border
    g.setColor (new Color ((int) (bg.getRed ()/1.2), (int) (bg.getGreen ()/1.2),
      (int) (bg.getBlue ()/1.2)));
    g.draw3DRect (0, 0, width_-1, height_-1, raised);
    g.draw3DRect (1, 1, width_-3, height_-3, raised);
    g.draw3DRect (2, 2, width_-5, height_-5, raised);
*/
    // SGI motif-like border
    g.setColor (new Color (state_ ? 0xABABAB : 0x545454));
    g.draw3DRect (0, 0, width_-1, height_-1, raised);
    g.setColor (new Color (state_ ? 0x383838 : 0xB1B1B1));
    g.draw3DRect (1, 1, width_-3, height_-3, true);
    if (state_)
      g.setColor (new Color (0xDDDDDD));
    g.draw3DRect (2, 2, width_-5, height_-5, true);
  } // paint

  public boolean mouseDown (Event evt, int x, int y)
  {
    if (group_ == null)
    {
      state_ = !state_;
      repaint ();
    }
    else if (!state_)
    {
      group_.setCurrent (this);
      state_ = true;
      repaint ();
    }
    return false;  // pass up to parent Component
  }

  public void setState (boolean value)
  {
    if (value != state_)
    {
      state_ = value;
      if (group_ != null && value)
        group_.setCurrent (this);
      repaint ();
    }
  }

  public boolean getState ()
  {
    return state_;
  }
} // ImageButton
