/*
 * @(#)$Id: ttymode.c,v 1.1 1994/03/17 03:37:00 shin Exp $
 *
 * - terminal control operations
 */

#ifdef	TERMIO	/* SYS V terminal control */

#include	<termio.h>

static struct termio	tty_mode;
int tty_raw(fd)
int	fd;
{
	struct termio	temp_mode;
	if (ioctl(fd, TCGETA, (char *) &temp_mode) < 0)
		return(-1);
	tty_mode = temp_mode;

	temp_mode.c_iflag = 0;
#ifndef	USE_OPOST
	temp_mode.c_oflag &= ~OPOST;
#endif
	temp_mode.c_lflag &= ~(ISIG|ICANON|ECHO|XCASE);
	temp_mode.c_cflag &= ~(CSIZE|PARENB);
	temp_mode.c_cflag |= (CS8);
	temp_mode.c_cc[VMIN] = 1;
	temp_mode.c_cc[VTIME] = 1;
	if (ioctl(fd, TCSETA, (char *) &temp_mode) < 0)
		return(-1);
	return(0);
}

int tty_reset(fd)
int	fd;
{
	if (ioctl(fd, TCSETA, (char *) &tty_mode) < 0)
		return(-1);
	return(0);
}

static struct termio	tty_termio;

int tty_getmode(oldfd)
int	oldfd;
{
	if (ioctl(oldfd, TCGETA, (char *) &tty_termio) < 0)
		return(-1);
	return(0);
}

int tty_setmode(newfd)
int	newfd;
{
	if (ioctl(newfd, TCSETA, (char *) &tty_termio) < 0)
		return(-1);
	return(0);
}

#else	/* BSD 4.3 */

#include	<sys/types.h>
#include	<sys/ioctl.h>

static struct sgttyb	tty_mode;

int tty_raw(fd)
int	fd;
{
	struct sgttyb	temp_mode;
	if (ioctl(fd, TIOCGETP, (char *) & temp_mode) <0)
		return(-1);
	tty_mode = temp_mode;

	temp_mode.sg_flags |= RAW;
	temp_mode.sg_flags &= ~ECHO;
	if (ioctl(fd, TIOCSETP, (char *) & temp_mode) <0)
		return(-1);

	return(0);
}

int tty_reset(fd)
int	fd;
{
	if (ioctl(fd, TIOCSETP, (char *) & tty_mode) <0)
		return(-1);

	return(0);
}

static struct sgttyb	tty_sgttyb;
static struct tchars	tty_tchars;
static struct ltchars	tty_ltchars;
static struct winsize	tty_winsize;
static int		tty_localmode;
static int		tty_ldisc;

int tty_getmode(oldfd)
int	oldfd;
{
	if (ioctl(oldfd, TIOCGETP,	(char *) &tty_sgttyb) <0)
		return(-1);
	if (ioctl(oldfd, TIOCGETC,	(char *) &tty_tchars) <0)
		return(-1);
	if (ioctl(oldfd, TIOCGLTC,	(char *) &tty_ltchars) <0)
		return(-1);
	if (ioctl(oldfd, TIOCLGET,	(char *) &tty_localmode) <0)
		return(-1);
	if (ioctl(oldfd, TIOCGETD,	(char *) &tty_ldisc) <0)
		return(-1);
	if (ioctl(oldfd, TIOCGWINSZ,	(char *) &tty_winsize) <0)
		return(-1);

	return(0);
}

int tty_setmode(newfd)
int	newfd;
{
	if (ioctl(newfd, TIOCSETP,	(char *) &tty_sgttyb) <0)
		return(-1);
	if (ioctl(newfd, TIOCSETC,	(char *) &tty_tchars) <0)
		return(-1);
	if (ioctl(newfd, TIOCSLTC,	(char *) &tty_ltchars) <0)
		return(-1);
	if (ioctl(newfd, TIOCLSET,	(char *) &tty_localmode) <0)
		return(-1);
	if (ioctl(newfd, TIOCSETD,	(char *) &tty_ldisc) <0)
		return(-1);
	if (ioctl(newfd, TIOCSWINSZ,	(char *) &tty_winsize) <0)
		return(-1);

	return(0);
}
#endif

/*
 * History:
 *
 * $Log: ttymode.c,v $
 * Revision 1.1  1994/03/17  03:37:00  shin
 * Initial revision
 *
 *
 */
