/*
 * @(#)$Id: pty.c,v 1.1 1994/03/15 18:11:00 shin Exp $
 */
#ifndef	SVR4_PTY
/*
 * pseudo tty for 4.3 BSD
 */
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/file.h>
/*
 * The name of the pty master device is stored here by pty_master().
 * The next call to pty_slave() uses this name for the slave.
 */

static char	pty_name[12];	/* "/dev/[pt]tyXY" = 10 chars + null byte */

/*
 * returns the file descriptor, or -1 on error
 */
int pty_master()
{
	int		i, master_fd;
	char		*ptr;
	struct stat	statbuff;
	static char	ptychar[] = "pqrs";			/* X */
	static char	hexdigit[] = "0123456789abcdef";	/* Y */

	/*
	 * Open the master half - "/dev/pty[pqrs][0-9a-f]".
	 * There is no easy way to obtain an available minor device
	 * (similar to a streams clone open) - we have to try them
	 * all until we find an unused one.
	 */

	for ( ptr=ptychar; *ptr!=0 ; ptr++ ) {
		strcpy(pty_name, "/dev/ptyXY");
		pty_name[8] = *ptr;	/* X */
		pty_name[9] = '0';	/* Y */

		/*
		 * If this name, "/dev/ptyX0" does not even exist,
		 * then we can quit now. It means the system doesn't
		 * have /dev entries for this group of 16 ptys.
		 */
		if (stat(pty_name, &statbuff) < 0 )
			break;
		for (i=0; i<16; i++) {
			pty_name[9] = hexdigit[i];	/* 0-9a-f */
			if ( (master_fd = open(pty_name, O_RDWR)) >= 0)
				return(master_fd);
		}
	}
	return(-1);	/* couldn't open master, assume all pty's are in use */
}

/*
 * Open the slave half of a ptty.
 * Note that the master half of a pty is a single-open device,
 * so there isn't a race condition between opening the master
 * above and opening the slave below. The only way the slave
 * open will fail is if someone has opened the slave without
 * first opening the master.
 */

/*
 * pty_slave: returns the file descriptor, or -1 on error.
 */

int pty_slave(master_fd)
int	master_fd;		/* from pty_master */
{
	int	slave_fd;

	pty_name[5] = 't';	/* change "/dev/ptyXY" to "/dev/ttyXY" */
	if ( (slave_fd = open(pty_name, O_RDWR)) < 0) {
		close(master_fd);
		return(-1);
	}
	return(slave_fd);
}

#else	/* SVR4_PTY */
/*
 * pseudo tty for SVR4
 */
#ifndef	SUN5

#include	<stdio.h>
#include	<fcntl.h>
#include	<stropts.h>

#else	/* SUN5 */

#include	<sys/types.h>
#include	<fcntl.h>
#include	<stropts.h>
#include	<sys/conf.h>

#endif	/* !SUN5 */

#define		PTY_MASTER	"/dev/ptmx"

int pty_master()
{
	int	master_fd;

	if ( (master_fd = open(PTY_MASTER, O_RDWR)) < 0)
		return(-1);

	return(master_fd);
}

int pty_slave(master_fd)
int	master_fd;
{
	int	slave_fd;
	char	*slavename;
	int	grantpt();
	int	unlockpt();
	char	*ptsname();

	if (grantpt(master_fd) < 0) {	/* change permission of slave */
		close(master_fd);
		return(-1);
	}

	if (unlockpt(master_fd) <0) {	/* unlock slave */
		close(master_fd);
		return(-1);
	}

	slavename = ptsname(master_fd);
	if (slavename==NULL) {
		close(master_fd);
		return(-1);
	}

	slave_fd = open(slavename, O_RDWR);
	if ( slave_fd <0) {
		close(master_fd);
		return(-1);
	}

	/*
	 * push stream modules onto slave:
	 * ptem: pseudo-terminal emulator
	 * ldterm: standard terminal line discipline.
	 */
	if (ioctl(slave_fd, I_PUSH, "ptem") <0) {
		close(master_fd);
		return(-1);
	}

	if (ioctl(slave_fd, I_PUSH, "ldterm") <0) {
		close(master_fd);
		return(-1);
	}

	return(slave_fd);

}

#endif /* !SVR4_PTY */
/*
 * History:
 *
 * $Log: pty.c,v $
 * Revision 1.1  1994/03/15  18:11:00  shin
 * Initial revision
 *
 *
 */
