#include "cs.h"   /*      UGENS8.C        */
#include <math.h>
#include "dsputil.h"
#include "fft.h"
#include "pvoc.h"
#include "pvocext.h"
#include "ugens8.h"
#include "soundio.h"
#include "oload.h"

/******************************************/
/* Originated by Dan Ellis, MIT */
/* Spectral Extraction and Amplitude Gating */
/* added by Richard Karpen, University */
/* of Washington, Seattle 1998 */
/******************************************/


#define WLN   1         /* time window is WLN*2*ksmps long */

#define OPWLEN (2*WLN*ksmps)    /* manifest used for final time wdw */

extern  float   esr, ekr, sicvt, kicvt, dv32768;
extern  int     ksmps;

void pvset(PVOC *p)
{
    int      i;
    long     memsize;
    char     pvfilnam[MAXNAME];
    MEMFIL   *mfp, *ldmemfile();
    PVSTRUCT *pvh;
    int      frInc, chans, size; /* THESE SHOULD BE SAVED IN PVOC STRUCT */
    FUNC     *AmpGateFunc;


    if (*p->ifilno == sstrcod) { /* if char string name given */
      extern EVTBLK *currevent;
      extern char *unquote(char *name);
      if (p->STRARG == NULL) strcpy(pvfilnam,unquote(currevent->strarg));
      else strcpy(pvfilnam, unquote(p->STRARG));
    }
    else if ((long)*p->ifilno < strsmax && strsets != NULL &&
	     strsets[(long)*p->ifilno])
      strcpy(pvfilnam, strsets[(long)*p->ifilno]);
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno); /* else pvoc.filnum   */
    if ((mfp = p->mfp) == NULL
      || strcmp(mfp->filename, pvfilnam) != 0) /* if file not already readin */
        if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
            sprintf(errmsg,"PVOC cannot load %s", pvfilnam);
            goto pverr;
        }
    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
        sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
                pvfilnam, pvh->magic );
        goto pverr;
    }

    chans    = pvh->channels;
    p->frSiz = pvh->frameSize;
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->baseFr = 0;  /* point to first data frame */
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float)));

     if(*p->imode == 1 || *p->imode == 2)
	memsize = (long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN + 
			((p->frSiz+2L) * (p->maxFr+2)));
     else
	memsize = (long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN);

    if (p->auxch.auxp == NULL || memsize != p->mems) {
        register float *fltp;
        auxalloc((memsize * sizeof(float)), &p->auxch);
        fltp = (float *) p->auxch.auxp;
        p->lastPhase = fltp;   fltp += PVDATASIZE;    /* and insert addresses */
        p->fftBuf = fltp;      fltp += PVFFTSIZE;
        p->dsBuf = fltp;       fltp += PVFFTSIZE;
        p->outBuf = fltp;      fltp += PVFFTSIZE;
        p->window = fltp;
        if(*p->imode == 1 || *p->imode == 2) {
        	fltp += PVWINLEN;
        	p->pvcopy = fltp;
		}
        }
	p->mems=memsize;

    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
        sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
                pvfilnam, p->asr, esr);
        warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
        sprintf(errmsg,"unsupported PVOC data format %ld in %s",
                pvh->dataFormat, pvfilnam);
        goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
        sprintf(errmsg,"PVOC frame %d bigger than %ld in %s",
                p->frSiz, PVFRAMSIZE, pvfilnam);
        goto pverr;
    }
    if (p->frSiz < 128) {
        sprintf(errmsg,"PVOC frame %ld seems too small in %s",
                p->frSiz, pvfilnam);
        goto pverr;
    }
    if (chans != 1) {
        sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
                chans, pvfilnam);
        goto pverr;
    }


    frInc    = pvh->frameIncr;
    p->frPktim = ((float)ksmps)/((float)frInc);
    /* factor by which to mult expand phase diffs (ratio of samp spacings) */
    p->frPrtim = esr/((float)frInc);
    /* factor by which to mulitply 'real' time index to get frame index */
    size = pvfrsiz(p);          /* size used in def of OPWLEN ? */
/*  p->scale = 4.*((float)ksmps)/((float)pvfrsiz(p)*(float)pvfrsiz(p)); */
/*    p->scale = 2.*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));   */
    p->scale = 32768.0f*2.0f*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));
    /* 2*incr/OPWLEN scales down for win ovlp, windo'd 1ce (but 2ce?) */
    /* 1/frSiz is the required scale down before (i)FFT */
    p->prFlg = 1;    /* true */
    p->opBpos = 0;
    p->lastPex = 1.0f;       /* needs to know last pitchexp to update phase */
    /* Set up time window */
    for (i=0; i < pvdasiz(p); ++i) {  /* or maybe pvdasiz(p) */
     /* p->window[i] = (0.54-0.46*cos(TWOPI*(float)i/(float)(pvfrsiz(p)))); */
        p->lastPhase[i] = 0.0f;
    }
    if( (OPWLEN/2 + 1)>PVWINLEN ) {
        sprintf(errmsg, "ksmps of %d needs wdw of %d, max is %d for pv %s\n",
                ksmps, (OPWLEN/2 + 1), PVWINLEN, pvfilnam);
        goto pverr;
    }
    
    if(*p->igatefun > 0)
      if ((AmpGateFunc = ftfind(p->igatefun)) == NULL)
        return;
    p->AmpGateFunc = AmpGateFunc;
  
    if(*p->igatefun > 0)
      p->PvMaxAmp = PvocMaxAmp(p->frPtr, size, p->maxFr);

    if(*p->imode == 1 || *p->imode == 2) {
      SpectralExtract(p->frPtr, p->pvcopy, size, p->maxFr,
                      (int)*p->imode, *p->ifreqlim);
      p->frPtr = p->pvcopy; 
    }

    for (i=0; i < OPWLEN/2+1; ++i)    /* time window is OPWLEN long */
        p->window[i] = (0.54f-0.46f*(float)cos(TWOPI*(double)i/(double)OPWLEN));
    /* NB : HAMMING */
    for(i=0; i< pvfrsiz(p); ++i)
        p->outBuf[i] = 0.0f;
    MakeSinc( /* p->sncTab */ );        /* sinctab is same for all instances */
    p->plut = (float *)AssignBasis(NULL, pvfrsiz(p));    /* SET UP NONET FFT */

    return;

 pverr:
    initerror(errmsg);
}
#define pdebug (1)

void pvoc(PVOC *p)
{
    float  *ar = p->rslt;
    float  frIndx;
    float  *buf = p->fftBuf;
    float  *buf2 = p->dsBuf;
    float  *plut = p->plut;
    int    asize = pvdasiz(p);  /* new */
    int    size = pvfrsiz(p);
    int    buf2Size, outlen;
    int    circBufSize = PVFFTSIZE;
    int    specwp = (int)*p->ispecwp;   /* spectral warping flag */
    float  pex;


    if (p->auxch.auxp==NULL) {
      initerror("pvoc: not initialized");
      return;
    }
/*      if (pdebug) { printf("<%7.4f>",*p->ktimpnt); fflush(stdout); } */
    pex = *p->kfmod;
    outlen = (int)(((float)size)/pex);
    /* use outlen to check window/krate/transpose combinations */
    if (outlen>PVFFTSIZE) {  /* Maximum transposition down is one octave */
                             /* ..so we won't run into buf2Size problems */
      perferror("PVOC transpose too low");
      return;
    }
    if (outlen<2*ksmps) {    /* minimum post-squeeze windowlength */
      perferror("PVOC transpose too high");
      return;
    }
    buf2Size = OPWLEN;       /* always window to same length after DS */
    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
      perferror("PVOC timpnt < 0");
      return;
    }
    if (frIndx > p->maxFr) {  /* not past last one */
      frIndx = (float)p->maxFr;
      if (p->prFlg) {
        p->prFlg = 0;   /* false */
        warning("PVOC ktimpnt truncated to last frame");
      }
    }
    FetchIn(p->frPtr,buf,size,frIndx);
    
    if(*p->igatefun > 0)
    	PvAmpGate(buf,size, p->AmpGateFunc, p->PvMaxAmp);
    	
    FrqToPhase(buf, asize, pex*(float)ksmps, p->asr,
           /*a0.0*/(float)(0.5 * ( (pex / p->lastPex) - 1.0) ));
    /* Offset the phase to align centres of stretched windows, not starts */
    RewrapPhase(buf, asize, p->lastPhase);

    if (specwp>0) PreWarpSpec(buf, asize, pex); 

    Polar2Rect(buf, asize);
    buf[1] = 0.0f; buf[size+1] = 0.0f;    /* kill spurious imag at dc & fs/2 */
    FFT2torl((complex *)buf,size,1,/*a pex*/ p->scale, (complex *)plut);
    /* CALL TO NONET FFT */
    PackReals(buf, size);
    if (pex != 1.0)
      UDSample(buf,(0.5f*((float)size - pex*(float)buf2Size))/*a*/,
               buf2, size, buf2Size, pex);
    else
      CopySamps(buf+(int)(0.5*((float)size - pex*(float)buf2Size))/*a*/,
                buf2,buf2Size);
    ApplyHalfWin(buf2, p->window, buf2Size); 
    addToCircBuf(buf2, p->outBuf, p->opBpos, ksmps, circBufSize);
    writeClrFromCircBuf(p->outBuf, ar, p->opBpos, ksmps, circBufSize);
    p->opBpos += ksmps;
    if (p->opBpos > circBufSize)     p->opBpos -= circBufSize;
    addToCircBuf(buf2+ksmps,p->outBuf,p->opBpos,buf2Size-ksmps,circBufSize);
    p->lastPex = pex;        /* needs to know last pitchexp to update phase */
}


