#include "cs.h"			/*			UGENS4.C	*/
#include "ugens4.h"
#include <math.h>

void bzzset(BUZZ *p)
{
    FUNC	*ftp;

    if ((ftp = ftfind(p->ifn)) != NULL) {
      p->ftp = ftp;
      if (*p->iphs >= 0)
	p->lphs = (long)(*p->iphs * 0.5f * fmaxlen);
      p->ampcod = (p->XINCODE & 02) ? 1 : 0;
      p->cpscod = (p->XINCODE & 01) ? 1 : 0;
    }
}

void buzz(BUZZ *p)
{
    FUNC	*ftp;
    float	*ar, *ampp, *cpsp, *ftbl;
    long	phs, inc, lobits, dwnphs, tnp1, lenmask, nn;
    float	sicvt2, over2n, scal, num, denom;
    int	n;

    ftp = p->ftp;
    if (ftp==NULL) {        /* RWD fix */
      initerror("buzz: not initialized");
      return;
    }
    ftbl = ftp->ftable;
    sicvt2 = sicvt * 0.5f;		/* for theta/2	*/
    lobits = ftp->lobits;
    lenmask = ftp->lenmask;
    ampp = p->xamp;
    cpsp = p->xcps;
    if ((n = (int)*p->knh) <= 0) {		/* fix n = knh */
      printf("buzz knh (%d) <= 0; taken as 1\n", n);
      n = 1;
    }
    tnp1 = (n <<1) + 1;			/* calc 2n + 1 */
    over2n = 0.5f / n;
    scal = *ampp * over2n;
    inc = (long)(*cpsp * sicvt2);
    ar = p->ar;
    phs = p->lphs;
    nn = ksmps;
    do {
      dwnphs = phs >> lobits;
      denom = *(ftbl + dwnphs);
      if (denom > .0002 || denom < -.0002f) {
	num = *(ftbl + (dwnphs * tnp1 & lenmask));
	*ar++ = (num / denom - 1.0f) * scal;
      }
      else *ar++ = *ampp;
      phs += inc;
      phs &= PMASK;
      if (p->ampcod)
	scal = *(++ampp) * over2n;
      if (p->cpscod)
	inc = (long)(*(++cpsp)* sicvt2);
    }
    while (--nn);
    p->lphs = phs;
}

void gbzset(GBUZZ *p)
{
    FUNC	*ftp;

    if ((ftp = ftfind(p->ifn)) != NULL) {
      p->ftp = ftp;
      if (*p->iphs >= 0) {
	p->lphs = (long)(*p->iphs * fmaxlen);
	p->prvr = 0.0f;
      }
      p->ampcod = (p->XINCODE & 02) ? 1 : 0;
      p->cpscod = (p->XINCODE & 01) ? 1 : 0;
    }
}

void gbuzz(GBUZZ *p)
{
    FUNC	*ftp;
    float	*ar, *ampp, *cpsp, *ftbl;
    long	phs, inc, lobits, lenmask, k, km1, kpn, kpnm1, nn;
    long	n;
    float	r, absr, num, denom, scal;

    ftp = p->ftp;
    if (ftp==NULL) {
      initerror("gbuzz: not initialized");
      return;
    }
    ftbl = ftp->ftable;
    lobits = ftp->lobits;
    lenmask = ftp->lenmask;
    ampp = p->xamp;
    cpsp = p->xcps;
    k = (long)*p->kk;			/* fix k and n	*/
    if ((n = (long)*p->kn) <= 0) {		/* n must be > 0 */
      perferror("gbuzz knh <= 0");
      return;
    }
    km1 = k - 1;
    kpn = k + n;
    kpnm1 = kpn - 1;
    if ((r = *p->kr) != p->prvr || n != p->prvn) {
      p->twor = r * 2.0f;
      p->rsqp1 = r * r + 1.0f;
      p->rtn = (float)pow((double) r, (double) n);
      p->rtnp1 = p->rtn * r;
      if ((absr = (float)fabs(r)) > .999f && absr < 1.001f)
	p->rsumr = 1.0f / n;
      else p->rsumr = (1.0f - absr) / (1.0f - (float)fabs(p->rtn));
      p->prvr = r;
      p->prvn = (short)n;
    }
    scal =  *ampp * p->rsumr;
    inc = (long)(*cpsp * sicvt);
    ar = p->ar;
    nn = ksmps;
    do {
      phs = p->lphs >>lobits;
      denom = p->rsqp1 - p->twor * *(ftbl + phs);
      if (denom > .0002f || denom < -.0002f) {
	num = *(ftbl + (phs * k & lenmask))
	        - r * *(ftbl + (phs * km1 & lenmask))
		- p->rtn * *(ftbl + (phs * kpn & lenmask))
		+ p->rtnp1 * *(ftbl + (phs * kpnm1 & lenmask));
	*ar++ = num / denom * scal;
      }
      else *ar++ = *ampp;
      if (p->ampcod)
	scal =  p->rsumr * *(++ampp);
      p->lphs += inc;
      p->lphs &= PMASK;
      if (p->cpscod)
	inc = (long)(*(++cpsp) * sicvt);
    }
    while (--nn);
}

#define PLUKMIN 64
static  short	rand15(void);
static  short	rand16(void);

void plukset(PLUCK *p)
{
    int	n;
    long	npts, iphs;
    char	*auxp;
    FUNC	*ftp;
    float	*ap, *fp;
    float	phs, phsinc;

    if ((npts = (long)(esr/ *p->icps))<PLUKMIN)  /* npts is wavelen in sampls */
      npts = PLUKMIN; 			/*  (but at least min size)  */
    if ((auxp = p->auxch.auxp) == NULL ||
	npts > p->maxpts) {	/* get newspace    */
      auxalloc((npts+1)*sizeof(float),&p->auxch);
      auxp = p->auxch.auxp;
      p->maxpts = npts;       			/*	if reqd    */
    }
    ap = (float *)auxp;     			/* as float array   */
    if (*p->ifn == 0.0)
      for (n=npts; n--; )     			/* f0: fill w. rands */
        *ap++ = (float)rand16() * dv32768;
    else if ((ftp = ftfind(p->ifn)) != NULL) {
      fp = ftp->ftable;       			/* else from ftable  */
      phs = 0.0f;
      phsinc = (float)(ftp->flen/npts);
      for (n=npts; n--; phs += phsinc) {
        iphs = (long)phs;
        *ap++ = *(fp + iphs);
      }
    }
    *ap = *(float *)auxp;				/* last= copy of 1st */
    p->npts = npts;
    p->sicps = (npts * 256.0f + 128.0f) / esr;		/* tuned pitch convt */
    p->phs256 = 0;
    p->method = (short)*p->imeth;
    p->param1 = *p->ipar1;
    p->param2 = *p->ipar2;
    switch(p->method) {
    case 1:	/* ignore any given parameters */ 
      break;
    case 2:	/* stretch factor: param1 >= 1 */
      if (p->param1 < 1.0f)
        initerror("illegal stretch factor(param1) value");
      else p->thresh1 =  (short)(32768.0f / p->param1);
      break;
    case 3: /* roughness factor: 0 <= param1 <= 1 */
      if (p->param1 < 0.0f || p->param1 > 1.0f)
        initerror("illegal roughness factor(param1) value");
      p->thresh1 = (short)(32768.0f * p->param1);
      break;
    case 4: /* rough and stretch factor: 0 <= param1 <= 1, param2 >= 1 */
      if (p->param1 < 0.0f || p->param1 > 1.0f)
        initerror("illegal roughness factor(param1) value");
      else p->thresh1 = (short)(32768.0f * p->param1);
      if (p->param2 < 1.0f)
        initerror("illegal stretch factor(param2) value");
      else p->thresh2 = (short)(32768.0f / p->param2);
      break;
    case 5: /* weighting coeff's: param1 + param2 <= 1 */
      if (p->param1 + p->param2 > 1)
        initerror("coefficients too large(param1 + param2)");
      break;
    case 6: /* ignore any given parameters */
      break;
      
    default:initerror("unknown method code");
    }
}

void pluck(PLUCK *p)
{
    float	*ar, *fp;
    long	phs256, phsinc, ltwopi, offset;
    int	nsmps;
    float	frac, diff;

    if (p->auxch.auxp==NULL) { /* RWD FIX */
      initerror("pluck: not initialized");
      return;
    }
    ar = p->ar;
    phsinc = (long)(*p->kcps * p->sicps);
    phs256 = p->phs256;
    ltwopi = p->npts << 8;
    nsmps = ksmps;
    do {
      offset = phs256 >> 8;	
      fp = (float *)p->auxch.auxp + offset;	/* lookup position  */
      diff = *(fp+1) - *fp;
      frac = (float)(phs256 & 255) / 256.0f;	/*  w. interpolation */
      *ar++ =	(*fp + diff*frac) * *p->kamp;	/*  gives output val */
      if ((phs256 += phsinc) >= ltwopi) {
	int nn;
	float	newval, preval;
	phs256 -= ltwopi;		/* at phase wrap,    */
	fp=(float *)p->auxch.auxp;
	preval = *fp;			/*   copy last pnt   */
	*fp = *(fp + p->npts);		/*     to first,     */
	fp++;				/*   apply smoothing */
	nn = p->npts;			/*     up to npts+1  */
	switch(p->method) {
	case 1:
	  do {			/* simple averaging */
	    newval = (*fp + preval) / 2.0f; 
	    preval = *fp;
	    *fp++ = newval;
	  } while (--nn);
	  break;
	case 2:
	  do {			/* stretched avrging */
	    if (rand15() < p->thresh1) {
	      newval = (*fp + preval) / 2.0f;
	      preval = *fp;
	      *fp++ = newval;
	    }
	    else preval = *fp++;
	  } while (--nn);
	  break;
	case 3:
	  do {			/* simple drum */
	    if (rand15() < p->thresh1)
	      newval = -(*fp + preval) / 2.0f;
	    else newval = (*fp + preval) / 2.0f;
	    preval = *fp;
	    *fp++ = newval;
	  } while (--nn);
	  break;
	case 4:
	  do {			/* stretched drum */
	    if (rand15() < p->thresh2) {	
	      if (rand15() < p->thresh1)
		newval = -(*fp + preval) / 2.0f;
	      else newval = (*fp + preval) / 2.0f;
	      preval = *fp;
	      *fp++ = newval;
	    }	   
	    else preval = *fp++;
	  } while (--nn);
	  break;
	case 5:
	  do {			/* weighted avraging */
	    newval = p->param1 * *fp + p->param2 * preval;
	    preval = *fp;
	    *fp++ = newval;
	  } while (--nn);
	  break;
	case 6:
	  do {		/* 1st order recursive filter*/
	    preval = (*fp + preval)/2.0f;
	    *fp++ = preval;
	  } while (--nn);
	  break;
	}
      }	
    }
    while (--nsmps);
    p->phs256 = phs256;
}

#define	RNDMUL	15625L
#define MASK16   0xFFFFL
#define MASK15   0x7FFFL

static short
rand16(void)	/* quick generate a random short between -32768 and 32767 */
{
    static long rand = 1000;
    rand *= RNDMUL;
    rand += 1L;
    rand &= MASK16;
    return((short)rand);
}

static short
rand15(void)	/* quick generate a random short between 0 and 32767 */
{
    static long rand = 1000;
    rand *= RNDMUL;
    rand += 1L;
    rand &= MASK15;
    return((short)rand);
}


/*=========================================================================
 *
 * randint31() 
 *
 * 31 bit Park Miller PRNG using Linus Schrage's method for doing it all
 * with 32 bit variables.
 *
 * Code adapted from Ray Garder's public domain code of July 1997 at:
 * http://www.snippets.org/RG_RAND.C     Thanks!
 * 
 *  Based on "Random Number Generators: Good Ones Are Hard to Find",
 *  S.K. Park and K.W. Miller, Communications of the ACM 31:10 (Oct 1988),
 *  and "Two Fast Implementations of the 'Minimal Standard' Random
 *  Number Generator", David G. Carta, Comm. ACM 33, 1 (Jan 1990), p. 87-88
 *
 *  Linear congruential generator: f(z) = (16807 * z) mod (2 ** 31 - 1)
 *
 *  Uses L. Schrage's method to avoid overflow problems.
 */

#define ria 16807         /* multiplier */
#define rim 2147483647L   /* 2**31 - 1 */
#define riq 127773L       /* m div a */
#define rir 2836          /* m mod a */

#define dv2_31		(4.656612873077392578125e-10f)

long randint31(seed31)
{
    unsigned long rilo, rihi;

    rilo = ria * (long)(seed31 & 0xFFFF);
    rihi = ria * (long)((unsigned long)seed31 >> 16);
    rilo += (rihi & 0x7FFF) << 16;
    if (rilo > rim) {
      rilo &= rim;
      ++rilo;
    }
    rilo += rihi >> 15;
    if (rilo > rim) {
      rilo &= rim;
      ++rilo;
    }
    return (long)rilo;
}

void rndset(RAND *p)
{
    p->new = (*p->sel!=0.0f);
    if (*p->iseed >= 0) {
      if (p->new) {
        float ss = *p->iseed;
        if (ss>1.0f) p->rand = (long) ss;
        else p->rand = (long) (*p->iseed * 2147483648.0f);
        p->rand = randint31(p->rand);
        p->rand = randint31(p->rand);
      }
      else
        p->rand = ((short)(*p->iseed * 32768.0f))&0xffff;
    }
    p->ampcod = (p->XINCODE & 02) ? 1 : 0;	/* (not used by krand) */
}

void krand(RAND *p)
{
    if (p->new) {
      p->rand = randint31(p->rand);         /* result is a 31-bit value */
      *p->ar = (float)p->rand * *p->xamp * dv2_31;
    }
    else {
      short rand = (short)p->rand;
      rand *= RNDMUL;
      rand += 1;
      *p->ar = (float)rand * *p->xamp * dv32768;
      p->rand = rand;
    }
}

void arand(RAND *p)
{
    float	*ar;
    short       rndmul = RNDMUL, n = ksmps;
    float	ampscl;

    ar = p->ar;
    if (!p->new) {
      short  	rand = p->rand;
      if (!(p->ampcod)) {
        ampscl = *p->xamp * dv32768;
        do {
          rand *= rndmul;
          rand += 1;
          *ar++ = (float)rand * ampscl;
        } while (--n);
      }
      else {
        float *xamp = p->xamp;
        do {
          rand *= rndmul;
          rand += 1;
          *ar++ = (float)rand * *xamp++ * dv32768;
        } while (--n);
      }
      p->rand = rand;	/* save current rand */
    }
    else {
      int  	rand = p->rand;
      if (!(p->ampcod)) {
        ampscl = *p->xamp * dv2_31;
        do {
          rand = randint31(rand);
          *ar++ = (float)rand * ampscl;
        } while (--n);
      }
      else {
          float *xamp = p->xamp;
          do {
            rand = randint31(rand);
            *ar++ = (float)rand * *xamp++ * dv2_31;
          } while (--n);
      }
      p->rand = rand;	/* save current rand */
    }

}

void rhset(RANDH *p)
{
    p->new = (*p->sel!=0.0f);
    if (*p->iseed >= 0) {			/* new seed:		*/
      if (!p->new) {
        p->rand = 0xffff&(short)(*p->iseed * 32768L);	/*   init rand integ    */
        p->num1 = *p->iseed;                      /*      store fnum      */
      }
      else {
        float ss = *p->iseed;
        if (ss>1.0f) p->rand = (long) ss;
        else p->rand = (long) (*p->iseed * 2147483648.0f);
        p->rand = randint31(p->rand);
        p->rand = randint31(p->rand);
        p->num1 = (float)p->rand * dv2_31 ;       /*      store fnum      */
      }
      p->phs = 0;			        /*	& phs		*/
    }
    p->ampcod = (p->XINCODE & 02) ? 1 : 0;	/* (not used by krandh) */
    p->cpscod = (p->XINCODE & 01) ? 1 : 0;
}

void krandh(RANDH *p)
{
    *p->ar = p->num1 * *p->xamp;		/* rslt = num * amp	*/
    p->phs += (long)(*p->xcps * kicvt);		/* phs += inc		*/
    if (p->phs >= MAXLEN) {			/* when phs overflows,	*/
      p->phs &= PMASK;				/*	mod the phs	*/
      if (!p->new) {
        short rand = (short)p->rand;
        rand *= RNDMUL;			/*	& recalc number	*/
        rand += 1;
        p->num1 = (float)rand * dv32768;
        p->rand = rand;
      }
      else {
        p->rand = randint31(p->rand);		/*	& recalc number	*/
        p->num1 = (float)p->rand * dv2_31;
      }
    }
}

void randh(RANDH *p)
{
    long	phs = p->phs, inc;
    int	n = ksmps;
    float	*ar, *ampp, *cpsp;

    cpsp = p->xcps;
    ampp = p->xamp;
    ar = p->ar;
    inc = (long)(*cpsp++ * sicvt);
    do {
      *ar++ = p->num1 * *ampp;	/* rslt = num * amp */
      if (p->ampcod)
	ampp++;
      phs += inc;				/* phs += inc	    */
      if (p->cpscod)
	inc = (long)(*cpsp++ * sicvt);
      if (phs >= MAXLEN) {			/* when phs o'flows, */
	phs &= PMASK;
        if (!p->new) {
          short rand = p->rand;
          rand *= RNDMUL;		/*   calc new number */
          rand += 1;
          p->num1 = (float)rand * dv32768;
          p->rand = rand;
        }
        else {
          p->rand = randint31(p->rand);		/*   calc new number */
          p->num1 = (float)p->rand * dv2_31;
        }
      }
    } while (--n);
    p->phs = phs;
}

void riset(RANDI *p)
{
    p->new = (*p->sel!=0.0f);
    if (*p->iseed >= 0) {			/* new seed:		*/
      if (!p->new) {
        short rand = (short)(*p->iseed * 32768.0f); /*	init rand integ */
        rand *= RNDMUL;			/*	to 2nd value	*/
        rand += 1;
        p->num1 = *p->iseed;			/*	store num1,2	*/
        p->num2 = (float)rand * dv32768;
        p->rand = rand;
      }
      else {
        float ss = *p->iseed;
        if (ss>1.0f) p->rand = (long) ss;
        else p->rand = (long) (*p->iseed * 2147483648.0f);
        p->rand = randint31(p->rand);
        p->rand = randint31(p->rand);
        p->num1 = (float)p->rand * dv2_31; 	/*	store num1,2	*/
        p->rand = randint31(p->rand);
        p->num2 = (float)p->rand * dv2_31;
      }
      p->phs = 0;				/*	& clear phs	*/
      p->dfdmax = (p->num2 - p->num1) / fmaxlen;  /* & diff	*/
    }
    p->ampcod = (p->XINCODE & 02) ? 1 : 0;	/* (not used by krandi) */
    p->cpscod = (p->XINCODE & 01) ? 1 : 0;
}

void krandi(RANDI *p)
{					/* rslt = (num1 + diff*phs) * amp */
    *p->ar = (p->num1 + (float)p->phs * p->dfdmax) * *p->xamp;
    p->phs += (long)(*p->xcps * kicvt);	/* phs += inc		*/
    if (p->phs >= MAXLEN) {		/* when phs overflows,	*/
      p->phs &= PMASK;			/*	mod the phs	*/
      if (!p->new) {
        short rand = p->rand;
        rand *= RNDMUL;		/*	recalc random	*/
        rand += 1;
        p->num1 = p->num2;		/*	& new num vals	*/
        p->num2 = (float)rand * dv32768;
        p->rand = rand;
      }
      else {
        p->rand = randint31(p->rand);	/*	recalc random	*/
        p->num1 = p->num2;		/*	& new num vals	*/
        p->num2 = (float)p->rand * dv2_31;
      }
      p->dfdmax = (p->num2 - p->num1) / fmaxlen;
    }
}

void randi(RANDI *p)
{
    long	phs = p->phs, inc;
    int		n = ksmps;
    float	*ar, *ampp, *cpsp;

    cpsp = p->xcps;
    ampp = p->xamp;
    ar = p->ar;
    inc = (long)(*cpsp++ * sicvt);
    do {
      *ar++ = (p->num1 + (float)phs * p->dfdmax) * *ampp;
      if (p->ampcod)
	ampp++;
      phs += inc;				/* phs += inc	    */
      if (p->cpscod)
	inc = (long)(*cpsp++ * sicvt);		/*   (nxt inc)	    */
      if (phs >= MAXLEN) {			/* when phs o'flows, */
	phs &= PMASK;
        if (!p->new) {
          short rand = p->rand;
          rand *= RNDMUL;			/*   calc new numbers*/
          rand += 1;
          p->num1 = p->num2;
          p->num2 = (float)rand * dv32768;
          p->rand = rand;
        }
        else {
          p->rand = randint31(p->rand);		/*   calc new numbers*/
          p->num1 = p->num2;
          p->num2 = (float)p->rand * dv2_31;
        }
	p->dfdmax = (p->num2 - p->num1) / fmaxlen;
      }
    } while (--n);
    p->phs = phs;
}

