/**************************************************************/
/***********PVINTERP, PVCROSS************/
/*** By Richard Karpen 1996************/
/************************************************************/
#include <math.h>
#include "cs.h"		
#include "dsputil.h"
#include "fft.h"
#include "pvoc.h"
#include "pvinterp.h"
#include "soundio.h"
#include "oload.h"

extern	float	esr;
extern	int	ksmps;
extern	char	errmsg[];
extern  int     odebug;

static	int	pdebug = 0;
static	PVBUFREAD	*pvbufreadaddr;


#define WLN   1		/* time window is WLN*2*ksmps long */
#define OPWLEN (2*WLN*ksmps)	/* manifest used for final time wdw */

/************************************************************/
/*************PVBUFREAD**************************************/
/************************************************************/


void pvbufreadset(PVBUFREAD *p)
{
    char     pvfilnam[MAXNAME];
    MEMFIL   *mfp, *ldmemfile(char *);
    PVSTRUCT *pvh;
    int      frInc, chans, size; /* THESE SHOULD BE SAVED IN PVOC STRUCT */
	
    pvbufreadaddr=p;

    if (p->auxch.auxp == NULL) {              /* if no buffers yet, alloc now */
        float *fltp;
        auxalloc((long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN) * sizeof(float),
		 &p->auxch);
	fltp = (float *) p->auxch.auxp;
	p->lastPhase = fltp;   fltp += PVDATASIZE;    /* and insert addresses */
	p->fftBuf = fltp;	/* fltp += PVFFTSIZE; */ /* Not needed */
    }
    
    if (*p->ifilno == sstrcod) {                         /* if strg name given */
      extern EVTBLK *currevent;
      extern char *unquote(char *name);
      if (p->STRARG == NULL) strcpy(pvfilnam,unquote(currevent->strarg));
      else strcpy(pvfilnam, unquote(p->STRARG));
    }
    else if ((long)*p->ifilno < strsmax && strsets != NULL &&
	     strsets[(long)*p->ifilno])
      strcpy(pvfilnam, strsets[(long)*p->ifilno]);
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno); /* else pvoc.filnum   */
    if ((mfp = p->mfp) == NULL ||
	strcmp(mfp->filename, pvfilnam) != 0) {	/* if file not already readin */
	if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
	    sprintf(errmsg,"PVOC cannot load %s", pvfilnam);
	    goto pverr;
	}
    }
    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
	sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
		pvfilnam, pvh->magic );
	goto pverr;
    }
    p->frSiz = pvh->frameSize;
    frInc    = pvh->frameIncr;
    chans    = pvh->channels;
    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
	sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
		pvfilnam, p->asr, esr);
	warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
	sprintf(errmsg,"unsupported PVOC data format %ld in %s",
		pvh->dataFormat, pvfilnam);
	goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
	sprintf(errmsg,"PVOC frame %d bigger than %ld in %s",
		p->frSiz, PVFRAMSIZE, pvfilnam);
	goto pverr;
    }
    if (p->frSiz < PVFRAMSIZE/8) {
	sprintf(errmsg,"PVOC frame %ld seems too small in %s",
		p->frSiz, pvfilnam);
	goto pverr;
    }
    if (chans != 1) {
	sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
	        chans, pvfilnam);
	goto pverr;
    }
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float)));
    p->frPktim = ((float)ksmps)/((float)frInc);
    p->frPrtim = esr/((float)frInc);
    size = pvfrsiz(p);		/* size used in def of OPWLEN ? */
    p->prFlg = 1;    /* true */
    
    if ((OPWLEN/2 + 1)>PVWINLEN ) {
	sprintf(errmsg, "ksmps of %d needs wdw of %d, max is %d for pv %s\n",
		ksmps, (OPWLEN/2 + 1), PVWINLEN, pvfilnam);
	goto pverr;
    }
    
    return;

pverr:
    initerror(errmsg);
    }


void pvbufread(PVBUFREAD *p)
{
    float  frIndx;
    float  *buf = p->fftBuf;
    int    size = pvfrsiz(p);

    if (p->auxch.auxp==NULL) {  /* RWD fix */
      initerror("pvbufread: not initialized");
      return;
    }
    if (pdebug)  fprintf(stderr, "<%7.4f>",*p->ktimpnt);
    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
	perferror("PVOC timpnt < 0");
	return;
    }
    if (frIndx > (float)p->maxFr) {  /* not past last one */
	frIndx = (float)p->maxFr;
	if (p->prFlg) {
	    p->prFlg = 0;   /* false */
	    warning("PVOC ktimpnt truncated to last frame");
	}
    }
    FetchIn(p->frPtr,buf,size,frIndx);

    p->buf=buf;
}


/************************************************************/
/*************PVINTERP**************************************/
/************************************************************/
void pvinterpset(PVINTERP *p)
{
    int      i;
    char     pvfilnam[MAXNAME];
    MEMFIL   *mfp, *ldmemfile(char *);
    PVSTRUCT *pvh;
    int      frInc, chans, size; /* THESE SHOULD BE SAVED IN PVOC STRUCT */

    p->pvbufread = pvbufreadaddr;
	
    if (p->auxch.auxp == NULL) {              /* if no buffers yet, alloc now */
        float *fltp;
        auxalloc((long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN) * sizeof(float),
		 &p->auxch);
	fltp = (float *) p->auxch.auxp;
	p->lastPhase = fltp;   fltp += PVDATASIZE;    /* and insert addresses */
	p->fftBuf = fltp;      fltp += PVFFTSIZE;
	p->dsBuf = fltp;       fltp += PVFFTSIZE;
	p->outBuf = fltp;      fltp += PVFFTSIZE;
	p->window = fltp;
    }
    if (*p->ifilno == sstrcod) {                         /* if strg name given */
      extern EVTBLK *currevent;
      extern char *unquote(char *name);
      if (p->STRARG == NULL) strcpy(pvfilnam,unquote(currevent->strarg));
      else strcpy(pvfilnam, unquote(p->STRARG));
    }
    else if ((long)*p->ifilno < strsmax && strsets != NULL &&
	     strsets[(long)*p->ifilno])
      strcpy(pvfilnam, strsets[(long)*p->ifilno]);
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno); /* else pvoc.filnum   */
    if ((mfp = p->mfp) == NULL ||
	strcmp(mfp->filename, pvfilnam) != 0) { /* if file not already readin */
	if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
	    sprintf(errmsg,"PVOC cannot load %s", pvfilnam);
	    goto pverr;
	}
    }
    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
	sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
		pvfilnam, pvh->magic );
	goto pverr;
    }
    p->frSiz = pvh->frameSize;
    frInc    = pvh->frameIncr;
    chans    = pvh->channels;
    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
	sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
		pvfilnam, p->asr, esr);
	warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
	sprintf(errmsg,"unsupported PVOC data format %ld in %s",
		pvh->dataFormat, pvfilnam);
	goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
	sprintf(errmsg,"PVOC frame %d bigger than %ld in %s",
		p->frSiz, PVFRAMSIZE, pvfilnam);
	goto pverr;
    }
    if (p->frSiz < PVFRAMSIZE/8) {
	sprintf(errmsg,"PVOC frame %ld seems too small in %s",
		p->frSiz, pvfilnam);
	goto pverr;
    }
    if (chans != 1) {
	sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
	        chans, pvfilnam);
	goto pverr;
    }
    /* Check that pv->frSiz is a power of two too ? */
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->baseFr = 0;  /* point to first data frame */
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float)));
    /* highest possible frame index */
    p->frPktim = ((float)ksmps)/((float)frInc);
    /* factor by which to mult expand phase diffs (ratio of samp spacings) */
    p->frPrtim = esr/((float)frInc);
    /* factor by which to mulitply 'real' time index to get frame index */
    size = pvfrsiz(p);		/* size used in def of OPWLEN ? */
    p->scale = 32768.0f*2.0f*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));
    /* 2*incr/OPWLEN scales down for win ovlp, windo'd 1ce (but 2ce?) */
    /* 1/frSiz is the required scale down before (i)FFT */
    p->prFlg = 1;    /* true */
    p->opBpos = 0;
    p->lastPex = 1.0f;	    /* needs to know last pitchexp to update phase */
    /* Set up time window */
    for (i=0; i < pvdasiz(p); ++i) {  /* or maybe pvdasiz(p) */
	p->lastPhase[i] = 0.0f;
    }
    if ((OPWLEN/2 + 1)>PVWINLEN) {
	sprintf(errmsg, "ksmps of %d needs wdw of %d, max is %d for pv %s\n",
		ksmps, (OPWLEN/2 + 1), PVWINLEN, pvfilnam);
	goto pverr;
    }
    for (i=0; i < OPWLEN/2+1; ++i)    /* time window is OPWLEN long */
        p->window[i] = (0.54f-0.46f*(float)cos(TWOPI*(float)i/(float)OPWLEN));
    /* NB : HAMMING */
    for (i=0; i< pvfrsiz(p); ++i)
        p->outBuf[i] = 0.0f;
    MakeSinc( /* p->sncTab */ );  	/* sinctab is same for all instances */
    p->plut = (float *)AssignBasis(NULL, pvfrsiz(p));    /* SET UP NONET FFT */

    return;

pverr:
    initerror(errmsg);
    }


void pvinterp(PVINTERP *p)
{
    float  *ar = p->rslt;
    float  frIndx;
    float  *buf = p->fftBuf;
    float  *buf2 = p->dsBuf;
    int	   asize = pvdasiz(p); /* fix */
    float  *plut = p->plut;
    int    size = pvfrsiz(p);
    int    buf2Size, outlen;
    int    circBufSize = PVFFTSIZE;
   /* int    specwp = (int)*p->ispecwp; */  /* spectral warping flag */
    float  pex;
    PVBUFREAD *q = p->pvbufread;
    long	 i,j ;

    if (p->auxch.auxp==NULL) {  /* RWD Fix */
      initerror("pvinterp: not initialized");
      return;
    }
    if (pdebug) fprintf(stderr, "<%7.4f>",*p->ktimpnt);
    pex = *p->kfmod;
    outlen = (int)(((float)size)/pex);
    /* use outlen to check window/krate/transpose combinations */
    if (outlen>PVFFTSIZE) { /* Maximum transposition down is one octave */
			    /* ..so we won't run into buf2Size problems */
	perferror("PVOC transpose too low");
	return;
    }
    if (outlen<2*ksmps) {   /* minimum post-squeeze windowlength */
	perferror("PVOC transpose too high");
	return;
    }
    buf2Size = OPWLEN;     /* always window to same length after DS */
    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
        perferror("PVOC timpnt < 0");
	return;
    }
    if (frIndx > (float)p->maxFr) { /* not past last one */
	frIndx = (float)p->maxFr;
	if (p->prFlg) {
	    p->prFlg = 0;   /* false */
	    warning("PVOC ktimpnt truncated to last frame");
	}
    }
    FetchIn(p->frPtr,buf,size,frIndx);
   
/* Here's where the interpolation happens ***********************/
    for (i=0, j=1; i<=size; i+=2, j+=2) {
		buf[i] = buf[i] * *p->kampscale2;
		q->buf[i] = q->buf[i] * *p->kampscale1;
		buf[j] = buf[j] * *p->kfreqscale2;
		q->buf[j] = q->buf[j] * *p->kfreqscale1;
		buf[i] = (buf[i]  + ((q->buf[i]-buf[i]) * *p->kampinterp));
		buf[j] = (buf[j]  + ((q->buf[j]-buf[j]) * *p->kfreqinterp));
    }
/*******************************************************************/
    FrqToPhase(buf, asize, pex*(float)ksmps, p->asr,
	   /*a0.0*/(float)(.5 * ( (pex / p->lastPex) - 1) ));
    /* Offset the phase to align centres of stretched windows, not starts */
    RewrapPhase(buf,asize,p->lastPhase);
    Polar2Rect(buf,size);
    buf[1] = 0.0f; buf[size+1] = 0.0f;	/* kill spurious imag at dc & fs/2 */
    FFT2torl((complex *)buf,size,1,/*a pex*/ p->scale, (complex *)plut);
    /* CALL TO NONET FFT */
    PackReals(buf, size);
    if (pex != 1.0)
	UDSample(buf,(0.5f*((float)size - pex*(float)buf2Size))/*a*/,buf2,
		 size, buf2Size, pex);
    else
	CopySamps(buf+(int)(0.5f*((float)size - pex*(float)buf2Size))/*a*/,buf2,
		  buf2Size);
	ApplyHalfWin(buf2, p->window, buf2Size);	/* */

    addToCircBuf(buf2, p->outBuf, p->opBpos, ksmps, circBufSize);
    writeClrFromCircBuf(p->outBuf, ar, p->opBpos, ksmps, circBufSize);
    p->opBpos += ksmps;
    if (p->opBpos > circBufSize)
        p->opBpos -= circBufSize;
    addToCircBuf(buf2+ksmps,p->outBuf,p->opBpos,buf2Size-ksmps,circBufSize);
    p->lastPex = pex;	     /* needs to know last pitchexp to update phase */
}
    


/************************************************************/
/*************PVCROSS**************************************/
/************************************************************/
void pvcrossset(PVCROSS *p)
{
    int      i;
    char     pvfilnam[MAXNAME];
    MEMFIL   *mfp, *ldmemfile(char *);
    PVSTRUCT *pvh;
    int      frInc, chans, size; /* THESE SHOULD BE SAVED IN PVOC STRUCT */

    p->pvbufread = pvbufreadaddr;

    if (p->auxch.auxp == NULL) {              /* if no buffers yet, alloc now */
        float *fltp;
        auxalloc((long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN) * sizeof(float),
		 &p->auxch);
	fltp = (float *) p->auxch.auxp;
	p->lastPhase = fltp;   fltp += PVDATASIZE;    /* and insert addresses */
	p->fftBuf = fltp;      fltp += PVFFTSIZE;
	p->dsBuf = fltp;       fltp += PVFFTSIZE;
	p->outBuf = fltp;      fltp += PVFFTSIZE;
	p->window = fltp;
    }
    if (*p->ifilno == sstrcod) {                         /* if strg name given */
      extern EVTBLK *currevent;
      extern char *unquote(char *name);
      if (p->STRARG == NULL) strcpy(pvfilnam,unquote(currevent->strarg));
      else strcpy(pvfilnam, unquote(p->STRARG));
    }
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno); /* else pvoc.filnum   */
    if ((mfp = p->mfp) == NULL ||
	strcmp(mfp->filename, pvfilnam) != 0) {/* if file not already readin */
	if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
	    sprintf(errmsg,"PVOC cannot load %s", pvfilnam);
	    goto pverr;
	}
    }
    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
	sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
		pvfilnam, pvh->magic );
	goto pverr;
    }
    p->frSiz = pvh->frameSize;
    frInc    = pvh->frameIncr;
    chans    = pvh->channels;
    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
	sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
		pvfilnam, p->asr, esr);
	warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
	sprintf(errmsg,"unsupported PVOC data format %ld in %s",
		pvh->dataFormat, pvfilnam);
	goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
	sprintf(errmsg,"PVOC frame %d bigger than %ld in %s",
		p->frSiz, PVFRAMSIZE, pvfilnam);
	goto pverr;
    }
    if (p->frSiz < PVFRAMSIZE/8) {
	sprintf(errmsg,"PVOC frame %ld seems too small in %s",
		p->frSiz, pvfilnam);
	goto pverr;
    }
    if (chans != 1) {
	sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
	        chans, pvfilnam);
	goto pverr;
    }
    /* Check that pv->frSiz is a power of two too ? */
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->baseFr = 0;  /* point to first data frame */
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float) ) );
    /* highest possible frame index */
    p->frPktim = ((float)ksmps)/((float)frInc);
    /* factor by which to mult expand phase diffs (ratio of samp spacings) */
    p->frPrtim = esr/((float)frInc);
    /* factor by which to mulitply 'real' time index to get frame index */
    size = pvfrsiz(p);		/* size used in def of OPWLEN ? */
    p->scale = 32768.0f*2.0f*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));
    p->prFlg = 1;    /* true */
    p->opBpos = 0;
    p->lastPex = 1.0f;	    /* needs to know last pitchexp to update phase */
    /* Set up time window */
    for (i=0; i < pvdasiz(p); ++i) {  /* or maybe pvdasiz(p) */
	p->lastPhase[i] = 0.0f;
    }
    if ((OPWLEN/2 + 1)>PVWINLEN ) {
	sprintf(errmsg, "ksmps of %d needs wdw of %d, max is %d for pv %s\n",
		ksmps, (OPWLEN/2 + 1), PVWINLEN, pvfilnam);
	goto pverr;
    }
    for (i=0; i < OPWLEN/2+1; ++i)    /* time window is OPWLEN long */
        p->window[i] = (0.54f-0.46f*(float)cos(TWOPI*(float)i/(float)OPWLEN));
    /* NB : HAMMING */
    for(i=0; i< pvfrsiz(p); ++i)
        p->outBuf[i] = 0.0f;
    MakeSinc( /* p->sncTab */ );  	/* sinctab is same for all instances */
    p->plut = (float *)AssignBasis(NULL, pvfrsiz(p));    /* SET UP NONET FFT */

    return;

pverr:
    initerror(errmsg);
}


void pvcross(PVCROSS *p)
{
    int    n;
    float  *ar = p->rslt;
    float  frIndx;
    float  *buf = p->fftBuf;
    float  *buf2 = p->dsBuf;
    int	   asize = pvdasiz(p); /* fix */
    float  *plut = p->plut;
    int    size = pvfrsiz(p);
    int    buf2Size, outlen;
    int    circBufSize = PVFFTSIZE;
    int    specwp = (int)*p->ispecwp;   /* spectral warping flag */
    float  pex;
    PVBUFREAD *q = p->pvbufread;
    long   i,j;
    float  ampscale1=*p->kampscale1;
    float  ampscale2=*p->kampscale2;

    if (p->auxch.auxp==NULL) {  /* RWD Fix */
      initerror("pvcross: not initialized");
      return;
    }
    if (pdebug) fprintf(stderr, "<%7.4f>",*p->ktimpnt);
    pex = *p->kfmod;
    outlen = (int)(((float)size)/pex);
    /* use outlen to check window/krate/transpose combinations */
    if (outlen>PVFFTSIZE) { /* Maximum transposition down is one octave */
         		    /* ..so we won't run into buf2Size problems */
	perferror("PVOC transpose too low");
	return;
    }
    if (outlen<2*ksmps) {  /* minimum post-squeeze windowlength */
	perferror("PVOC transpose too high");
	return;
    }
    buf2Size = OPWLEN;     /* always window to same length after DS */
    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
	perferror("PVOC timpnt < 0");
	return;
    }
    if (frIndx > (float)p->maxFr) { /* not past last one */
	frIndx = (float)p->maxFr;
	if (p->prFlg) {
	    p->prFlg = 0;   /* false */
	    warning("PVOC ktimpnt truncated to last frame");
	}
    }
   
    FetchIn(p->frPtr,buf,size,frIndx);
   	 
/**** Apply amplitudes from pvbufread ********/
    for (i=0, j=0; i<=size; i+=2, j++) 
      buf[i] = (buf[i] * ampscale2) + (q->buf[i] * ampscale1);
/***************************************************/
    
    FrqToPhase(buf, asize, pex*(float)ksmps, p->asr,
	       /*a0.0*/(float)(.5 * ( (pex / p->lastPex) - 1) ));
    /* Offset the phase to align centres of stretched windows, not starts */
    RewrapPhase(buf,asize,p->lastPhase);
/**/if (specwp == 0 || (p->prFlg)++ == -(int)specwp) /* ?screws up when prFlg used */
  { /* specwp=0 => normal; specwp = -n => just nth frame */
    if (specwp<0) printf("PVOC debug : one frame gets through \n"); /*	*/
    if (specwp>0)
        PreWarpSpec(buf, asize, pex); /*	    */
    Polar2Rect(buf,size);

    buf[1] = 0.0f; buf[size+1] = 0.0f;	/* kill spurious imag at dc & fs/2 */
    FFT2torl((complex *)buf,size,1,/*a pex*/ p->scale, (complex *)plut);
    /* CALL TO NONET FFT */
    PackReals(buf, size);
    if (pex != 1.0)
	UDSample(buf,(.5f*((float)size - pex*(float)buf2Size))/*a*/,buf2,
		 size, buf2Size, pex);
    else
	CopySamps(buf+(int)(.5*((float)size - pex*(float)buf2Size))/*a*/,buf2,
		  buf2Size);
/*a*/    if (specwp>=0) ApplyHalfWin(buf2, p->window, buf2Size);	/* */
/**/      }
    else
        for (n = 0; n<buf2Size; ++n)
          buf2[n] = 0.0f;		/*	*/
    addToCircBuf(buf2, p->outBuf, p->opBpos, ksmps, circBufSize);
    writeClrFromCircBuf(p->outBuf, ar, p->opBpos, ksmps, circBufSize);
    p->opBpos += ksmps;
    if (p->opBpos > circBufSize)     p->opBpos -= circBufSize;
    addToCircBuf(buf2+ksmps,p->outBuf,p->opBpos,buf2Size-ksmps,circBufSize);
    p->lastPex = pex;	     /* needs to know last pitchexp to update phase */
}
    
