/********************************************/
/* wrap and mirror UGs by Gabriel Maldonado */
/********************************************/

#include "cs.h"  
#include "wrap.h"
#include <math.h>


void wrap(WRAP *p)
{
    register float 	*adest= p->xdest;
    register float  *asig = p->xsig;
    register float	xlow, xhigh, xsig; 
    register int loopcount = ksmps;

    if ((xlow=*p->xlow) >= (xhigh=*p->xhigh))	{
        register float 	xaverage;
        xaverage = (xlow + xhigh) / 2;
        do *adest++ = xaverage;
        while (--loopcount);
    }
	else  do {
		if ((xsig=(float) *asig++) >= xlow )	
			*adest++ = (float)(xlow + fmod(xsig - xlow, fabs(xlow-xhigh)));
		else	
			*adest++ = (float)(xhigh- fmod(xhigh- xsig, fabs(xlow-xhigh)));
	} while (--loopcount);
}


void kwrap(WRAP *p)
{
    register float xsig, xlow, xhigh;

    if ((xlow=*p->xlow) >= (xhigh=*p->xhigh)) *p->xdest = (xlow + xhigh) / 2;  
    else {
		if ((xsig=*p->xsig) >= xlow )	
			*p->xdest = (float)(xlow + fmod(xsig - xlow, fabs(xlow-xhigh)));
		else							
			*p->xdest = (float)(xhigh- fmod(xhigh- xsig, fabs(xlow-xhigh)));
	}
}


/*---------------------------------------------------------------------*/


void kmirror(WRAP *p)
{
    register float  xsig, xlow, xhigh;
    xsig = *p->xsig;
    xhigh= *p->xhigh;
    xlow = *p->xlow;

    if (xlow >= xhigh) 	*p->xdest = (xlow + xhigh) / 2;  
    else {
      kw_label:
        if ((xsig <= xhigh) && (xsig >= xlow)) 	*p->xdest = xsig;
        else {
            if (xsig > xhigh){ 
                xsig = xhigh+xhigh - xsig;
                goto kw_label;
            }
            else {
                xsig = xlow + xlow - xsig  ;
                goto kw_label;
            }
        }
    }
}


void mirror(WRAP *p)
{
    register float 	*adest, *asig;
    register float	xlow, xhigh, xaverage, xsig; 
    register int loopcount = ksmps;

    adest = p->xdest;
    asig  = p->xsig;
    xlow = *p->xlow;
    xhigh = *p->xhigh;

    if (xlow >= xhigh)	{
        xaverage = (xlow + xhigh) / 2;
        do *adest++ = xaverage;
        while (--loopcount);
    }

    do	{
        xsig = *asig++;
      w_label:
        if ((xsig <= xhigh) && ( xsig >= xlow ))   *adest++ = xsig;
        else {
            if (xsig > xhigh){
                xsig = xhigh+xhigh - xsig;
                goto w_label;
            }
            else {
                xsig = xlow+xlow - xsig;
                goto w_label;
            }
        }
    } while (--loopcount);
}


void trig_set(TRIG *p)	 /* trig by G.Maldonado */
{
	p->old_sig = 0.0;

}

void trig(TRIG *p)
{
 	switch ((int) (*p->kmode + .5)) {
		case	0:	  /* down-up */
			if (p->old_sig <= *p->kthreshold && *p->ksig > *p->kthreshold ) 
				*p->kout = 1.;
			else
				*p->kout = 0.;
			break;
		case	1:	 /* up-down */
			if (p->old_sig >= *p->kthreshold && *p->ksig < *p->kthreshold ) 
				*p->kout = 1.;
			else
				*p->kout = 0.;
			break;
		case	2:	 /* both */
			if 	((p->old_sig <= *p->kthreshold && *p->ksig > *p->kthreshold) ||
				 (p->old_sig >= *p->kthreshold && *p->ksig < *p->kthreshold ) )
				*p->kout = 1.;
			else
				*p->kout = 0.;
			break;  
		default: 
			perferror(" bad imode value");
			
	}
 	p->old_sig = *p->ksig;
}

/*-------------------------------*/

/* interpolation opcodes by G.Maldonado */
void interpol(INTERPOL *p)
{
	float point_value = (float)((*p->point - *p->imin ) * (1./(*p->imax - *p->imin)));
	*p->r = point_value * (*p->val2 - *p->val1) + *p->val1;
}

void nterpol_init(INTERPOL *p)
{
	p->point_factor = 1.0f/(*p->imax - *p->imin) ;
}

void knterpol(INTERPOL *p)
{
 	float point_value = (*p->point - *p->imin ) * p->point_factor;
 	*p->r = point_value * (*p->val2 - *p->val1) + *p->val1;
}

void anterpol(INTERPOL *p)
{
    
 	register float point_value = (*p->point - *p->imin ) * p->point_factor;
    register float *out = p->r, *val1 = p->val1, *val2 = p->val2;
	register int loopcount = ksmps;
    do	{
	 	*out++ = point_value * (*val2++ - *val1) + *val1++;
    } while (--loopcount);


}



