/******************************************/
/*  Clarinet model ala Smith              */
/*  after McIntyre, Schumacher, Woodhouse */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#if !defined(__Clarinet_h)
#define __Clarinet_h

#include "physutil.h"

/**********************************************/
/*  One break point linear reed table object  */
/*  by Perry R. Cook, 1995-96                 */
/*  Consult McIntyre, Schumacher, & Woodhouse */
/*        Smith, Hirschman, Cook, Scavone,    */
/*        more for information.               */
/**********************************************/

typedef struct ReedTabl {
    float	offSet;
    float	slope;
    float	lastOutput;
} ReedTabl;

float ReedTabl_LookUp(ReedTabl*, float);

/*******************************************/
/*  One Zero Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */ 
/*  The parameter gain is an additional    */
/*  gain parameter applied to the filter   */  
/*  on top of the normalization that takes */
/*  place automatically.  So the net max   */
/*  gain through the system equals the     */
/*  value of gain.  sgain is the combina-  */
/*  tion of gain and the normalization     */
/*  parameter, so if you set the poleCoeff */
/*  to alpha, sgain is always set to       */
/*  gain / (1.0 - fabs(alpha)).            */
/*******************************************/

typedef struct OneZero {
    float gain;                 /* Filter subclass */
    float inputs;
    float lastOutput;           /* End of Filter */
    float zeroCoeff;
    float sgain;
} OneZero;

void make_OneZero(OneZero*);
float OneZero_tick(OneZero*, float);
void OneZero_print(OneZero *);

/* ********************************************************************** */
typedef struct CLARIN {
    OPDS    h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*reedStffns, *attack, *dettack, *noiseGain, *vibFreq;
    float	*vibAmt, *ifn, *lowestFreq; 

    FUNC	*vibr;          /* Table for vibrato */
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
/*     float	v_phaseOffset; */
    DLineL	delayLine;
    ReedTabl	reedTable;
    OneZero	filter;
    Envelope	envelope;
    Noise	noise;
    long	length;
    float	outputGain;
    int		kloop;
} CLARIN;


/* void clarinetset(CLARINET *p); */
/* void clarinet(CLARINET *p) */

#endif
