/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: tap.c,v 4.17 1999/03/10 20:56:04 erik Rel $";
#endif
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <assert.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "machine.h"
#include "util.h"
#include "loadsave.h"
#include "tzx.h"
#include "tap.h"
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_TAPE) { x } }
#else
#define DEB(x)
#endif
static int tapConvertFile(FILE *);
int
TapNewFile(void)
{
FILE *fp;
struct stat sbuf;
void *mmp;
if (!(fp = tmpfile()) || tapConvertFile(fp) < 0)
{
return -1;
}
(void)fflush(fp);
(void)fstat(fileno(fp), &sbuf);
mmp = mmap(NULL, (size_t)sbuf.st_size, PROT_READ, MAP_PRIVATE, fileno(fp),
(off_t)0);
(void)fclose(fp);
if (mmp == (void *)-1)
{
Msg(M_PERR, "mmap failed");
return -1;
}
Munmap((void *)TpInBegin, (size_t)(TpInEnd - TpInBegin));
TpInBegin = (uns8 *)mmp;
TpInEnd = TpInBegin + sbuf.st_size;
TzxNewFile();
return 0;
}
void
TapLoadBlock(uns8 *data, int len)
{
uns8 byte, crc;
uns16 swap;
int error = 0;
DEB(Msg(M_DEBUG, "TAP: %s, id = %02x, block = %5d",
F1 & C_FLAG ? "loading" : "verifying", (int)A1, len););
if (len)
{
{
int de = (DE ? (int)DE : 65636) + 2;
len = de > len ? len : de;
}
crc = *data++;
len--;
for (error = 1; ; DE--, IX++)
{
byte = *data++;
crc ^= byte;
if (!--len)
{
if (!crc)
{
error = 0;
}
#ifdef DEBUG
else if (GETCFG(debug) & D_TAPE)
{
DEB(Msg(M_DEBUG, "TAP: checksum error"););
}
#endif
break;
}
if (F1 & C_FLAG)
{
Machine->writeMem(IX, byte);
}
else
{
if (byte != Machine->readMem(IX))
{
break;
}
}
}
}
if (error)
{
F1 &= ~(Z_FLAG | C_FLAG);
}
else
{
F1 |= Z_FLAG | C_FLAG;
}
swap = AF; AF = AF1; AF1 = swap;
PC = 0x05E2;
}
void
TapSaveBlock(FILE *fp)
{
uns16 length;
int byte, crc;
length = DE + 2;
(void)putc(length & 255, fp);
(void)putc(length / 256, fp);
(void)putc((int)A, fp);
crc = A;
while (DE--)
{
byte = Machine->readMem(IX);
(void)putc(byte, fp);
IX++;
crc ^= byte;
}
(void)putc(crc, fp);
(void)fflush(fp);
F |= C_FLAG;
IX += DE;
DE = 0;
IFF1 = 1;
IFF2 = 1;
RET();
}
static int
tapConvertFile(FILE *fp)
{
unsigned char *buf = (unsigned char *)"ZXTape!\032\001\012";
unsigned int length;
uns8 *scanPtr = TpInBegin;
if (fwrite(buf, 1, (size_t)10, fp) != 10)
{
return -1;
}
while (scanPtr < TpInEnd)
{
length = GET2(scanPtr, 0);
scanPtr += 2;
DEB(Msg(M_DEBUG, "TAP: scaning, id = %02x, pos = %6d, block = %5d",
length ? *scanPtr : 0xff, scanPtr - 2 - TpInBegin, length););
if (scanPtr >= TpInEnd)
{
Msg(M_ERR, "premature end on <%s>", TpTapeName(TO_READ));
break;
}
if (scanPtr + length > TpInEnd)
{
Msg(M_WARN, "truncating last TAP block");
length = TpInEnd - scanPtr;
}
(void)fputc(0x10, fp);
(void)fputc(0xe8, fp);
(void)fputc(0x03, fp);
(void)fputc((int)(length & 0xff), fp);
(void)fputc((int)(length >> 8), fp);
if (fwrite(scanPtr, 1, (size_t)length, fp) != (size_t)length)
{
return -1;
}
scanPtr += length;
}
return 0;
}
