/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Erik Kunze
*
* $Id: machine.h,v 1.7 1998/12/28 12:55:03 erik Rel $
*******************************************************************************/
#ifndef _XZX_MACHINE_H
#define _XZX_MACHINE_H
typedef struct _machineSettings {
const char *name;
int basicRom;
int romType;
unsigned int tvLines;
unsigned int tstatesPerLine;
unsigned int tstatesPerFrame;
unsigned int intLine;
unsigned int topBorder;
uns8 (*readOpcode)(uns16);
uns8 (*readMem)(uns16);
void (*writeMem)(uns16, uns8);
uns8 (*inPort)(uns16);
void (*outPort)(uns16, uns8);
void (*initPages)(void);
void (*pageIn)(int, int);
} MachineSettings;
enum {
SP_48_2, SP_48_3,
SP_128,
#ifdef XZX_PLUS3
SP_3,
#endif
#ifdef XZX_PENTAGON
SP_PENTAGON,
#endif
#ifdef XZX_SCORPION
SP_SCORPION,
#endif
NMACHINES
};
extern void MachineInit(void);
extern void SelectModel(int, int);
extern MachineSettings Machines[NMACHINES], *Machine;
extern unsigned char *UlaDelay;
#endif
