/********************************************************************************
* Copyright (c) Erik Kunze 1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef AYCHIP_AUDIO
#ifndef lint
static char ay8912_c[] = "$Id: ay8912.c,v 4.13 1999/04/06 16:02:06 erik Rel $";
#endif
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include <assert.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "machine.h"
#include "util.h"
#include "emul.h"
#include "audio.h"
struct AY8912 {
uns8 regs[16];
unsigned char *buf;
unsigned int lastPos;
unsigned int updateStep;
int periodA, periodB, periodC, periodN, periodE;
int countA, countB, countC, countN, countE;
unsigned int volA, volB, volC, volE;
unsigned char envelopeA, envelopeB, envelopeC;
unsigned char outputA, outputB, outputC, outputN;
signed char countEnv;
unsigned char hold, alternate, attack, holding;
int rng;
unsigned int volTable[32];
};
#define AY_AFINE		0
#define AY_ACOARSE		1
#define AY_BFINE		2
#define AY_BCOARSE		3
#define AY_CFINE		4
#define AY_CCOARSE		5
#define AY_NOISEPER		6
#define AY_ENABLE		7
#define AY_AVOL			8
#define AY_BVOL			9
#define AY_CVOL			10
#define AY_EFINE		11
#define AY_ECOARSE		12
#define AY_ESHAPE		13
#define AY_PORTA		14
#define AY_PORTB		15
#define AY_CLOCK		1773400.0
#define AY_STEP			0x8000
#ifdef STEREO_AUDIO
#define AY_BUFSIZE		(3 * Audio.samplesPerFrame)
#else
#define AY_BUFSIZE		Audio.samplesPerFrame
#endif
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
static void ayWriteRegister(uns8, uns8);
static void ayUpdate(unsigned int);
static void aySetGain(int);
void (*AyOutByte)(uns8, uns8);
static struct AY8912 psg;
void
AyInit(void)
{
(void)memset(&psg, 0, sizeof(psg));
psg.updateStep = (double)AY_STEP * Audio.sampleRate * 8.0 / AY_CLOCK;
DEB(Msg(M_DEBUG, "AU: updateStep %11u", psg.updateStep););
psg.buf = Malloc((size_t)AY_BUFSIZE, "AyInit");
Audio.ayBuf = psg.buf;
aySetGain(0x00);
AyReset();
}
void
AyReInit(void)
{
assert(psg.buf != NULL);
free(psg.buf);
psg.buf = Malloc((size_t)AY_BUFSIZE, "AyInit");
Audio.ayBuf = psg.buf;
}
void
AyReset(void)
{
int i;
psg.rng = 1;
psg.outputA = 0;
psg.outputB = 0;
psg.outputC = 0;
psg.outputN = 0xff;
for (i = AY_AFINE; i <= AY_ESHAPE; i++)
{
ayWriteRegister((uns8)i, 0);
}
}
void
AyOut(uns8 reg, uns8 val)
{
unsigned int pos;
pos = TSTATES / Audio.tstatesPerSample;
if (pos != psg.lastPos)
{
if (pos > Audio.samplesPerFrame)
{
pos = Audio.samplesPerFrame;
}
ayUpdate(pos);
}
ayWriteRegister(reg, val);
}
static void
ayWriteRegister(uns8 reg, uns8 val)
{
int old;
assert(reg < sizeof(psg.regs));
psg.regs[reg] = val;
switch (reg)
{
#define SET_CHANNEL_FREQ(ch) \
\
case AY_##ch##COARSE:												\
psg.regs[AY_##ch##COARSE] &= 0x0f;								\
case AY_##ch##FINE:													\
old = psg.period##ch;											\
psg.period##ch = psg.regs[AY_##ch##FINE] +						\
(psg.regs[AY_##ch##COARSE] << 8);				\
if (psg.period##ch == 0)										\
{																\
psg.period##ch = 1;											\
}																\
psg.period##ch *= psg.updateStep;								\
psg.count##ch += psg.period##ch - old;							\
if (psg.count##ch <= 0)											\
{																\
psg.count##ch = 1;											\
}																\
break;
SET_CHANNEL_FREQ(A);
SET_CHANNEL_FREQ(B);
SET_CHANNEL_FREQ(C);
case AY_NOISEPER:
psg.regs[AY_NOISEPER] &= 0x1f;
old = psg.periodN;
psg.periodN = psg.regs[AY_NOISEPER];
if (psg.periodN == 0)
{
psg.periodN = 1;
}
psg.periodN *= psg.updateStep;
psg.countN += psg.periodN - old;
if (psg.countN <= 0)
{
psg.countN = 1;
}
break;
case AY_ENABLE:
break;
#define SET_CHANNEL_VOL(ch) \
case AY_##ch##VOL:													\
psg.regs[AY_##ch##VOL] &= 0x1f;									\
psg.envelope##ch = psg.regs[AY_##ch##VOL] & 0x10;				\
if (psg.envelope##ch)											\
{																\
psg.vol##ch = psg.volE;										\
}																\
else															\
{																\
psg.vol##ch = psg.volTable[psg.regs[AY_##ch##VOL]			\
? (psg.regs[AY_##ch##VOL] << 1) + 1	\
: 0];								\
}																\
break;
SET_CHANNEL_VOL(A);
SET_CHANNEL_VOL(B);
SET_CHANNEL_VOL(C);
case AY_EFINE:
case AY_ECOARSE:
old = psg.periodE;
psg.periodE = psg.regs[AY_EFINE] + (psg.regs[AY_ECOARSE] << 8);
if (psg.periodE == 0)
{
psg.periodE = psg.updateStep >> 1;
}
else
{
psg.periodE *= psg.updateStep;
}
psg.countE += psg.periodE - old;
if (psg.countE <= 0)
{
psg.countE = 1;
}
break;
case AY_ESHAPE:
psg.regs[AY_ESHAPE] &= 0x0f;
psg.attack = psg.regs[AY_ESHAPE] & 0x04 ? 0x1f : 0x00;
if ((psg.regs[AY_ESHAPE] & 0x08) == 0)
{
psg.hold = 1;
psg.alternate = psg.attack;
}
else
{
psg.hold = psg.regs[AY_ESHAPE] & 0x01;
psg.alternate = psg.regs[AY_ESHAPE] & 0x02;
}
psg.countE = psg.periodE;
psg.countEnv = 0x1f;
psg.holding = 0;
psg.volE = psg.volTable[psg.countEnv ^ psg.attack];
if (psg.envelopeA)
{
psg.volA = psg.volE;
}
if (psg.envelopeB)
{
psg.volB = psg.volE;
}
if (psg.envelopeC)
{
psg.volC = psg.volE;
}
break;
}
}
void
AyFillBuffer(void)
{
if (psg.lastPos < Audio.samplesPerFrame)
{
ayUpdate(Audio.samplesPerFrame);
}
psg.lastPos = 0;
}
static void
ayUpdate(unsigned int pos)
{
unsigned char outn;
#ifdef STEREO_AUDIO
unsigned char *bufferA = &psg.buf[psg.lastPos];
unsigned char *bufferB = bufferA + Audio.samplesPerFrame;
unsigned char *bufferC = bufferB + Audio.samplesPerFrame;
#else
unsigned char *buffer = &psg.buf[psg.lastPos];
#endif
int length, left, nextevent;
int volA, volB, volC;
assert(pos <= Audio.samplesPerFrame);
length = pos - psg.lastPos;
#define PROCESS_OUTPUT(ch,mask) \
\
if (psg.regs[AY_ENABLE] & (mask))										\
{																		\
if (psg.count##ch <= length * AY_STEP)								\
{																	\
psg.count##ch += length * AY_STEP;								\
}																	\
psg.output##ch = 1;													\
}																		\
else if (!psg.regs[AY_##ch##VOL])										\
{																		\
\
if (psg.count##ch <= length * AY_STEP)								\
{																	\
psg.count##ch += length * AY_STEP;								\
}																	\
}
PROCESS_OUTPUT(A, 0x01);
PROCESS_OUTPUT(B, 0x02);
PROCESS_OUTPUT(C, 0x04);
if ((psg.regs[AY_ENABLE] & 0x38) == 0x38)
{
if (psg.countN <= length * AY_STEP)
{
psg.countN += length * AY_STEP;
}
}
outn = (psg.outputN | psg.regs[AY_ENABLE]);
while (length--)
{
volA = volB = volC = 0;
left = AY_STEP;
do
{
nextevent = psg.countN < left ? psg.countN : left;
#define PROCESS_CHANNEL(ch,mask) \
if (outn & (mask))												\
{																\
if (psg.output##ch)											\
{															\
vol##ch += psg.count##ch;								\
}															\
psg.count##ch -= nextevent;									\
\
while (psg.count##ch <= 0)									\
{															\
psg.count##ch += psg.period##ch;						\
if (psg.count##ch > 0)									\
{														\
psg.output##ch ^= 1;								\
if (psg.output##ch)									\
{													\
vol##ch += psg.period##ch;						\
}													\
break;												\
}														\
psg.count##ch += psg.period##ch;						\
vol##ch += psg.period##ch;								\
}															\
if (psg.output##ch)											\
{															\
vol##ch -= psg.count##ch;								\
}															\
}																\
else															\
{																\
psg.count##ch -= nextevent;									\
while (psg.count##ch <= 0)									\
{															\
psg.count##ch += psg.period##ch;						\
if (psg.count##ch > 0)									\
{														\
psg.output##ch ^= 1;								\
break;												\
}														\
psg.count##ch += psg.period##ch;						\
}															\
}
PROCESS_CHANNEL(A, 0x08);
PROCESS_CHANNEL(B, 0x10);
PROCESS_CHANNEL(C, 0x20);
psg.countN -= nextevent;
if (psg.countN <= 0)
{
if ((psg.rng + 1) & 2)
{
psg.outputN = ~psg.outputN;
outn = (psg.outputN | psg.regs[AY_ENABLE]);
}
if (psg.rng & 1)
{
psg.rng ^= 0x28000;
}
psg.rng >>= 1;
psg.countN += psg.periodN;
}
left -= nextevent;
} while (left > 0);
if (!psg.holding)
{
if ((psg.countE -= AY_STEP) <= 0)
{
do
{
psg.countEnv--;
psg.countE += psg.periodE;
} while (psg.countE <= 0);
if (psg.countEnv < 0)
{
if (psg.hold)
{
if (psg.alternate)
{
psg.attack ^= 0x1f;
}
psg.holding = 1;
psg.countEnv = 0;
}
else
{
if (psg.alternate && (psg.countEnv & 0x20))
{
psg.attack ^= 0x1f;
}
psg.countEnv &= 0x1f;
}
}
psg.volE = psg.volTable[psg.countEnv ^ psg.attack];
if (psg.envelopeA)
{
psg.volA = psg.volE;
}
if (psg.envelopeB)
{
psg.volB = psg.volE;
}
if (psg.envelopeC)
{
psg.volC = psg.volE;
}
}
}
volA *= psg.volA;
volB *= psg.volB;
volC *= psg.volC;
#ifdef STEREO_AUDIO
*bufferA++ = (volA / AY_STEP) >> 8;
*bufferB++ = (volB / AY_STEP) >> 8;
*bufferC++ = (volC / AY_STEP) >> 8;
#else
*buffer++ = ((volA + volB + volC) / AY_STEP) >> 8;
#endif
}
psg.lastPos  = pos;
}
static void
aySetGain(int gain)
{
int i;
double out;
gain &= 0xff;
out = 21845.0;
while (gain--)
{
out *= 1.023292992;
}
for (i = 31; i; i--)
{
psg.volTable[i] = out > 21845.0 ? 21845U : (unsigned int)out;
out /= 1.188502227;
}
psg.volTable[0] = 0;
}
#endif
