/* This file Copyright 1992 by Clifford A. Adams */
/* score.c
 *
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCORE
/* if SCORE is undefined, no code should be compiled */
/* sort the following includes later */
#include "cache.h"
#include "bits.h"
#include "artio.h"		/* for openart var.*/
#include "final.h"		/* int_count */
#include "head.h"		/* ? */
#include "intrp.h"		/* for filexp */
#include "ng.h"			/* art */
#include "ngdata.h"
#include "search.h"		/* for regex */
#include "rt-util.h"		/* spinner */
#include "term.h"		/* input_pending() */
#include "trn.h"		/* ngname */
#include "util.h"		/* several */
#ifdef SCAN
#include "scan.h"
#include "sorder.h"
#include "scanart.h"
#include "samain.h"
#include "samisc.h"
#include "svirt.h"	/* virtual group interactions */
#endif
#ifdef NEWSFILTER
#include "filtpipe.h"
#endif
#include "INTERN.h"
#include "score.h"
#include "EXTERN.h"
#include "scorefile.h"
#include "scoresave.h"
#include "score-easy.h"		/* interactive menus and such */
#include "INTERN.h"	/* to allow initialization */

void
sc_init(pend_wait)
bool_int pend_wait;	/* if true, enter pending mode when scoring... */
{
    int i;
    ART_NUM a;

    if ((lastart==0) || (lastart<absfirst)) {
/*	printf("No articles exist to be scored.\n") FLUSH; /* */
	return;
    }
    if (use_runback) {
	if (firstart>lastart)
	    return;			/* no scores would be saved */
	sc_delay = FALSE;
	pend_wait = TRUE;
    }
    sc_sf_force_init = TRUE;		/* generally force initialization */
#ifdef SCAN
    if (sv_in_setup) {
	sc_delay = FALSE;
	pend_wait = FALSE;
	sc_sf_force_init = FALSE;
    }
#endif
    if (sc_delay)			/* requested delay? */
	return;
    sc_sf_delay = FALSE;

    /* set up from environment variables */
    i = atoi(getval("SCOREMODE","1"));
    if (i>=0) {
#ifdef NICEBG
	sc_mode_nicebg = (i & 1);	/* nicebg: default on */
#endif
	/* default verbosity is OFF now (12/15/93). */
	sf_verbose = (i & 2);		/* verbose readin: default off */
    }

    if (use_runback) {
#ifdef NICEBG
	sc_mode_nicebg = FALSE;
#endif
	sf_verbose = FALSE;
    }

/* Consider the relationships between scoring and article scan mode.
 * Should one be able to initialize the other?  How much can they depend on
 * each other when both are #defined?
 * Consider this especially in a later redesign or porting these systems
 * to other newsreaders.
 */
    kill_thresh_active = FALSE;  /* kill thresholds are generic */
    /* July 24, 1993: changed default of sc_savescores to TRUE */
    sc_savescores = TRUE;
    sc_use_newsclip = FALSE;

    /* Initialize scoring arrays. */
    i = AOFFSET(lastart)+1;	/* number of articles (maximum) */
    scores = (int*)safemalloc(i*sizeof(int));
    scoreflags =  (char*)safemalloc(i*sizeof(char));

    /* initialize some of the arrays. */
    for (i=AOFFSET(absfirst);i<=AOFFSET(lastart);i++) {
      scores[i] = 0;		/* something reasonable */
      scoreflags[i] = (char)0;	/* all flags unset */
    }
    /* let user know if/when there are avail. articles... */
    sc_announce_elig = TRUE;
/* CONSIDER: (for sc_init callers) is lastart properly set yet? */
    sc_fill_max = absfirst - 1;
#ifdef SCAN
    if (sa_mode_read_elig || (firstart>lastart))
	sc_fill_read = TRUE;
    else
#endif
	sc_fill_read = FALSE;

    if (sf_verbose && (!use_runback)
#ifdef SCAN
	&& (!sv_in_setup)
#endif
       ) {
	    printf("\nScoring articles...") FLUSH;
	    fflush(stdout);		/* print it *now* */
	 }

    sc_initialized = TRUE;	/* little white lie for lookahead */
    /* now is a good time to load a saved score-list which may exist */
    if (!sc_rescoring) {	/* don't load if rescoring */
	sc_load_scores();	/* will be quiet if non-existent */
	i = firstart;
	if (sc_fill_read)
	    i = absfirst;
	if (sc_sf_force_init)
	    i = lastart+1;	/* skip loop */
	for (;i<=lastart;i++)
	    if ((!SCORED(i)) && (sc_fill_read || !was_read(i)))
		break;
	if (i==lastart)		/* all scored */
	    sc_sf_delay = TRUE;
    }
    if (sc_sf_force_init)
	sc_sf_delay = FALSE;

    if (!sc_sf_delay)
        sf_init();	/* initialize the scorefile code */

    sc_do_spin = FALSE;
    for (i=lastart;i>=absfirst;i--)
	if (SCORED(i))
	    break;
    if (i<absfirst) {			/* none scored yet */
	/* score one article, or give up */
	for (a=lastart;a>=absfirst;a--) {
	    sc_score_art(a,TRUE);	/* I want it *now* */
	    if (SCORED(a))
		break;
	}
	if (a < absfirst) {		/* no articles scored */
	    if (sf_verbose)
		printf("\nNo articles available for scoring\n");
	    sc_cleanup();
	    return;
	}
    }

    /* if no scoring rules/methods are present, score everything */
    if (!(sc_use_newsclip || sf_num_entries)) {
	/* score everything really fast */
	for (a=lastart;a>=absfirst;a--)
	    sc_score_art(a,TRUE);
    }
    if (pend_wait) {
	bool waitflag;		/* if true, use key pause */

	waitflag = TRUE;	/* normal mode: wait for key first */
#ifdef SCAN
	if (sv_in_setup)
	    waitflag = FALSE;
#endif
	if (use_runback)
	    waitflag = FALSE;
	if (sf_verbose && waitflag) {
#ifdef PENDING
	    printf("(press key to start reading)");
#else /* !PENDING */
	    printf("(interrupt to start reading)");
#endif
	    fflush(stdout);
	}
	if (waitflag
#ifdef SCAN
            || sv_loop
#endif
        ) {
	    setspin(SPIN_FOREGROUND);
	    sc_do_spin = TRUE;		/* really do it */
	}
	sc_lookahead(TRUE,waitflag);	/* jump in *now* */
	if (waitflag
#ifdef SCAN
|| sv_loop
#endif
) {
	    sc_do_spin = FALSE;
	    setspin(SPIN_POP);
	}
    }
    if (sf_verbose && (!use_runback)
#ifdef SCAN
	&& (!sv_in_setup)
#endif
    )
	    printf("\n") FLUSH;
    sc_announce_elig = FALSE;

    sc_initialized = TRUE;
}

/* grow the scoring arrays and initialize them */
void
sc_grow(oldlast,newlast)
ART_NUM oldlast,newlast;
{
    int i;

    if (!sc_initialized)
	return;		/* the articles will be scored by sc_init() */
    /* grow the arrays */
    i = AOFFSET(newlast)+1;	/* number of articles in group */
    scores = (int*)saferealloc((char*)scores,i*sizeof(int));
    scoreflags = (char*)saferealloc((char *)scoreflags,i*sizeof(char));

    /* initialize the grown portion of the arrays */
    for (i=AOFFSET(oldlast+1);i<=AOFFSET(newlast);i++) {
      scoreflags[i] = (char)0;		/* all flags unset */
    }
}

void
sc_cleanup()
{
    if (!sc_initialized)
	return;

    if (sc_savescores)
	sc_save_scores();
    sc_loaded_count = 0;

#ifdef SCAN
    if (!(sv_loop && sv_in_setup))
#endif
	if (sf_verbose && !use_runback) {
	    printf("\nCleaning up scoring...");
	    fflush(stdout);
	}

    /* free the arrays */
    free(scores);
    free(scoreflags);
    if (!sc_sf_delay)
	sf_clean();	/* let the scorefile do whatever cleaning it needs */
    sc_initialized = FALSE;
#ifdef SCAN
    if (!(sv_loop && sv_in_setup))
#endif
	if (sf_verbose && !use_runback)
	    printf("Done.\n") FLUSH;
}

void
sc_set_score(a,score)
ART_NUM a;
int score;
{
    if (is_unavailable(a))	/* newly unavailable */
	return;
    if (kill_thresh_active && (score<=kill_thresh) && (!was_read(a)))
	oneless_artnum(a);

    scores[AOFFSET(a)] = score;	/* update the score */
    scoreflags[AOFFSET(a)] |= SFLAG_SCORED;
#ifdef SCAN
    s_order_changed = TRUE;	/* resort */
#endif


#ifdef UNDEF
/* eligibility announcment undefined August 15, 1993 */
/* (CAA: I think it causes too much confusion for minimal information.)
    /* let the reader know if we have eligible articles */
    if (sc_announce_elig && ((!was_read(a))
#ifdef SCAN
	|| sa_mode_read_elig
#endif
	)) {
	    if ((!use_runback)
#ifdef SCAN
		&& (!(sv_loop && sv_in_setup))
#endif
	    ) {
		printf("!");
		fflush(stdout);
	    }
	    sc_announce_elig = FALSE;
    }
#endif /* UNDEF */
}

#ifdef NEWSFILTER
static long sc_our_pid = 0; /* gross, but needed for newsfilter */

long
sc_newsclip_score(a)
ART_NUM a;
{
    static char sc_artname[LBUFLEN];	/* overkill */

#ifdef USE_NNTP
    artopen_full = TRUE;	/* get the *whole* article */
    if (!artopen(a)) {
	artopen_full = FALSE;
	return(0);		/* be sure it is open and created */
    }
    artopen_full = FALSE;
    fclose(artfp);		/* close the article */
    artfp = Nullfp;
    openart = 0;

    if (sc_our_pid == 0)
	sc_our_pid = getpid();
    sprintf(sc_artname, "/tmp/rrn.%ld", sc_our_pid);
    filter_art(sc_artname,(char *)0,ngname,a);
#else /* !USE_NNTP */
    filter_art(spool, ngdir, ngname, a);
#endif /* USE_NNTP */
    return(filter_score_art(a));
}
#endif /* NEWSFILTER */

/* Hopefully people will write more scoring routines later */
void
sc_score_art_basic(a)
ART_NUM a;
{
    int score;

    score = 0;
#ifdef NEWSFILTER
    if (sc_have_newsclip && sc_use_newsclip)
	score += sc_newsclip_score(a);
#endif /* NEWSFILTER */
    score += sf_score(a);	/* get a score */
    if (sc_do_spin)		/* appropriate to spin */
	spin(20);		/* keep the user amused */
    sc_set_score(a,score);	/* set the score */
}

/* Returns an article's score, scoring it if necessary */
int
sc_score_art(a,now)
ART_NUM a;
bool_int now;	/* if TRUE, sort the scores if necessary... */
{
    if ((a<absfirst) || (a>lastart)) {
/* 	printf("\nsc_score_art: illegal article# %d\n",a) FLUSH; /* */
	return(LOWSCORE);		/* definitely unavailable */
    }
    if (is_unavailable(a))
	return(LOWSCORE);

    if (sc_initialized == FALSE) {
	sc_delay = FALSE;
	sc_sf_force_init = TRUE;
	sc_init(FALSE);
	sc_sf_force_init = FALSE;
    }

    if (!SCORED(a)) {
	if (sc_sf_delay) {
	    sf_init();
	    sc_sf_delay = FALSE;
	}
	sc_score_art_basic(a);
    }
    if (is_unavailable(a))
	return(LOWSCORE);
    return(scores[AOFFSET(a)]);
}
	
/* scores articles in a range */
/* CONSIDER: option for scoring only unread articles (obey sc_fill_unread?) */
void
sc_fill_scorelist(first,last)
ART_NUM first,last;
{
    int i;

    for (i=first;i<=last;i++) {
	(void)sc_score_art(i,FALSE);	/* will be sorted later... */
    }
}

/* consider having this return a flag (is finished/is not finished) */
void
sc_lookahead(flag, nowait)
/* flag not used now, but when used... */
bool_int flag;		/* TRUE means sort now
			 * FALSE means wait until later... */
bool_int nowait;	/* TRUE means start scoring immediately (group entry)
			 * FALSE means use NICEBG if available */
{
    ART_NUM oldart = openart;
    ART_POS oldartpos;

    if (!sc_initialized)
	return;			/* no looking ahead now */

    if (!use_runback)
#ifdef PENDING
	if (input_pending())
	    return;		/* delay as little as possible */
#endif
    if (!sc_initialized)
	return;		/* don't score then... */
#ifdef PENDING
#ifdef NICEBG
    if (sc_mode_nicebg && !nowait)
	if (wait_key_pause(10))		/* wait up to 1 second for a key */
	    return;
#endif
#endif
    if (oldart)			/* Was there an article open? */
	oldartpos = ftell(artfp);	/* where were we in it? */
#ifndef PENDING
    if (int_count)
	int_count = 0;		/* clear the interrupt count */
#endif
    /* prevent needless looping below */
    if ((sc_fill_max<firstart) && !sc_fill_read)
	sc_fill_max = firstart-1;
    while ((sc_fill_max<lastart)
#ifdef PENDING
	   && (!input_pending() || use_runback)
#endif
    ) { 
#ifndef PENDING
	if (int_count>0) {
	    int_count = 0;
	    return;	/* user requested break */
	}
#endif
	sc_fill_max++;
	/* skip over some articles quickly */
	while ((sc_fill_max<lastart) &&
	       ((SCORED(sc_fill_max)) ||
		((!sc_fill_read) && was_read(sc_fill_max))))
		    sc_fill_max++;

	if (SCORED(sc_fill_max))
	    continue;
	if (!sc_fill_read)	/* score only unread */
	    if (was_read(sc_fill_max))
		continue;
	(void)sc_score_art(sc_fill_max,FALSE);
    }
    if (oldart) {	    /* copied from cheat.c */
	artopen(oldart);
	fseek(artfp,oldartpos,0);	/* do not screw the pager */
    }
}

int
sc_percent_scored()
{
    int i,total,scored;

    if (!sc_initialized)
	return(0);	/* none scored */
    if (sc_fill_max==lastart)
	return(100);
    i = firstart;
#ifdef SCAN
    if (sa_mode_read_elig)
	i = absfirst;
#endif
    total = scored = 0;
    for (;i<=lastart;i++) {
	if (is_unavailable(i))
	    continue;
	if (was_read(i)
#ifdef SCAN
	    && !sa_mode_read_elig
#endif
	   )
		continue;
	total++;
	if (SCORED(i))
	    scored++;
    } /* for */
    if (total == 0)
	return(0);
    return((scored*100)/total);
}

void
sc_rescore_arts()
{
    ART_NUM a;
    bool old_spin;

    if (!sc_initialized) {
	if (sc_delay) {
	    sc_delay = FALSE;
	    sc_sf_force_init = TRUE;
	    sc_init(TRUE);
	    sc_sf_force_init = FALSE;
	}
    } else if (sc_sf_delay) {
	sf_init();
	sc_sf_delay = FALSE;
    }
    if (!sc_initialized) {
	printf("\nScoring is not initialized, aborting command.\n") FLUSH;
	return;
    }
    /* I think sc_do_spin will always be false, but why take chances? */
    old_spin = sc_do_spin;
    setspin(SPIN_FOREGROUND);
    sc_do_spin = TRUE;				/* amuse the user */
    for (a=absfirst;a<=lastart;a++)
	if (is_available(a))
	    sc_score_art_basic(a);		/* rescore it then */
    sc_do_spin = old_spin;
    setspin(SPIN_POP);
#ifdef SCAN
    if (sa_in) {
	s_ref_all = TRUE;
	s_refill = TRUE;
	s_top_ent = 0;		/* make sure the refill starts from top */
    }
#endif
}

/* Wrapper to isolate scorefile functions from the rest of the world */
/* corrupted (:-) 11/12/92 by CAA for online rescoring */
void
sc_append(line)
char *line;
{
    char filechar;
    if (!line)		/* empty line */
	return;

    if (!sc_initialized) {
	if (sc_delay) {
	    sc_delay = FALSE;
	    sc_sf_force_init = TRUE;
	    sc_init(TRUE);
	    sc_sf_force_init = FALSE;
	}
    } else if (sc_sf_delay) {
	sf_init();
	sc_sf_delay = FALSE;
    }
    if (!sc_initialized) {
	printf("\nScoring is not initialized, aborting command.\n") FLUSH;
	return;
    }
    if (!*line) {
	line = sc_easy_append();
	if (!line)
	    return;		/* do nothing with empty string */
    }
    filechar = *line;			/* first char */
    sf_append(line);
    if (filechar == '!') {
	printf("\nRescoring articles...");
	fflush(stdout);
	sc_rescore_arts();
	printf("Done.\n") FLUSH;
#ifdef SCAN
	if (sa_initialized)
	    s_top_ent = -1;		/* reset top of page */
#endif
    }
}

void
sc_rescore()
{
    sc_rescoring = TRUE;	/* in case routines need to know */
    sc_cleanup();	/* get rid of the old */
    sc_init(TRUE);	/* enter the new... (wait for rescore) */
#ifdef SCAN
    if (sa_initialized) {
	s_top_ent = -1;	/* reset top of page */
	s_refill = TRUE;	/* make sure a refill is done */
    }
#endif
    sc_rescoring = FALSE;
}

/* May have a very different interface in the user versions */
void
sc_score_cmd(line)
char *line;
{
    long i,j;
    char *s;

    if (!sc_initialized) {
	if (sc_delay) {
	    sc_delay = FALSE;
	    sc_sf_force_init = TRUE;
	    sc_init(TRUE);
	    sc_sf_force_init = FALSE;
	}
    } else if (sc_sf_delay) {
	sf_init();
	sc_sf_delay = FALSE;
    }
    if (!sc_initialized) {
	printf("\nScoring is not initialized, aborting command.\n") FLUSH;
	return;
    }
    if (!*line) {
	line = sc_easy_command();
	if (!line)
	    return;		/* do nothing with empty string */
	if (*line == '\"') {
	    buf[0] = '\0';
	    sc_append(buf);
	    return;
	}
    }
    switch (*line) {
        case 'f':	/* fill (useful when PENDING is unavailable) */
	    printf("Scoring more articles...");
	    fflush(stdout);	/* print it now */
	    setspin(SPIN_FOREGROUND);
	    sc_do_spin = TRUE;
	    sc_lookahead(TRUE,FALSE);
	    sc_do_spin = FALSE;
	    setspin(SPIN_POP);
	    /* consider a "done" message later,
	     * *if* lookahead did all the arts */
	    printf("\n") FLUSH;
	    break;
	case 'r':	/* rescore */
	    printf("Rescoring articles...\n") FLUSH;
	    sc_rescore();
	    break;
	case 's':	/* verbose score for this article */
/* CONSIDER: A VERBOSE-SCORE ROUTINE (instead of this hack) */
	    i = 0;	/* total score */
/* yet another hack--this should be factored into its own routine */
#ifdef NEWSFILTER
	    if (sc_have_newsclip && sc_use_newsclip) {
		i = sc_newsclip_score(art);
		printf("\nNewsClip filter score: %ld\n",i) FLUSH;
	    }
#endif /* NEWSFILTER */
	    sf_score_verbose = TRUE;
	    j = sf_score(art);
	    sf_score_verbose = FALSE;
	    printf("Scorefile total score: %ld\n",j);
	    i += j;
	    printf("Total score is %ld\n",i) FLUSH;
	    break;
#ifdef NEWSFILTER
	case 'n':	/* talk to news filter (Newsclip) */
	    for (s=line+1;((*s==' ')||(*s=='\t'));s++)
		; /* EMPTY */
	    /* make printing optional?  or just remove? */
	    if (filter_command(s))
		printf("Filter command accepted.\n");
	    else
		printf("Filter command rejected.\n");
	    break;
#endif
	case 'e':	/* edit scorefile or other file */
	    for (s=line+1;((*s==' ')||(*s=='\t'));s++)
		; /* EMPTY */
	    if (!*s)	/* empty name for scorefile */
		sf_edit_file("\"");	/* edit local scorefile */
	    else
		sf_edit_file(s);
	    break;
#ifdef UNDEF
	case 't':	/* test vector */
	    /* may do something later */
#endif
	default:
	    printf("Unknown scoring command |%s|\n",line);
    } /* switch */
}

void
sc_kill_threshold(thresh)
int thresh;		/* kill all articles with this score or lower */
{
    ART_NUM a;

    for (a=firstart;a<=lastart;a++) {
	if ((scores[AOFFSET(a)]<=thresh) &&
		(!was_read(a))
#ifdef SCAN
	    /* CAA 6/19/93: this is needed for zoom mode */
	    && (sa_basic_elig(sa_artnum_to_ent(a)))
#endif
	) {
		oneless_artnum(a);
	} /* if */
    } /* for */
}
#endif /* SCORE */
