/*
 * FILE:    sndfile_au.h
 * PROGRAM: RAT
 * AUTHOR:  Orion Hodson
 *
 * $Revision: 1.3 $
 * $Date: 1999/05/25 21:50:55 $
 *
 * Copyright (c) 1998-99 University College London
 * All rights reserved.
 *
 */

#ifndef __SNDFILE_AU_H__
#define __SNDFILE_AU_H__

int sun_read_hdr(FILE *pf, char **state, sndfile_fmt_t *fmt);        /* Returns true if can decode header */

int sun_read_audio(FILE *pf, char* state, sample *buf, int samples); /* Returns the number of samples read */

int sun_write_hdr(FILE *fp, char **state, const sndfile_fmt_t *fmt);

int sun_write_audio(FILE *fp, char *state, sample *buf, int samples);

int sun_free_state(char **state);

int sun_get_format(char *state, sndfile_fmt_t *fmt);
#endif /* __SNDFILE_AU_H__ */
