/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		OSMutex.cpp

	Contains:	Platform - independent mutex header. The implementation of this object
				is platform - specific. Each platform must define an independent
				QTSSMutex.h & QTSSMutex.cpp file.
				
				This file is for Mac OS X Server only

	$Log: OSMutex.cpp,v $
	Revision 1.1  1999/06/01 20:12:34  serenyi
	Replacement for QTMutex
	
	Revision 1.2  1999/02/19 23:06:13  ds
	Created
		

*/

#include "OSMutex.h"
#include <stdlib.h>

OSMutex::OSMutex(UInt32 tag)
: fTag(tag)
{
#if !__PTHREADS__
	fMutex = mymutex_alloc();
#else
	static pthread_mutexattr_t	*sMutexAttr=NULL;
	if (sMutexAttr == NULL)
	{
		sMutexAttr = (pthread_mutexattr_t*)malloc(sizeof(pthread_mutexattr_t));
		pthread_mutexattr_init(sMutexAttr);
		pthread_mutexattr_setkind_np(sMutexAttr, PTHREAD_MUTEX_RECURSIVE_NP);
	}	
	(void)pthread_mutex_init(&fMutex, sMutexAttr);
#endif
}

OSMutex::~OSMutex()
{
#if !__PTHREADS__
	mymutex_free(fMutex);
#else
	pthread_mutex_destroy(&fMutex);
#endif
}


