.TH sci2for 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
sci2for - scilab function to Fortran routine conversion
.SH CALLING SEQUENCE
.nf
txt=sci2for(fun,nam,vtps)
.fi
.SH PARAMETERS
.TP 10
fun
: Scilab function
.TP
nam
: character string, the name of generated subroutine
.TP 10
vtps
: list
.TP 10
txt
: string, text of the subroutine Fortran code
.SH DESCRIPTION

The elements of the list \fVvtps\fR give the type and dimensions 
of variables of the calling sequence :
.nf
vtps(i)=list(typ,row_dim,col_dim)
.fi
where :
.RS
.TP
typ
: is a character string giving the type of the variable :
.RS
.TP 
"0" 
: constant,integer vector or matrix
.TP
"1" 
: constant,double precision vector or matrix
.TP
"10"
: character string
.RE
.TP
row_dim 
: character string (row dimension)
.TP
col_dim 
: character string (column dimension)
.RE
.TP
txt
: Fortran code
.LP
Generated code may use routines of scilab libraries and some others
whose source code may be found in <SCIDIR>/util/sci2for.f
.SH REMARKS
This function is just a try. Only simple function may be
translated. Many function calls have not  yet Fortran equivalent, to add the
translation of a new function call you may define a scilab function.
whose name is f_<name of function>. see
<SCIDIR>/macros/sci2for/f_*.sci files for examples.
.LP
The following keywords :
.nf
 work,iwork,ierr
 iw*  iiw*      
 ilbN   (N integer)          
.fi
may not appear in the function code.
.SH SEE ALSO
function
