.TH "TK_SetVar" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_SetVar - Set a tcl/tk variable value
.sp
Author: Bertrand Guiheneuf
.sp
This routine allows to set a variable within the tcl/tk interpreter. 
.sp
.sp
.SH Usage
TK_SetVar(varname, value)
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBvarname\fP : string character
Contains the name of the tcl/tk variable to set.
.nr bi 1
.TP
o 
\fBvalue\fP : string character
Contains the value to set up in the tcl/tk variable
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
None
.SH Description
When tcl/tk support is enabled in scilab, this routine can be used to set up
the value of a tcl/tk variable. This can be useful to change some value
in the tcl/tk without having to build a tcl/tk instruction (and use TK_EvalStr).
.SH EXAMPLE
TK_EvalStr('toplevel .foo');
// creates a toplevel TK window. TK_EvalStr('label .foo.l -textvariable tvar');
// create a static label
TK_EvalStr('pack .foo.l');
// pack the label widget. It appears on the screen.
TK_SetVar('tvar','This text has been set directly within scilab');.SH See also
ScilabEval, TK_EvalFile, TK_EvalStr, TK_GetVar
