.TH execstr 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
execstr - scilab instructions execution by evaluation of strings
.SH CALLING SEQUENCE
.nf
execstr(instr)
ierr=execstr(instr,'errcatch')
.fi
.SH PARAMETERS
.TP 10
instr 
: vector of character strings, scilab instruction to be executed.
.TP
ierr
: integer, 0 or error number

.SH DESCRIPTION
executes the Scilab instructions given  in argument \fVinstr\fR

If an error is encountered while executing instructions defined in
\fVinstr\fR, if 'errcatch' flag is present \fVexecstr\fR issues an
error message, abort execution of the \fVinstr\fR instructions and
resume with \fVierr\fR equal to the error number,if 'errcatch' flag is
not present, standard error handling works.

.SH EXAMPLE
.nf
execstr('a=1') // sets a=1.
execstr('1+1') // does nothing (while evstr('1+1') returns 2)

execstr(['if %t then';
         '  a=1';
         '  b=a+1';
         'else'
         ' b=0'
         'end'])

execstr('a=zzzzzzz','errcatch')
.fi 
.SH SEE ALSO
evstr

