/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: rep_fwd.c,v 1.3 1999/11/07 22:27:57 xfmail Exp $
 */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

static FD_config_reply *reply_obj;

void Reply_Call(FL_OBJECT * obj, long param) {
}

void reply_conf(int set_default, FD_config_reply * form) {
    reply_obj = form;

    fl_clear_choice(reply_obj->Reply_INType);
    fl_addto_choice(reply_obj->Reply_INType, "no auto include");
    fl_addto_choice(reply_obj->Reply_INType, "indented");
    fl_addto_choice(reply_obj->Reply_INType, "not indented");
    fl_set_choice(reply_obj->Reply_INType,
                  Config.getIntDefault(conf_name, "include", 2,
                                       set_default));
    fl_clear_choice(reply_obj->Reply_MIME);
    fl_addto_choice(reply_obj->Reply_MIME, "never");
    fl_addto_choice(reply_obj->Reply_MIME, "always");
    fl_addto_choice(reply_obj->Reply_MIME, "ask");
    fl_set_choice(reply_obj->Reply_MIME,
                  Config.getIntDefault(conf_name, "inclmime", 3,
                                       set_default));
    fl_clear_choice(reply_obj->Reply_All);
    fl_addto_choice(reply_obj->Reply_All, "never");
    fl_addto_choice(reply_obj->Reply_All, "always");
    fl_addto_choice(reply_obj->Reply_All, "ask");
    fl_set_choice(reply_obj->Reply_All,
                  Config.getIntDefault(conf_name, "inclrecp", 3,
                                       set_default));
    fl_set_input(reply_obj->Reply_Prefix,
                 Config.getStringDefault(conf_name, "prefix", ">",
                                         set_default));
    fl_set_input(reply_obj->Reply_Str,
                 Config.getStringDefault(conf_name, "replystr",
                                         "On %d %f wrote:%n",
                                         set_default));
    fl_set_input(reply_obj->Reply_And,
                 Config.getStringDefault(conf_name, "replyexand", "",
                                         set_default));
    fl_set_button(reply_obj->Reply_Exclude,
                  Config.getIntDefault(conf_name, "replyex", 1,
                                       set_default));
    fl_set_input(reply_obj->Forward_Str,
                 Config.getStringDefault(conf_name, "fwdstr",
                                         "-----FW: %i-----%n%n",
                                         set_default));
    fl_set_button(reply_obj->Reply_Charset,
                  Config.getIntDefault(conf_name, "replykeepchset", 0,
                                       set_default));
    fl_set_button(reply_obj->Reply_Keep,
                  Config.getIntDefault(conf_name, "replykeep", 0,
                                       set_default));
    fl_set_button(reply_obj->Reply_Save,
                  Config.getIntDefault(conf_name, "replysave", 0,
                                       set_default));
    fl_clear_choice(reply_obj->Forward_INType);
    fl_addto_choice(reply_obj->Forward_INType, "do not include");
    fl_addto_choice(reply_obj->Forward_INType, "short");
    fl_addto_choice(reply_obj->Forward_INType, "full");
    fl_addto_choice(reply_obj->Forward_INType, "MIME");
    fl_set_choice(reply_obj->Forward_INType,
                  Config.getIntDefault(conf_name, "fwdinclude", 2,
                                       set_default));
}
void handle_reply_input(FD_config_reply * form) {
    reply_obj = form;
    Config.putString(conf_name, "prefix",
                     (char *) fl_get_input(reply_obj->Reply_Prefix));
    Config.putString(conf_name, "replystr",
                     (char *) fl_get_input(reply_obj->Reply_Str));
    Config.putString(conf_name, "fwdstr",
                     (char *) fl_get_input(reply_obj->Forward_Str));
    Config.putInt(conf_name, "include",
                  fl_get_choice(reply_obj->Reply_INType));
    Config.putInt(conf_name, "inclmime",
                  fl_get_choice(reply_obj->Reply_MIME));
    Config.putInt(conf_name, "inclrecp",
                  fl_get_choice(reply_obj->Reply_All));
    Config.putInt(conf_name, "fwdinclude",
                  fl_get_choice(reply_obj->Forward_INType));
    Config.putInt(conf_name, "replyex",
                  fl_get_button(reply_obj->Reply_Exclude));
    Config.putString(conf_name, "replyexand",
                     (char *) fl_get_input(reply_obj->Reply_And));
    Config.putInt(conf_name, "replykeepchset",
                  fl_get_button(reply_obj->Reply_Charset));
    Config.putInt(conf_name, "replykeep",
                  fl_get_button(reply_obj->Reply_Keep));
    Config.putInt(conf_name, "replysave",
                  fl_get_button(reply_obj->Reply_Save));
}
