/* This is bogus -- currently unchanged from the bsd file. */
/* Need to turn off synchronous error signals (SIGPIPE, SIGSYS). */

#include "../scsh_aux.h"

/* Make sure our exports match up w/the implementation: */
#include "../signals1.h"

/* This table converts Unix signal numbers to S48/scsh interrupt numbers.
** If the signal doesn't have an interrupt number, the entry is -1.
** (Only asynchronous signals have interrupt numbers.)
**
** Note that we bake into this table the integer values of the signals --
** i.e., we assume that SIGHUP=1, SIGALRM=15, etc. So this definition is
** very system-dependent.
*/
const int sig2int[] = {
  	-1,		/* 0 is not a signal */
	scshint_hup,	/* SIGHUP */
	scshint_keyboard,	/* SIGINT */
	scshint_quit,	/* SIGQUIT */
	-1,		/* SIGILL */
	-1,		/* SIGTRAP */
	-1,		/* SIGABRT & SIGIOT */
	-1,		/* SIGBUS */
	-1,		/* SIGFPE */
	-1,		/* SIGKILL */
	scshint_usr1,	/* SIGUSR1 */
	-1,		/* SIGSEGV */
	scshint_usr2,	/* SIGUSR2 */
	-1,		/* SIGPIPE */
	scshint_alarm,	/* SIGALRM */
	scshint_term,	/* SIGTERM */
	-1,		/* SIGTKFLT (x86 coprocessor stack fault) */
	scshint_chld,	/* SIGCHLD */
	scshint_cont,	/* SIGCONT */
	-1,		/* SIGSTOP */
	scshint_tstp,	/* SIGTSTP */
	-1, /*	scshint_ttyin,	/* SIGTTIN */
	-1, /*	scshint_ttou,	/* SIGTTOU */
	scshint_urg,	/* SIGURG */
	scshint_xcpu,	/* SIGXCPU */
	scshint_xfsz,	/* SIGXFSZ */
	scshint_vtalrm,	/* SIGVTALRM */
	scshint_prof,	/* SIGPROF */
	scshint_winch,	/* SIGWINCH */
	scshint_io,	/* SIGIO aka SIGPOLL*/
	scshint_pwr,	/* SIGPWR */
	-1		/* SIGPWR */
        };

const int max_sig = 31; /* SIGUNUSED */
