FXmame -- a glide driver for xmame
====================================


The latest version of this driver can be obtained at:

  http://glmame.linuxgames.com


Requirements
------------

To run FXmame you must have:

 o A 3Dfx card
 o glide 2x
 o the xmame distribution


Compiling and Installing
------------------------

FXmame comes in two flavours -- xfx and svgafx. The xfx version is
designed to run under X11. It uses an X window for input. The svgafx
version runs from the console, and uses svgalib for input. Both use
the 3Dfx hardware for rendering.

To install FXmame, follow the general instructions for installing xmame. To
specify the glide driver, do the following in "makefile.unix":

 o Select either "xfx" or "svgafx" as your display method
 o Configure the glide variables to correspond to your glide setup

The FXmame executables are called "xmame.xfx" and "xmame.svgafx"


Running
-------

FXmame runs with the same parameters and uses the same keyboard commands
that xmame.x11 does.

A few extra keyboard commands have been added in the glide driver:

 o RIGHTCTRL-A -- toggle antialiasing in vector games
 o RIGHTCTRL-B -- toggle bilinear filtering


The glide driver also adds several command-line options:

  -fxgama <value>             3Dfx gamma correction value


Note that in order to display the game options or the fps display in vector
games, I have to overlay the game bitmap over the vector display. This is
because I circumvent the bitmap entirely in vector games. Drawing the bitmap
is a big cpu hog, so you'll notice that the game slows down when you turn on
the fps display (I know, not ideal when you want to find out the frame
rate...)


Common Questions
----------------

 Q: When I run FXmame, it just dumps core.

 A: Make sure you are running FXmame as root. Root priviledges
    are required to access the 3Dfx hardware

 Q: When I run xmame.xfx, it just hangs at the initial game screen

 A: Are you running KDE? For some reason, I can't get keyboard input under
    KDE. If you have this problem, switch window managers or use
    xmame.svgafx instead.


Present Limitations/Bugs:
-------------------------

 o antialiasing isn't working quite as well as it should
 o input problems under KDE

Future Work
-----------

 o Optimize the drawing code to update only the changed portions of the
   game bitmap.


License
-------

The FXmame code is Copyright 1998 by Mike Oliphant. It may be used and
distributed under the terms of the MAME license.


Version History
---------------

v0.5 -- December 11th, 1998
---------------------------

 o implemented long copies in screen update

 o added dirty handling. this greatly increases the speed of games that
   support the dirty update strategy (although most of them are older games
   that already ran at full speed on modern hardware)

 o merged source with xmame b8.1

v0.4 -- October 30th, 1998
--------------------------

 o improved alpha handling in vector games - now bitmapped overlays
   do not dim the screen
 o added svgalib support (xmame.svgafx)
 o fixed a tiling bug that gave artifacts on texture tile boundaries

v0.3 -- October 29th, 1998
--------------------------

 o got rid of extra lines in vector games
 o added bitmap overlay in vector games to show options/fps
 o added antialiasing in vector games

v0.2 -- October 28th, 1998
--------------------------

 o added screenshots
 o added 3Dfx gamma adjustment
 o added direct acceleration of vector games (still buggy)

v0.1 -- October 27th, 1998
--------------------------

 o first public release


--
Mike Oliphant (oliphant@ling.ed.ac.uk)
http://glmame.linuxgames.com
