/*
 * xdm - display manager daemon
 *
 * $XConsortium: LoginP.h,v 1.6 89/07/21 13:43:57 jim Exp $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Keith Packard, MIT X Consortium
 * Modified by Pierre Ficheux (pierre@lectra.fr):
 *
 * $Id: LoginP.h,v 1.3 1994/11/23 23:00:29 pierre Exp $
 */

/*
* $XConsortium: LoginP.h,v 1.6 89/07/21 13:43:57 jim Exp $
*/

#ifndef _LoginP_h
#define _LoginP_h

#include "Login.h"
#include <X11/CoreP.h>
#include <X11/xpm.h>

#define GET_NAME	0
#define GET_PASSWD	1
#define DONE		2

struct xdm_user {
    char *name;
    int x, y;
    Boolean displayed, default_pixmap;
    struct xdm_user *next;
};

/* New fields for the login widget instance record */
typedef struct {
	Pixel		textpixel;	/* foreground pixel */
	Pixel		promptpixel;	/* prompt pixel */
	Pixel		greetpixel;	/* greeting pixel */
	Pixel		failpixel;	/* failure pixel */
	GC		textGC;		/* pointer to GraphicsContext */
	GC		bgGC;		/* pointer to GraphicsContext */
	GC		xorGC;		/* pointer to GraphicsContext */
	GC		promptGC;
	GC		greetGC;
	GC		failGC;
	char		*greeting;	/* greeting */
	char		*unsecure_greet;/* message displayed when insecure */
	char		*namePrompt;	/* name prompt */
	char		*passwdPrompt;	/* password prompt */
	char		*fail;		/* failure message */
	XFontStruct	*font;		/* font for text */
	XFontStruct	*promptFont;	/* font for prompts */
	XFontStruct	*greetFont;	/* font for greeting */
	XFontStruct	*failFont;	/* font for failure message */
	int		state;		/* state */
	int		cursor;		/* current cursor position */
	int		failUp;		/* failure message displayed */
	LoginData	data;		/* name/passwd */
	char		*sessionArg;	/* argument passed to session */
	void		(*notify_done)();/* proc to call when done */
	int		failTimeout;	/* seconds til drop fail msg */
	XtIntervalId	interval_id;	/* drop fail message note */
	Boolean		secure_session;	/* session is secured */
	Boolean		allow_access;	/* disable access control on login */
#ifndef NO_LOGO
	Boolean		display_logo;	/* displays the logo ? */
	GC		logoGC;		/* GC for logo */
	Pixmap		logopixmap;	/* logo Pixmap */
	XpmAttributes	logo_xpma;	/* Xpm logo datas */
#endif
	XpmColorSymbol	xpmcs[1];
	struct xdm_user 	*user_list;	/* users list */
	struct xdm_user	*first_user;
	struct xdm_user	*last_user;
	int		nb_lines;	/* # of lines */
	int 		nb_users;
	int 		nb_displayed_users;
	Boolean		draw_mover;	/* used by the scrollbar */
	Boolean		use_scrollbar;
	Boolean		user_selected;
	int		y_mover;
	int		old_y_mover;
	int 		delta_y_mover;
	char		echo[NAME_LEN];	/* echo of passwd input */
	Boolean		display_users;	/* displays the users ? */
	XFontStruct	*userFont;	/* font for user name */
	GC		pixmapGC;	/* GC for user Pixmap */
	GC		userGC;		/* GC for user name */
	GC		moverGC;	/* GC for scrollbar */
	Dimension	userWidth;	/* width of each user */
	Dimension	userHeight;	/* height of each user */
	int 		nbColumns;	/* # of columns */
	int 		nbLines;	/* # of lines */
	Pixel		userpixel;	/* color of a user name */
	Boolean		use_default_pixmap;	/* Use default.xpm if no pixmap ? */
   } LoginPart;

/* Full instance record declaration */
typedef struct _LoginRec {
   CorePart core;
   LoginPart login;
   } LoginRec;

/* New fields for the Login widget class record */
typedef struct {int dummy;} LoginClassPart;

/* Full class record declaration. */
typedef struct _LoginClassRec {
   CoreClassPart core_class;
   LoginClassPart login_class;
   } LoginClassRec;

/* Class pointer. */
extern LoginClassRec loginClassRec;

#endif /* _LoginP_h */






