package biss.jde;

import biss.FileLib;
import java.io.File;

public class ScanTest
{

public static void main ( String args[] ) {
	if ( args[0] == null ) return;
	try {
		File f = new File( args[0]);
		byte buf[] = FileLib.getFileData( f);

		Scanner scan = new Scanner( buf);
		int tok;
		while ( (tok = scan.nextToken()) > 0 ) {
			if ( tok == Scanner.STRING)
				System.out.println( "string:  " + scan.Line + ": " + scan.string());
			else if ( tok == Scanner.SCONST )
				System.out.println( "sconst:  " + scan.Line + ": " + scan.string());
			else if ( tok == Scanner.CCONST )
				System.out.println( "cconst:  " + scan.Line + ": " + scan.string());
			else if ( tok > ' ' ) {
				if ( tok == '{' ){
					scan.skipBlock( '{', '}');
					System.out.println( "{..}");
				}
				else if ( tok == '(' ){
					scan.skipBlock( '(', ')');
					System.out.println( "(..)");
				}
				else if ( tok == '=' ){
					scan.skipExpr();
					System.out.println( "= ..");
				}
				else
					System.out.println( "char:    " + scan.Line + ": " + (char)tok);
			}
			else
				System.out.println( "keyword: " + scan.Line + ": " +
			                    scan.keyword( tok));
		}
	}
	catch ( Exception x ){
		System.out.println( x.toString());
		x.printStackTrace();
	}
}
}
