package biss.awt;

import biss.ObserverSocket;
import biss.Queue;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Vector;

/**
 * List widget which is capable of displaying/processing hierarchical
 * data (directory trees etc.). Used in conjunction with LeveledObject
 * (wrapper for hierarchically organized object) and Leveler (generator
 * for LeveledObject collections).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class LeveledList
  extends List
{
	Leveler Lvl = null;
	public LeveledObject DrawLvlObject;
	Queue TreeQueue;
	PaneDrawer TreeDrawer;

public LeveledList () {
	this( 0);
}

public LeveledList (int type) {
	super( type, (type != SPS_NOHSCROLL) ? new HScrollBar() : null);
	setCanvas(Cv = new LeveledListCanvas(Horz, Vert, this));  

	setTreeView( true);
}

public void addAElement ( Object obj) {
}

public void addAllElements ( Vector list) {
}

public Vector allItems () {
	return ((LeveledListCanvas)Cv).AllItems;
}

LeveledListCanvas canvas () {
	return (LeveledListCanvas)Cv;
}

public Rectangle getDrawRectFor ( Object o) {
	LeveledObject lo = getLvlObj( o, false);
	if ( lo != null)
		return Cv.drawRectFor( lo);
	return null;
}

public LeveledObject getLvlObj ( Object o, boolean all) {
	Vector v = all ? allItems() : Cv.Lines;

	if ( v == null)
		return null;
	int s = v.size();

	for ( int i=0; i<s; i++){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if ( lo.Obj == o)
			return lo;
	}
	return null;
}

public Object getSelection () {
	if ( Cv.Selection != null)
		return ((LeveledObject)Cv.Selection).Obj;
	return null;
}

public Vector getSelections () {
	Vector list = null;

	if ( Cv.Marked == null){
		if ( Cv.Selection != null){
			list = new Vector(1);
			list.addElement( ((LeveledObject)Cv.Selection).Obj);
		}
		return list;
	}

	return markedContents();
}

public Vector markedContents () {
	Vector v = null;
	if ( Cv.Marked != null ){
		int s = Cv.Marked.size();
		v = new Vector(s );
		for ( int i=0; i<s; i++)
			v.addElement( ((LeveledObject)Cv.Marked.elementAt( i)).Obj);
	}
	return v;
}

public void redrawObject ( Object obj) {
	Cv.redrawObject( getLvlObj( obj, false));
}

public void removeAllElements ( Vector list) {
}

public void removeElement ( Object obj) {
}

public void replaceElementWith ( Object oldObj, Object newObj) {
}

public int setContents ( Object levelObj) {
	if ( Lvl != null)
		return Cv.setContents( Lvl.getLeveledList( levelObj));
	return 0;
}

public int setContents ( Object levelObj, Leveler lvl) {
	Lvl = lvl;
	return setContents( levelObj);
}

public boolean setDrawEnvironment ( Object obj) {
	return Cv.setDrawEnvironment( getLvlObj( obj, false));
}

public void setExpandImage ( String pathName) {
	canvas().setExpandImage( Awt.getImage( pathName) );
}

public void setExpandImageClass ( String imgCls) {
	try {
		Class c = Class.forName( imgCls);
		ClassImageSource cis = (ClassImageSource) c.newInstance();
		canvas().setExpandImage( createImage( cis) );
	}
	catch( Throwable t) { System.out.println( t);}
}

public boolean setSelection ( Object obj, boolean fireSlot) {
	return Cv.setSelection( getLvlObj( obj, false), fireSlot);
}

public void setShrinkImage ( String pathName) {
	canvas().setShrinkImage( Awt.getImage( pathName) );
}

public void setShrinkImageClass ( String imgCls) {
	try {
		Class c = Class.forName( imgCls);
		ClassImageSource cis = (ClassImageSource) c.newInstance();
		canvas().setShrinkImage( createImage( cis) );
	}
	catch( Throwable t) { System.out.println( t);}
}

public void setTreeView ( boolean state) {
	if ( state) {
		if ( TreeDrawer == null){
			TreeQueue = new Queue();
			TreeDrawer = new PaneDrawer( this, TreeQueue);
			OsDrawPane.addObserver( this);
		}
	}
	else if ( TreeDrawer != null) {
		TreeDrawer.stop();
		TreeDrawer = null;
		TreeQueue = null;
		OsDrawPane.deleteObserver( this);
	}
}

public boolean showObject ( Object obj) {
	return Cv.showObject( getLvlObj( obj, false));
}

public void update ( Observable obs, Object arg ) {
	if ( obs == OsDrawPane){
		while ( !TreeQueue.empty() )
			LeveledObject lo = (LeveledObject) TreeQueue.getNext();
		canvas().drawTreeInfo();
	}
	else
		super.update( obs, arg);
}

public void updateContents ( Vector newList) {
}

void updateTree ( LeveledObject lo) {
	if ( (TreeQueue != null) && (TreeQueue.empty()) )
		TreeQueue.appendNotifyUnique( lo);
}
}

class LeveledListCanvas
  extends ListCanvas
{
	Vector AllItems = null;
	int LevelDim = Awt.SysFontWidth;
	Image ExpandImg = null;
	Image ShrinkImg = null;
	int LevelDist = 3*Awt.SysFontWidth/2;

LeveledListCanvas( HScrollBar h, VScrollBar v, List cmpd) {
	super(h, v, cmpd);
}

void drawLevelSign ( LeveledObject lo) {
	Rectangle r = Master.DrawRect;
	int lvl     = lo.level();
	int dy      = (r.height - LevelDim) / 2;

	r.x += (lvl+1)*LevelDist;

	if ( lo.isExpandable() ){
		if ( ExpandImg != null)
			GraphicsLib.drawImageVCentered( ResGraph, ExpandImg,
		                                r.x, r.y, r.height, this );
		else {
			ResGraph.setColor( Awt.ListExpandClr);
			ResGraph.fillArc( r.x, r.y+dy, LevelDim, LevelDim, 0, 360);
			ResGraph.setColor( Color.blue);
			ResGraph.drawArc( r.x, r.y+dy, LevelDim, LevelDim, 0, 360);
		}
	}
	else if ( lo.isShrinkable() ){
		if ( ShrinkImg != null)
			GraphicsLib.drawImageVCentered( ResGraph, ShrinkImg,
		                                r.x, r.y, r.height, this );
		else {
			ResGraph.setColor( Color.blue);
			ResGraph.drawArc( r.x, r.y+dy, LevelDim, LevelDim, 0, 360);
		}
	}

	r.x += LevelDist + LevelDim/2 + 1;
}

synchronized boolean drawObject( Object obj) {
	if ( !setDrawEnvironment( obj) )
		return false;

	LeveledList lop = (LeveledList)Master;
	Rectangle dRect = lop.DrawRect;

	ResGraph.setColor( lop.DrawClrBack);
	ResGraph.fillRect( dRect.x, dRect.y, dRect.width, dRect.height);
	ResGraph.setColor( lop.DrawClrFore);

	LeveledObject lo = (LeveledObject) obj;
	Object        dro = lo.Obj;

	lop.DrawLvlObject = lo;
	lop.DrawObject = dro;
	drawLevelSign( lo);

	if ( ! lop.OsDrawObject.isEmpty() )
		lop.OsDrawObject.notifyObservers();
	else if ( dro instanceof SelfDrawingObject)
		((SelfDrawingObject) dro).drawSelfIn( lop);
	else {
		ResGraph.setFont( Awt.SysFont);
		ResGraph.drawString( dro.toString(), dRect.x + 5,
		                     dRect.y + dRect.height -
		                     (dRect.height - Awt.SysFontHeight) / 2 -
		                     Awt.SysFontDesc );
	}  

	master().updateTree( lo);
	return true;
}

void drawTreeInfo () {
	int x = Master.DrawRect.x;
	int y = Master.DrawRect.y;
	int cy = y + LineHeight / 2;
	int mx = Math.min(IdxTop + Height / LineHeight + 1, Lines.size() );

	ResGraph.setColor( Color.blue);

	for ( int i=IdxTop; i<mx; i++){
		LeveledObject lo = (LeveledObject)Lines.elementAt( i);
		x = Master.DrawRect.x + LevelDim/2;
		//    x = Master.DrawRect.x - LevelDim;

		for ( int lvl=0; lvl<lo.Level; lvl++){
			if ( ! LeveledObject.lastLevelIdx( Lines, i, lvl))
				ResGraph.drawLine( x, y, x, y+LineHeight);
			if ( lvl<lo.Level)
				x += LevelDist;
		}

		ResGraph.drawLine( x, y, x, cy);
		ResGraph.drawLine( x, cy, x + LevelDim, cy);
		if ( ! LeveledObject.lastLevelIdx( Lines, i, lo.Level))
			ResGraph.drawLine( x, cy, x, y + LineHeight);

		x += LevelDist;

		if ( lo.isShrinkable() ){
			ResGraph.drawLine( x, y + LineHeight - (LineHeight - LevelDim) / 2, x, y + LineHeight);
			ResGraph.drawLine( x + LevelDim/2, cy, x + LevelDist, cy);
		}
		else if ( lo.isExpandable() )
			ResGraph.drawLine( x + LevelDim/2, cy, x + LevelDist, cy);
		else
			ResGraph.drawLine( x - LevelDim/2, cy, x + LevelDist, cy);

		y += LineHeight;
		cy += LineHeight;
	}
}

boolean expand (LeveledObject lo) {
	if ( ! lo.isExpandable() )
		return false;

	int s = AllItems.size();
	lo.setExpanded( true);

	for ( int i=AllItems.indexOf(lo)+1; i<s; i++) {
		LeveledObject lc = (LeveledObject)AllItems.elementAt( i);
		if ( lc.Level <= lo.Level)
			break;
		if ( lc.Level == lo.Level+1)
			lc.setVisible( true);
	}

	return true;
}

Vector getViewItems () {
	Vector v = new Vector();
	int s = AllItems.size();
	for( int i=0; i<s; i++){
		LeveledObject lo = (LeveledObject)AllItems.elementAt( i);
		if ( lo.isVisible() )
			v.addElement( lo);
	}

	return v;
}

public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
	int me = Math.max( x, y);
	if ( LevelDim < me)
		LevelDim = me;
	return super.imageUpdate( img, flags, x, y, w, h);
}

boolean isLevelPos ( Event evt, LeveledObject lo) {
	return ( (evt.x - XOffset) < (lo.Level+1)*LevelDist+LevelDim );
}

LeveledList master(){
	return (LeveledList)Master;
}

public void mouse1Down( Event evt) {
	Object ns = objectAt( evt.x, evt.y);
	LeveledObject lo = (LeveledObject) ns;

	if ( (lo != null) && (lo.isExpandable() || lo.isShrinkable()) ){
		if ( isLevelPos( evt, lo)){
			toggleExpand( lo);
			return;
		}
	}

	if ( evt.controlDown() )
		toggleMarker( ns);

	SelSource = OP_SEL_MOUSE;
	selectObject( ns, true);
}

synchronized int setContents( Vector data) {
	AllItems = data;
	super.setContents( getViewItems() );
	return Lines.size();
}

void setExpandImage (Image img) {
	ExpandImg = img;
	if ( isShowing() )
		redraw();
}

void setExpandImage (String pathName) {
	ExpandImg = Awt.DefToolkit.getImage( pathName);
	if ( isShowing() )
		redraw();
}

void setLineDimensions ( Object refObj) {
	if ( refObj != null) {
		LeveledObject lo = (LeveledObject) refObj;
		super.setLineDimensions( lo.Obj);
	}
	else
		super.setLineDimensions( null);

	LevelDim = Awt.SysFontHeight/2-1;
	//LevelDim = Math.min( LineHeight-4, 3*Awt.SysFontWidth/2);
	LevelDist = 3*LevelDim/2;
}

void setShrinkImage (Image img) {
	ShrinkImg = img;
	if ( isShowing() )
		redraw();
}

void setShrinkImage (String pathName) {
	ShrinkImg = Awt.DefToolkit.getImage( pathName);
	if ( isShowing() )
		redraw();
}

boolean shrink (LeveledObject lo) {
	if ( ! lo.isShrinkable() )
		return false;

	int s = AllItems.size();
	lo.setExpanded( false);

	for ( int i=AllItems.indexOf(lo)+1; i<s; i++) {
		LeveledObject lc = (LeveledObject)AllItems.elementAt( i);
		if ( lc.Level <= lo.Level)
			break;
		lc.setVisible( false);
		lc.setExpanded( false);
	}

	return true;
}

boolean toggleExpand (LeveledObject lo) {
	if ( lo.isExpandable() ){
		expand( lo);
		return updateViewItems();
	}

	if ( lo.isShrinkable() ) {
		shrink( lo);
		return updateViewItems();
	}

	return false;
}

boolean updateViewItems () {
	if ( Lines == null)
		return false;
	int s = AllItems.size();
	Lines.removeAllElements();
	for( int i=0; i<s; i++){
		LeveledObject lo = (LeveledObject)AllItems.elementAt( i);
		if ( lo.isVisible() )
			Lines.addElement( lo);
	}
	updateContents();
	return true;
}
}
