/* $Id: xkbsel-gnome.c,v 1.4 1999/08/05 17:16:40 stano Exp $

   Gnome keyboard selection - main program

   (C) 1999 Stanislav Meduna <stano@eunet.sk>


   Widget instance tree:

   main_w : applet
     frame : frame
       packer: packer
         box   : vbox
           sel_btn : button
	     sel_lbl : label
	   comm_btn : event-box


   menu : menu
     menu_item[] : menu_item
       box1 : fixed
         lab1 : label
	 lab2 : label

*/

#include <xkbselx.h>
#include <config.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <applet-widget.h>

#include <locale.h>
#include <libintl.h>

/* === Forward declarations === */

static GtkWidget *make_new_xkbsel_applet(const gchar *goad_id);

static int build_widgets(GtkWidget *main_w);
static int build_popup_menu();


static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
static gint destroy(GtkWidget *widget, gpointer data);

static gint sel_cb(GtkWidget *widget, GdkEvent *event);
static gint disp_cb(GtkWidget *widget, GdkEvent *event);
static gint menuitem_cb (gpointer ptr);


static GtkWidget *sel_btn;
static GtkWidget *sel_lbl;
static GtkWidget *comm_btn;
static GtkWidget *menu;

static int first_one;

/* === Public interface === */
int main( int   argc,
          char *argv[] )
{
	int r;
	
	gtk_set_locale();

	/* Read the config */
	r = read_config();
	if (r < 0)
		exit(1);

	textdomain(PACKAGE);

        applet_widget_init("xkbsel_gnome_applet", VERSION, argc, argv,
                           NULL, 0, NULL);

	make_new_xkbsel_applet("xkbsel_gnome_applet");

	applet_widget_gtk_main();
	
	return(0);
}

/* === Private functions === */

static GtkWidget *make_new_xkbsel_applet(const gchar *goad_id)
{
	GtkWidget *main_w;
	int r;

	/* create a new window */
	main_w = applet_widget_new(goad_id);

	r = build_widgets(main_w);
	if (r < 0)
		return NULL;

	gtk_widget_show(main_w);

	/* Say we are here */
	notify_me(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(comm_btn->window), 1);
	/* Select first keyboard */
	menuitem_cb((gpointer) locale_maps + first_one);

	/* Query current selection */
	disp_cb(comm_btn, NULL);

	return main_w;
}

static int build_widgets(GtkWidget *main_w)
{
	GtkWidget *box;
	GtkWidget *packer;
	GtkWidget *frame;
	GtkTooltips *tooltips;

	int r;

	/* handle delete on this window */
	gtk_signal_connect(GTK_OBJECT(main_w), "delete_event",
			GTK_SIGNAL_FUNC(delete_event), NULL);
	
	/* handle destroy on this window */
	gtk_signal_connect(GTK_OBJECT(main_w), "destroy",
			GTK_SIGNAL_FUNC (destroy), NULL);
	
	/* Sets the border width of the window. */
	gtk_container_set_border_width(GTK_CONTAINER (main_w), 0);
	
	packer = gtk_packer_new();

	frame = gtk_frame_new(NULL);

	sel_btn = gtk_button_new();

	sel_lbl = gtk_label_new(_("none"));
	
	gtk_container_add(GTK_CONTAINER(sel_btn), sel_lbl);

	/* And a communication button */
	comm_btn = gtk_event_box_new();
	gtk_widget_set_usize(comm_btn, 1, 1);
	
	/* On click, this button displays a current selection */
	gtk_signal_connect_object (GTK_OBJECT (comm_btn), "button_press_event",
			GTK_SIGNAL_FUNC (disp_cb), NULL);
	gtk_signal_connect_object (GTK_OBJECT (comm_btn), "button_release_event",
			GTK_SIGNAL_FUNC (disp_cb), NULL);

	/* Pack the buttons into a box */
	box = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), sel_btn, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), comm_btn, FALSE, FALSE, 0);

	gtk_packer_add(GTK_PACKER(packer), box,
		GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_PACK_EXPAND,
		0, 16, 16, 0, 0);

	gtk_container_add(GTK_CONTAINER(frame), packer);

	/* This packs the buttons into the window (a gtk container). */
	applet_widget_add(APPLET_WIDGET(main_w), frame);

	build_popup_menu();

	tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tip(tooltips, main_w, _("XKB keyboard selector"), NULL);

	/* The final step is to display the widgets */
	gtk_widget_show(box);
	gtk_widget_show(frame);
	gtk_widget_show(packer);
	gtk_widget_show(sel_btn);
	gtk_widget_show(sel_lbl);
	gtk_widget_show(comm_btn);

	return(0);
}

static int build_popup_menu()
{
	GtkWidget *menu_items;
	GtkStyle  *style;
	int i, r;
	int mwidth;
	
	style = gtk_widget_get_default_style();

	mwidth = gdk_text_width(style->font, "M", 1);

	/* And now the menu */
	menu = gtk_menu_new();

	/* On button press, this menu will be popped up */
	gtk_signal_connect_object(GTK_OBJECT(sel_btn), "button_press_event",
		GTK_SIGNAL_FUNC(sel_cb), NULL);

	/* Menu entries */
	r = open_db();
	if (r < 0)
		exit(1);
	first_one = -1;
	for (i=0; i < n_locale_maps; i++)
	{
		db_record_t rec;
		int found;
		GtkWidget *box1, *lab1, *lab2;

		r = read_db_name(locale_maps[i].map_name, &rec, &found);
		if (r < 0)
			exit(1);

		if (! found)
		{
			fprintf(stderr, _("Map name %s not found - ignored\n"), locale_maps[i].map_name);
			continue;
		}

		box1 = gtk_fixed_new();

		lab1 = gtk_label_new(locale_maps[i].shortcut);
		lab2 = gtk_label_new(*rec.descr ? rec.descr : locale_maps[i].map_name);

		gtk_label_set_justify(GTK_LABEL(lab1), GTK_JUSTIFY_LEFT);
		gtk_label_set_justify(GTK_LABEL(lab2), GTK_JUSTIFY_LEFT);

		gtk_fixed_put(GTK_FIXED(box1), lab1, 0, 0);
		gtk_fixed_put(GTK_FIXED(box1), lab2, 8*mwidth, 0);


		menu_items = gtk_menu_item_new();

		gtk_container_add(GTK_CONTAINER(menu_items), box1);

		gtk_menu_append(GTK_MENU(menu), menu_items);

		gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
			GTK_SIGNAL_FUNC(menuitem_cb), (gpointer) (locale_maps+i));

		if (first_one == -1)
			first_one = i;
	}


	r = close_db();

	if (first_one == -1)
	{
		fprintf(stderr, _("No configured maps\n"));
		exit(1);
	}

	gtk_widget_show_all(menu);

	return 0;
}


static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	/* Say we are no more here */
	notify_me(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(comm_btn->window), 0);

	return(FALSE);
}

/* Another callback */
static gint destroy(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();

	return FALSE;
}

static gint sel_cb(GtkWidget *widget, GdkEvent *event)
{
	GdkEventButton *bevent = (GdkEventButton *) event; 

	gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL,
		bevent->button, bevent->time);

	return TRUE;
}


static gint disp_cb(GtkWidget *widget, GdkEvent *event)
{
	int r;
	int found;

	sel_info_t sel;
	if (event == NULL || event->type == GDK_BUTTON_PRESS)
	{
		r = get_current_sel(GDK_DISPLAY(), &sel, &found);

		gtk_label_set_text(GTK_LABEL(sel_lbl),
			(!r && found) ? sel.shortcut : _("none"));
	}

	return TRUE;
}

static gint menuitem_cb(gpointer ptr)
{
	int r;
	sel_info_t *sel = (sel_info_t *) ptr;

	if (flag_debug)
		fprintf(stderr, _("Selected %s\n"), sel->shortcut);

	r = open_db();
	if (r < 0)
		return TRUE;

	r = install_map(sel->map_name);

	if (! r)
		publish_current_sel(GDK_DISPLAY(), sel);

	close_db();

	return TRUE;
}
