/* $Id: selind-kde.cpp,v 1.3 1999/08/05 17:16:40 stano Exp $ 

   xkbsel main widget

   (C) 1999 Stanislav Meduna <stano@eunet.sk>
*/

#include <selind-kde.h>
#include <kbdselmenu-kde.h>

#include <qfont.h>
#include <kapp.h>
#include <qpushbutton.h>
#include <qtooltip.h>

#include <xkbselx.h>

#include <stdio.h>
#include <libintl.h>

#define _(s) gettext(s)

void MainToolTip::maybeTip(const QPoint &pos)
{
	tip(QRect(pos.x(), pos.y(), 1, 1), _("XKB keyboard selector"));
}


void SelBtn::mousePressEvent( QMouseEvent *ev )
{
	if (ev->button() & 2)
	{
		if (ev->type() == Event_MouseButtonPress)
			optionsRequested();
	}
	else
		QPushButton::mousePressEvent(ev);
}


OptionsPopMenu::OptionsPopMenu(QWidget *parent, const char *name)
 : QPopupMenu(parent, name) 
{
	setFont(QFont("Courier", 10, QFont::Normal));
	insertItem(_("Quit xkbsel"));
        connect(this, SIGNAL(activated(int)), SLOT(selected(int)));

}

void OptionsPopMenu::selected(int idx)
{
	KApplication::getKApplication()->quit();
}


SelInd::SelInd(QWidget *parent, const char *name)
  : QWidget(parent, name),
    menu(0), opt_menu(0), selBtn(0), commBtn(0), toolTip(0)
{
	setMinimumSize(32, 16);
	setMaximumSize(128, 32);

	menu = new KbdSelPopMenu(0, "menu");
	opt_menu = new OptionsPopMenu(0, "opt_menu");
	selBtn = new SelBtn(this, "selector");
	commBtn = new QPushButton(this, "communicator");

	selBtn->setGeometry(0, 0, width()-1, height()-1);
	selBtn->setFont(QFont("Courier", 10, QFont::Normal));
	selBtn->setText("Text");
	commBtn->move(0, selBtn->y()+selBtn->height());
	commBtn->resize(width(), height()-selBtn->height());
	toolTip = new MainToolTip(selBtn);
}

SelInd::~SelInd()
{
	// Announce we are no more here
	notify_me(KApplication::getKApplication()->getDisplay(),
		commBtn->winId(),
		0);

	delete commBtn;
	delete selBtn;
	delete menu;
}

void SelInd::resizeEvent(QResizeEvent *)
{
	selBtn->setGeometry(0, 0, width()-1, height()-1);
	commBtn->move(0, selBtn->y()+selBtn->height());
	commBtn->resize(width(), height()-selBtn->height());
}


int SelInd::constructAll()
{
	int r;

	// construct our menu
	r = menu->constructMenu();
	if (r < 0)
		return r;

	// The indicator button pops the menu on left button press
	connect(selBtn, SIGNAL(pressed()), this, SLOT(popupKbdSel()));

	// ... and options menu on the right one
	connect(selBtn, SIGNAL(optionsRequested()), this, SLOT(popupOptions()));

	// And the communicator redisplays the current selection
	connect(commBtn, SIGNAL(pressed()), this, SLOT(displayCurSel()));

	// Announce we are here
	notify_me(KApplication::getKApplication()->getDisplay(),
		commBtn->winId(),
		1);

	// Current selection
	displayCurSel();
}

void SelInd::popupKbdSel()
{
	menu->popup(QPoint(x(), y()));
	selBtn->setDown(false);
}

void SelInd::popupOptions()
{
	opt_menu->popup(QPoint(x(), y()));
}


void SelInd::displayCurSel()
{
	int r;
	int found;

	sel_info_t sel;

	r = get_current_sel(KApplication::getKApplication()->getDisplay(), &sel, &found);

	selBtn->setText((!r && found) ? sel.shortcut : _("none"));
}

void SelInd::quitNow()
{
	KApplication::getKApplication()->quit();
}
