/* $Id:$
***************************************************************************

   X server for LibGGI - Keyboard handling

   Copyright (C) 1997	   Michael Krause	[rawstyle@ms.demo.org]
   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

***************************************************************************
*/

#include "X.h"
#include "inputstr.h"
#include "input.h"
#include "mi.h"

#include "keysym.h"
#include "keysymdef.h"

#include "xggi.h"
#include "keymap.h"


static uint32 ggicodemap[NUM_KEYCODES] = {
	GIIK_F1,
	GIIK_F2,
	GIIK_F3,
	GIIK_F4,
	GIIK_F5,
	GIIK_F6,
	GIIK_F7,
	GIIK_F8,
	GIIK_F9,
	GIIK_F10,
	GIIK_F11,
	GIIK_F12,
	GIIK_F13,
	GIIK_F14,
	GIIK_F15,
	GIIK_F16,
	GIIK_F17,
	GIIK_F18,
	GIIK_F19,
	GIIK_F20,
	GIIK_F21,
	GIIK_F22,
	GIIK_F23,
	GIIK_F24,
	GIIK_F25,
	GIIK_F26,
	GIIK_F27,
	GIIK_F28,
	GIIK_F29,
	GIIK_F30,
	GIIK_F31,
	GIIK_F32,
	GIIK_F33,
	GIIK_F34,
	GIIK_F35,
	GIIK_CapsLock,			/* Locked keys */
	GIIK_NumLock,
	GIIK_ScrollLock,

	GIIK_Compose,			/* Misc keys */
	GIIK_Undo,		/* 40 */
	GIIK_Redo,
	GIIK_Menu,
	GIIK_Cancel,
	GIIK_PrintScreen,
	GIIK_Execute,
	GIIK_Find,
	GIIK_Begin,
	GIIK_Clear,
	GIIK_Insert,
	GIIK_Select,		/* 50 */
	GIIK_Macro,
	GIIK_Help,
	GIIK_Do,
	GIIK_Pause,
	GIIK_SysRq,
	GIIK_ModeSwitch,
	GIIK_Up,
	GIIK_Down,
	GIIK_Left,
	GIIK_Right,		/* 60 */
	GIIK_Prior, /* PageUp */
	GIIK_Next,  /* PageDown */
	GIIK_Home,
	GIIK_End,

	GIIK_P0,			/* Keys on numeric pad */
	GIIK_P1,
	GIIK_P2,
	GIIK_P3,
	GIIK_P4,
	GIIK_P5,		/* 70 */
	GIIK_P6,
	GIIK_P7,
	GIIK_P8,
	GIIK_P9,
	GIIK_PA,
	GIIK_PB,
	GIIK_PC,
	GIIK_PD,
	GIIK_PE,
	GIIK_PF,		/* 80 */
	GIIK_PPlus,
	GIIK_PMinus,
	GIIK_PAsterisk,	/* Star */
	GIIK_PSlash,
	GIIK_PEnter,
	GIIK_VOID,
	GIIK_VOID,
	GIIK_PPlusMinus,
	GIIK_PParenLeft,
	GIIK_PParenRight,	/* 90 */
	GIIK_PSpace,
	GIIK_PTab,
	GIIK_PBegin,
	GIIK_VOID,

	GIIK_PEqual,
	GIIK_PSeparator,
	GIIK_PDecimal,
	GIIK_PF1,
	GIIK_PF2,
	GIIK_PF3,		/* 100 */
	GIIK_PF4,
	GIIK_PF5,
	GIIK_PF6,
	GIIK_PF7,
	GIIK_PF8,
	GIIK_PF9,

	GIIK_ShiftL,			/* Modifiers */
	GIIK_ShiftR,
	GIIK_CtrlL,
	GIIK_CtrlR,		/* 110 */
	GIIK_AltL,
	GIIK_AltR,
	GIIK_MetaL,
	GIIK_MetaR,
	GIIK_SuperL,
	GIIK_SuperR,
	GIIK_HyperL,
	GIIK_HyperR,
	GIIK_ShiftLock,			/* New keys */
	GIIK_VOID,		/* 120 */
	GIIK_VOID,
	GIIK_VOID,

	GIIUC_BackSpace,		/* "Easily" mapped keys */
	GIIUC_Tab,
	GIIUC_Linefeed,
	GIIUC_Return,
	GIIUC_Escape,
	GIIUC_Delete,
	GIIUC_Space,
	GIIUC_0,		/* 130 */
	GIIUC_1,
	GIIUC_2,
	GIIUC_3,
	GIIUC_4,
	GIIUC_5,
	GIIUC_6,
	GIIUC_7,
	GIIUC_8,
	GIIUC_9,
	
	GIIUC_A,		/* 140 */
	GIIUC_B,
	GIIUC_C,
	GIIUC_D,
	GIIUC_E,
	GIIUC_F,
	GIIUC_G,
	GIIUC_H,
	GIIUC_I,
	GIIUC_J,
	GIIUC_K,		/* 150 */
	GIIUC_L,
	GIIUC_M,
	GIIUC_N,
	GIIUC_O,
	GIIUC_P,
	GIIUC_Q,
	GIIUC_R,
	GIIUC_S,
	GIIUC_T,
	GIIUC_U,		/* 160 */
	GIIUC_V,
	GIIUC_W,
	GIIUC_X,
	GIIUC_Y,
	GIIUC_Z,

	GIIUC_Agrave,		/* 166 */
	GIIUC_Aacute,
	GIIUC_Acircumflex,
	GIIUC_Atilde,
	GIIUC_Adiaeresis,/* Aumlaut */ 	/* 170 */
	GIIUC_Aring,
	GIIUC_AE,
	GIIUC_Ccedilla,
	GIIUC_Egrave,
	GIIUC_Eacute,
	GIIUC_Ecircumflex,
	GIIUC_Ediaeresis,/* Eumlaut */
	GIIUC_Igrave,
	GIIUC_Iacute,
	GIIUC_Icircumflex,	/* 180 */
	GIIUC_Idiaeresis,/* Iumlaut */
	GIIUC_ETH,
	GIIUC_Ntilde,
	GIIUC_Ograve,
	GIIUC_Oacute,
	GIIUC_Ocircumflex,
	GIIUC_Otilde,
	GIIUC_Odiaeresis,/* Oumlaut */
	GIIUC_Multiply,
	GIIUC_Ooblique,		/* 190 */
	GIIUC_Ugrave,
	GIIUC_Uacute,
	GIIUC_Ucircumflex,
	GIIUC_Udiaeresis,/* Uumlaut */
	GIIUC_Yacute,
	GIIUC_THORN,
	GIIUC_ssharp,		/* 197 */

	GIIUC_Grave,			/* The nasty ones - 102-key US */
	GIIUC_Minus,
	GIIUC_Equal,		/* 200 */
	GIIUC_BracketLeft,
	GIIUC_BracketRight,
	GIIUC_Semicolon,
	GIIUC_Apostrophe,
	GIIUC_BackSlash,
	GIIUC_Less,		/* 206 */
	GIIUC_Comma,
	GIIUC_Period,
	GIIUC_Slash,
	
	GIIUC_Paragraph,	/* 210 */ /*The nasty ones - other keyboards */
	GIIUC_Plus,
	GIIUC_Acute,
	GIIUC_Diaeresis,

	GIIUC_NumberSign,
	GIIUC_BackSlash,
	
	GIIUC_Tilde,
	GIIUC_Section,

	GIIK_DeadAcute,			/* Dead keys */
	GIIK_DeadDiaeresis,
	GIIK_DeadCircumflex,	/* 220 */
	GIIK_DeadTilde,
	GIIK_DeadCedilla,
	GIIK_DeadGrave,

	GIIUC_Bar,
	GIIUC_Circumflex,	/* 225 */
	
};

#define LETTERSTART 	(140-1)
#define LETTEREND	(197-1)
#define NOCAPSDEC	0x20

Bool
LegalModifier(unsigned int key, DevicePtr pDev)
{
	return TRUE;
}

static int
translate_key(uint32 sym, uint32 label)
{
	int i;
    
	for (i=0; i < LETTERSTART; i++) {
		if (label == ggicodemap[i]) {
			return i+8;
		}
	}
	while (i <= LETTEREND) {
		if (label == ggicodemap[i]
		    || (label - NOCAPSDEC) == ggicodemap[i]) {
			return i+8;
		}
		i++;
	}
	while (i < NUM_KEYCODES) {
		if (label == ggicodemap[i]) {
			return i+8;
		}
		i++;
	}	    

	return 0;
}

void
xggiQueueKeyboardEvent(ggi_event *ev)
{
	DevicePtr pKeyboard;
	xEvent xev;
	int k;

	pKeyboard = LookupKeyboardDevice();
	if (!pKeyboard->on)
		return;
    
	k = translate_key(ev->key.sym, ev->key.label);

	if (k) {
		xev.u.keyButtonPointer.time = TVAL2TIME(ev->any.time);
		xev.u.u.detail = k;
	    
		switch (ev->any.type) {
		case evKeyPress:
		case evKeyRepeat:
			xev.u.u.type = KeyPress;
			break;
	    
		case evKeyRelease:
			xev.u.u.type = KeyRelease;
			break;
	    
		default:
			return;
		}
	
#if 0
		ErrorF("Enqueueing: 0x%x, %d\n", ev->key.label, k);
#endif
		mieqEnqueue(&xev);
	} 
#if 0	
	else {
		ErrorF("Skipping: 0x%x\n", ev->key.label);
	}
#endif
}

int
xggiKeybdProc(DeviceIntPtr pDevice, int onoff)
{
	KeySymsRec keySyms;
	CARD8 modMap[MAP_LENGTH];
	DevicePtr pDev = (DevicePtr)pDevice;
	KeySym *ksym;
	int i;
	
	switch (onoff) {
	case DEVICE_INIT:
		/* Clear map */
		for (i = 0; i < MAP_LENGTH; i++) {
			modMap[i] = NoSymbol;
		}
  
		for (ksym = xggiKeymap, i = MIN_KEYCODE;
		     i < (NUM_KEYCODES + MIN_KEYCODE);
		     i++, ksym += 4) {
			switch (*ksym) {
			case XK_Shift_L:
			case XK_Shift_R:
				modMap[i] = ShiftMask;
				break;
				
			case XK_Control_L:
			case XK_Control_R:
				modMap[i] = ControlMask;
				break;
      
			case XK_Caps_Lock:
				modMap[i] = LockMask;
				break;
      
			case XK_Alt_L:
			case XK_Alt_R:
				modMap[i] = AltMask;
				break;
      
			case XK_Num_Lock:
				modMap[i] = NumLockMask;
				break;

			case XK_Scroll_Lock:
				modMap[i] = ScrollLockMask;
				break;

			case XK_Kana_Lock:
			case XK_Kana_Shift:
				modMap[i] = KanaMask;
				break;

			case XK_Mode_switch:
				modMap[i] = AltLangMask;
				break;

			}
		}
		keySyms.minKeyCode = MIN_KEYCODE;
		keySyms.maxKeyCode = MAX_KEYCODE;
		keySyms.mapWidth = GLYPHS_PER_KEY;
		keySyms.map = xggiKeymap;
		InitKeyboardDeviceStruct(pDev, &keySyms, modMap,
					 (BellProcPtr)NoopDDA,
					 (KbdCtrlProcPtr)NoopDDA);
		break;
		
	case DEVICE_ON: 
		pDev->on = TRUE;
		break;
		
	case DEVICE_OFF: 
		pDev->on = FALSE;
		break;
		
	case DEVICE_CLOSE:
		pDev->on = FALSE;
		break;
	}
	
	return Success;
}
