.TH fbtv 1 "(c) 1998 Gerd Knorr"
.SH NAME
fbtv - a console program for watching TV
.SH SYNOPSIS
.B fbtv [ options ] [ station name ]
.SH DESCRIPTION
.B fbtv
is a program for watching TV with your linux box.  It runs on top of a
graphic framebuffer device (/dev/fb0).  You'll need a new 2.1.x kernel
to play with this.
.B fbtv
shares the config file ($HOME/.xawtv) with the
.B xawtv
application.  Check the xawtv(1) manpage for details about the config
file format.
.SH OPTIONS
.TP
.B -o base
set basestring for the snapshot output files.  The filename will be
"base-timestamp-nr.ext".
.TP
.B -v
Be verbose.
.TP
.B -c device
video4linux device (default is /dev/video).
.TP
.B -d device
framebuffer device (default is $FRAMEBUFFER; /dev/fb0 if unset)
.TP
.B -g
grayscaled display (works for for 256 color mode only)
.TP
.B -s widthxheight
display the TV picture in
.B width
x
.B height
size in the upper right corner.
.TP
.B -f font
font for text. default is /usr/lib/kbd/consolefonts/lat1-16.psf.
.TP
.B -m mode
video mode for TV.  fbtv will look up the mode in /etc/fb.modes.
.TP
.B -k
keep capture on when switching consoles.  Might be useful together
with -s switch, you have a video picture while working on another
console.  This is more or less a dirty hack.  Works only if all
your consoles have the same video mode and fbcon does not use
panning to speed up scrolling.  For a multiheaded setup this
is useful too.
.TP
.B -q
quiet mode.  Doesn't reserve space for the status line at the top,
does'nt display the status messages and clock.  You can toggle this
at runtime too ('F').
.TP
.B -M
EXPERIMENTAL: Turn on backend scaler mode (write yuv to offscreen
memory and let the gfx board scale up the video).  Supported hardware:
Matrox G200 (with matroxfb) and ATI Mach64 VT/GT (with atyfb, 16bpp
only).  You'll need at least bttv-0.7.11 or kernel 2.3.34.
.SH USAGE
fbtv is supported to work much like xawtv from user's point of view.
You might have noticed that xawtv has alot of keyboard shortcuts.
They work in fbtv too (if it useful).  Here is the list:

.nf
G            \fBG\fPrab picture (full size, ppm)
J            Grab picture (full size, \fBj\fPpeg)
F            \fBF\fPullscreen.  Toggle quiet mode (see above).

up/down      tune up/down one channel
left/right   fine tuning
pgup/pgdown  station up/down

ESC,Q        \fBQ\fPuit

+/-          Volume up/down
Enter        mute
.fi

The channel hotkeys defined in $HOME/.xawtv are supported too, with one
exception: modifier keys (something like "key = Ctrl+F1") do not work.

.SH FULLSCREEN TV
Some hints from Dag Bakke <dag.bakke@riksnett.no>:
.P
The BT8xx cards can produce images up to 768x576 pixels.  In order to
have fbtv make use of your entire monitor-size and get maximum image
quality, you need to create a 768x576 pixels framebufferconsole. This
can be accomplished with the fbset(1) utility, which is availabile at
various locations.  See: http://www.cs.kuleuven.ac.be/~geert/bin/
.P
Or, you can let fbtv handle the videomode changes with the -m switch.
This requires that you have a small database with the various
videomodes availabile. The file containing the videomodes is normally
named /etc/fb.modes. For example, the following entry produces a
768x576x32bpp mode, with 75Hz refresh on a Matrox G200.

.nf
mode "tv"
    # D: 49.188 MHz, H: 46.580 kHz, V: 75.008 Hz
    geometry 768 576 768 576 32
    timings 20330 128 32 32 8 128 5
endmode
.fi

The command "fbtv -q -mtv" thus gives you crisp clear (well, as
good as the received signal anyway) tv on your entire screen. Alias
this command to 'tv', and you're set.
.P
.B NB!
Please note that your monitor may or may not be able to handle such a
"custom" resolution. And that misuse of the aforementioned fbset
utility can toast your monitor. It is a lot easier to pull smoke out
of electronic components, than to put it back in.
.P
A database of the standard VESA-modes can be downloaded from:
ftp://platan.vc.cvut.cz/pub/linux/matrox-latest/fb.modes.vesa60.gz

.SH SEE ALSO
xawtv(1)
.SH AUTHOR
Gerd Knorr <kraxel@goldbach.in-berlin.de>
.SH COPYRIGHT
Copyright (C) 1997,98 Gerd Knorr <kraxel@goldbach.in-berlin.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
