#include "global.h"


/* update an object in 3D module */
Public
void updateObjectIn3D(WObject *pwoh)
{
  M4 matrice;
  
  matrice = MulM4(TranslateM4(pwoh->x, pwoh->y, pwoh->z),
			      RotateM4(pwoh->a1, UZ)
			      /* MulM4(RotateM4(pwoh->a3, UX),
			            RotateM4(pwoh->a1, UZ)
                                   )
                               */
                 );
  SolidSetPosition(pwoh->soh, &matrice);
}

/* update camera in 3D module */
Public
void updateCameraFromObject(WObject *po)
{
  M4 matrice;

  matrice = MulM4(RotateM4(-M_PI_2, UX),
                  MulM4(RotateM4(M_PI_2, UZ),
                        MulM4(RotateM4(po->a3, UX),
                              MulM4(RotateM4(po->a2, UY),
                                    MulM4(RotateM4(-po->a1, UZ),
                                          TranslateM4(-po->x, -po->y, -po->z)
                                         )
                                   )
                             )
                       )
                 );
  ZLib_setCameraPosition(&matrice);
}

/* fill optional buffer field of 3D with the WObject pointer */
Public
void setOptionalBuffer(WObject *pwoh)
{
  char optbuf[2 * sizeof(WObject *) + 3];

  memset(optbuf, 0, sizeof(optbuf));  
  sprintf(optbuf, FORMATPTR, pwoh);
  SolidSetOptBuf(pwoh->soh, optbuf, sizeof(optbuf));
} 

/* Convert format Solid (3D) into WObject */
WObject *
getPobjectFromSolid(Solid solid)
{
  WObject *pwoh;
  char optbuf[2 * sizeof(WObject*) + 3];

  memset(optbuf, 0, sizeof(optbuf));  
  if (SolidGetOptBuf(solid, optbuf, sizeof(optbuf)) != sizeof(optbuf))
    fatal("Wmgt: optional buffer size incorrect when get");

  if (sscanf(optbuf, FORMATPTR, &pwoh) != 1)
    fatal("Wmgt: corrupted optional buffer");

  return pwoh;
}
