#include "global.h"
#include "supportfuncs.h"
#include "quittools.h"
#include "keys.h"
#include "rtpsess.h"
#include "parse.h"
#include "net_global.h"


/* static variables */
#include "cfg.h"	/* initial builtin configuration */

#define M_2PI	6.28318530717958647692


/* current world name */
Public
void localWorldName(char *url)
{
  char *p;

  p = strrchr(url, '/');
  strncpy(worldname, ++p, WORLD_LEN);
  p = strchr(worldname, '.');
  *p = '\0';
  trace(DBG_WMGT, "localWorldName: %s", worldname);
}

/* initialize localuser */
Private
void createLocalUser(char *localusername, char *urlface, char *urlback)
{
  WObject *puser;
  char geometry[LINESIZE];

  puser = (WObject*) malloc(sizeof(WObject));
  memset(puser, 0, sizeof(WObject));
  clearKeyTab(puser);
  puser->noh.type = USERTYPE;
  createNetObject((NetObject *) puser, VOLATILE);
  strcpy(puser->h_name, localusername);

  puser->entryflag = 0;
#ifdef RANDOM_ORIGIN
  /* ramdomize x and y */
  puser->x = (float) drand48() * 2 -1;
  puser->y = (float) drand48() * 2 -1;
  puser->a1 = (float) drand48() * M_2PI;
#else
  puser->x = 0;
  puser->y = 0;
  puser->a1 = 0;
#endif
  puser->z = USERPOSZ;
  puser->a2 = puser->a3 = 0;
  puser->changeflag = FALSE;
  
  /* fill mapping fields */
  strcpy(puser->ext.user.urlface, urlface);
  strcpy(puser->ext.user.urlback, urlback);
  strcpy(puser->ext.user.world, worldname);
  
  sprintf(geometry, "box,size=%s,%s,%s,tex_xp=%s,tex_xn=%s",
	  USERHALFSIZEX, USERHALFSIZEY, USERHALFSIZEZ,
	  puser->ext.user.urlface, puser->ext.user.urlback);
  puser->soh = SolidParser(geometry);  
  updateObjectIn3D(puser);
  puser->ext.user.lastmess = 0;
  puser->ext.user.lspeed = USERLSPEED;
  puser->ext.user.aspeed = USERASPEED;
  SolidSetVisibilty(puser->soh, FALSE);		/* not visible */
  puser->secs = -1.0;
  puser->ext.user.move.remaintime = 0.0;
  updateBB(puser);

  mobilelist = addObjectToList(puser, mobilelist);
  insertObjectIntoGrid(puser);

  plocaluser = puser;                  /* !!!! */  
  strcpy(username, puser->h_name);
  trace(DBG_WMGT, "username: %s", username);
#ifndef WANT_TCL
  memberJoining(puser->h_name);
#endif
  strncpy(rtpname, AvatarName(), NAME_LEN);
  strncpy(rtpemail, RtcpEmail(), EMAIL_LEN);
  trace(DBG_WMGT, "rtpname=%s, rtpemail=%s", rtpname, rtpemail);
} 

/* Wmgt general initialization */
Public
void WmgtInit(char *urlcfg, char *username, char *urlface, char *urlback)
{
  clearGrid();
  fileline = NULL;
  stilllist = NULL;
  mobilelist = NULL;
  volatilelist = NULL;

  initNaming();
  initGeneralFuncList();
  localWorldName(urlcfg);
  createLocalUser(username, urlface, urlback);

  ZLib_setCameraProjection(USERFOVY, USERNEAR, USERFAR); /* view from user */
  
  declareCreation(&(plocaluser->noh));
  wmgtlockstate = LOCK_TOBUILD;

  /*
   * initial loading of interconnection world
   */
  if (strlen(urlcfg) != 0)
    httpOpen(urlcfg, readCfg, NULL, NO_BLOCK);
  else {
    trace(DBG_WMGT, "world_initial builtin");
    parseCfgDatas(world_initial, sizeof(world_initial));
    wmgtlockstate = LOCK_DOWNLOADED;
  }
  /* localWorldName(urlinitial); */
  updateObjectIn3D(plocaluser);
  updateCameraFromObject(plocaluser);
}

/* initialization new world */
Public
void newWorld(char *urlcfg)
{
  clearGrid();
  fileline = NULL;
  stilllist = NULL;
  mobilelist = NULL;
  volatilelist = NULL;
  clearKeyTab(plocaluser);
  localWorldName(urlcfg);
  createNetObject((NetObject *) plocaluser, VOLATILE);

#ifdef RANDOM_ORIGIN
  plocaluser->x = (float) drand48() * 2 -1;
  plocaluser->y = (float) drand48() * 2 -1;
  plocaluser->a1 = (float) drand48() * M_2PI;
#else
  if (!plocaluser->entryflag) {
    plocaluser->x = 0;
    plocaluser->y = 0;
    plocaluser->a1 = 0;
  }
  else {
    plocaluser->entryflag = 0;
  }
#endif
  plocaluser->z = USERPOSZ + 0.05;
  plocaluser->a2 = plocaluser->a3 = 0;
  plocaluser->changeflag = FALSE;
  
  updateObjectIn3D(plocaluser);

  plocaluser->secs = -1.0;
  plocaluser->ext.user.move.remaintime = 0.0;
  updateBB(plocaluser);

  mobilelist = addObjectToList(plocaluser, mobilelist);
  insertObjectIntoGrid(plocaluser);

  declareCreation(&(plocaluser->noh));
  wmgtlockstate = LOCK_TOBUILD;
  httpOpen(urlcfg, readCfg, NULL, NO_BLOCK);

#ifndef WANT_TCL
  updateMemberWorld(plocaluser->h_name, worldname);
#endif

  updateObjectIn3D(plocaluser);
  updateCameraFromObject(plocaluser);
}

/* closing a world */
Public
void quitWorld()
{
  ObjectList tmplist, freelist;

  freeGrid();
  
  /* close walls */
  delete_walls();

  for (tmplist = stilllist; tmplist != NULL;) {
    freelist = tmplist;

    /* close 3D */
    SolidDelete(tmplist->pobject->soh);

    /* close interface */
#ifndef WANT_TCL
    selectedObjectDeletion(tmplist->pobject->soh);
#endif

    memset(tmplist->pobject, 0, sizeof(WObject));
    free(tmplist->pobject);
    tmplist = tmplist->next;
    free(freelist);
  }
    
  for (tmplist = mobilelist; tmplist->pobject != plocaluser; ) {
    freelist = tmplist;

    /* close 3D */
    SolidDelete(tmplist->pobject->soh);

    /* close interface */
#ifndef WANT_TCL
    if (tmplist->pobject->noh.type == USERTYPE) {
      trace(DBG_WMGT, "quitWorld: userLoggingOut");
      userLoggingOut(tmplist->pobject->ext.user.interfacebuf);
      /* sometimes segmentation fault */
      trace(DBG_WMGT, "quitWorld: memberQuitting");
      /* memberQuitting(tmplist->pobject->ext.user.interfacebuf); */
      *rtpname = '\0';
      *rtpemail = '\0';
      *worldname = '\0';
      /* updateMemberWorld(tmplist->pobject->ext.user.interfacebuf, tmplist->pobject->ext.user.world); */
      updateMemberWorld(tmplist->pobject->ext.user.interfacebuf, NULL);
    }
    selectedObjectDeletion(tmplist->pobject->soh);
#endif

    /* close network */
    trace(DBG_WMGT, "Wmgt: quit %s", tmplist->pobject->h_name);
    if (!(tmplist->pobject->noh.permanent))
      declareDeletion(&(tmplist->pobject->noh));
    deleteNetObject((NetObject*) (tmplist->pobject));
    memset(tmplist->pobject, 0, sizeof(WObject));
    free(tmplist->pobject);
    tmplist = tmplist->next;
    free(freelist);
  }
  declareDeletion(&(plocaluser->noh));
  deleteNetObject(&(plocaluser->noh));

  ChannelClose(channels_list);
  quittools();
}

/* closing module Wmgt */
Public
void quitWMgt()
{
  ObjectList tmplist, freelist;

  freeGrid();
  for (tmplist = stilllist; tmplist != NULL; ) {
    freelist = tmplist;

    /* close 3D */
    SolidDelete(tmplist->pobject->soh);

    /* close interface */
#ifndef WANT_TCL
    selectedObjectDeletion(tmplist->pobject->soh);
#endif

    memset(tmplist->pobject, 0, sizeof(WObject));
    free(tmplist->pobject);
    tmplist = tmplist->next;
    free(freelist);
  }
    
  for (tmplist = mobilelist; 
       (tmplist != NULL) && (tmplist->pobject != plocaluser); ) {
    freelist = tmplist;

    /* close 3D */
    SolidDelete(tmplist->pobject->soh);

    /* close interface */
#ifndef WANT_TCL
    if (tmplist->pobject->noh.type == USERTYPE) {
      trace(DBG_WMGT, "QuitWMgt: userLoggingOut");
      userLoggingOut(tmplist->pobject->ext.user.interfacebuf);
      trace(DBG_WMGT, "QuitWMgt: memberQuitting");
      /* memberQuitting(tmplist->pobject->ext.user.interfacebuf); */
      *rtpname = '\0';
      *rtpemail = '\0';
      *worldname = '\0';
    }
    selectedObjectDeletion(tmplist->pobject->soh);
#endif

    /* close network */
    trace(DBG_WMGT, "Wmgt: quit %s", tmplist->pobject->h_name);
    if (tmplist != NULL) {
      if (!(tmplist->pobject->noh.permanent))
	declareDeletion(&(tmplist->pobject->noh));
      deleteNetObject((NetObject*) (tmplist->pobject));
      memset(tmplist->pobject, 0, sizeof(WObject));
      free(tmplist->pobject);
    }
    tmplist = tmplist->next;
    free(freelist);
  }

  /* destroy local user */
  if (plocaluser != NULL) {
    declareDeletion(&(plocaluser->noh));
    deleteNetObject(&(plocaluser->noh));
    SolidDelete(plocaluser->soh);
    memset(plocaluser, 0, sizeof(WObject));
    free(plocaluser);
  }
  ChannelClose(channels_list);

  /*
   * quit all tools
   */
  quitalltools();
}
