/*
   File     : vreng.c
   Author   : Lionel ULMER
   Creation : 04/12/96

   Modules Initialization
*/

#include "global.h"
#include "initui.h"
#include "initfuncs.h"
#include "supportfuncs.h"
#include "http.h"
#include "defaults.h"
#include "mc.h"

extern void mainLoop();

int main(int argc, char *argv[])
{
  /*
   * lower priority
   */
  nice(NZERO + 10);

  /*
   * System Infos
   */
  initsysinfo();

  /*
   *  Arithmetic Initialization
   */
  #ifdef HAVE_FPSETMASK
  fpsetmask(0L);
  #endif

  /*
   * Environment Initialization
   */
  initEnv();

  /*
   * Resources Initialization
   */
  initResources(argc, argv);
  trace(DBG_INIT, "Resources initialized");

  /*
   *  Silmutaneous http connections Initialization
   */
  initThreads();
  trace(DBG_INIT, "Threads initialized");

  /*
   *  Signals Initialization
   */
  initSignals();
  trace(DBG_INIT, "Signals initialized");

  /*
   * Xlib Initialization: GC, shared mem,...
   */
  if (XInit(topLevel)) {
    fprintf(stderr,"Error in Xinit\n");
    exit(-1);
  }
  trace(DBG_INIT, "Xlib initialized");

  /*
   * Paned Window Initialization
   */
  initPaned();
  trace(DBG_INIT, "Paned Window initialized");

  /*
   * Network Initialization
   */
  ChannelInit();
  strncpy(grouporigin, getvrgroup(resources.multicast), GROUP_LEN);
  portorigin = getvrport(resources.multicast);
  ttlorigin = getvrttl(resources.multicast);
  trace(DBG_INIT, "Group origin=%s, TTL origin=%d", curr_chan, ttlorigin);
#ifdef SUPER
  cnt_super_fd = ChannelOpen(pchan, resources.multicast, &tab_super_fd);
#endif
  initialChannel(INITIAL_CHANNEL);
  trace(DBG_INIT, "Group initial=%s", curr_chan);
  strncpy(urlinitial, resources.world, URL_LEN);
  localWorldName(urlinitial);
  strncpy(groupinitial, getvrgroup(curr_chan), GROUP_LEN);
  portinitial = getvrport(curr_chan);
  trace(DBG_INIT, "Network initialized");

  /*
   * World Initialization
   */
  trace(DBG_INIT, "cfg initial = %s", urlinitial);
  WmgtInit(urlinitial, resources.nick, resources.skinf, resources.skinb);
  trace(DBG_INIT, "Wmgt initialized");
  worldinit = 1;

  /*
   * mainLoop
   */
  mainLoop();

  /* NOT_REACHED */
}
