#!/bin/sh
# The next line is a TK comment, but a shell command \
	exec wish "$0" "$@" & exit 0

# resolve_link --
#
#   Procedure to resolve the final directory from a single link
#   or set of links to a file or directory.
#
# Args
#
#   p_link - Starting link or directory.  Directories do
#                not get resolved.
#
# Returns
#
#   Final destination directory that a link points to.  If a
#   directory is passed to the procedure, then the directory
#   name is returned since there is nothing to resolve.

proc resolve_link { p_link } {
    switch [file type $p_link] {
	link {
	    set p_link [file join [file dirname $p_link] \
		    [file readlink $p_link]]
	    resolve_link $p_link
	}
	file {
	    return [file dirname $p_link]
	}
	directory {
	    return $p_link
	}
    }
}

# Define the application's global option database.
option clear
option add *borderWidth 1
option add *selectBackground #d9d9d9
option add *selectForeground #000000
option add *activeBackground #d9d9d9
option add *activeForeground #000000
option add *Entry.background #ffffff
option add *Entry.foreground #000000
option add *TabnotebookFrame.borderWidth 2
option add *TabnotebookFrame.relief groove
option add *Menu.borderWidth 1
option add *Menu.activeBorderWidth 1
option add *Menu.tearOff 0
option add *Menu.activeBackground #ececec
option add *Menubutton.activeBackground #d9d9d9
option add *Scrollbar.activeBackground #ececec

# Define some odds and ends that will be used by the application
# that will change as time goes on.
set tkWorld(version) "1.2.0"
set tkWorld(copyright) "Copyright (C) 1996-1999 Wesley H. Bailey"
set tkWorld(email) "tkworld@tkworld.org"
set tkWorld(www) "http:://www.tkworld.org"
set tkWorld(ostype) [string tolower $tcl_platform(platform)]

# Define the home directory for tkWorld.  Make sure to follow links
#   since a user might put the source code in /usr/local/src/tkWorld
#   and have a link in /usr/local/bin.
cd [set tkWorld(home) [resolve_link [info script]]]

# Setup the tkWorld script directory structure based on the home
# directory.
set tkWorld(lib_dir) [file join $tkWorld(home) lib]
set tkWorld(tcl_dir) [file join $tkWorld(lib_dir) tcl]
set tkWorld(image_dir) [file join $tkWorld(lib_dir) images]
set tkWorld(registry_dir) [file join $tkWorld(lib_dir) registry]
set tkWorld(help_dir) [file join $tkWorld(lib_dir) help]

# Define the tkWorld user information.
if [info exists env(USER)] {
    set tkWorld(user) $env(USER)
} elseif [info exists env(USERNAME)] {
    set tkWorld(user) $env(USERNAME)
} elseif [info exists env(LOGNAME)] {
    set tkWorld(user) $env(LOGNAME)
} else {
    set tkWorld(user) unknown
}

# Setup tkWorld to display start/finish header labels.
set tkWorld(start_finish_display) 1

# Define the users default shell to the Bourne Shell to execute
# the commands from.
set tkWorld(working_shell) "sh"

# Define the working directory for the scripts to be executed from.
set tkWorld(user_home) $env(HOME)
set tkWorld(working_dir) $env(HOME)

# Source all of the library scripts.
foreach f [glob -nocomplain [file join $tkWorld(tcl_dir) *.tcl]] {
    source $f
}

# Source all of the scripts in the registry.
foreach f [glob -nocomplain [file join $tkWorld(registry_dir) *.tcl]] {
    source $f
}

# Define the directory for executing the shell scripts.
if {[file writable /tmp]} {
    set tkWorld(script_dir) /tmp
} elseif {[file writable [file join / usr tmp]]} {
    set tkWorld(script_dir) [file join / usr tmp]
} elseif {[file writable $tkWorld(home)]} {
    set tkWorld(script_dir) $tkWorld(home)
} else {
    stderr::log 0003 "You do not have write permission to the\
	    $tkWorld(home) directory.  Please restart tkWorld in a\
	    directory that you have write permissions in"
}

# Startup the application
if {[lindex $argv 0] == "debug"} {
    gui::create
} else {
    placard::create
}