/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>


char *strconcat(char *a, char *b)
{
  size_t la = strlen(a);
  size_t lb = strlen(b);
  char *p = malloc(la + lb + 1);
  memcpy(p, a, la);
  memcpy(p + la, b, lb);
  p[la + lb] = '\0';
  return p;
}

char *strconcat3(char *a, char *b, char *c)
{
  size_t la = strlen(a);
  size_t lb = strlen(b);
  size_t lc = strlen(c);
  char *p = malloc(la + lb + lc + 1);
  memcpy(p, a, la);
  memcpy(p + la, b, lb);
  memcpy(p + la + lb, c, lc);
  p[la + lb + lc] = '\0';
  return p;
}

void *anydup(void *p, int size)
{
  void *r;
  
  r = malloc(size);
  memcpy(r, p, size);
  return r;
}


#ifdef MYMALLOC

typedef struct {
  int size;
  int line;
  char *file;
} info;


GHashTable *m;

static void display(gpointer key, gpointer value, gpointer user_data)
{
  info *i = (info *) value;
  fprintf(stderr, "%s:%d: this malloc was not freed (%d bytes, @ %p)\n", i->file, i->line, i->size, key);
}

static void malloced(void *p, int size, int line, char *file)
{
  info *i = malloc(sizeof(info));
  i->size = size;
  i->line = line;
  i->file = strdup(file);
  
  g_hash_table_insert(m, p, (gpointer) i);
}

static void freed(void *p, int line, char *file)
{
  if (g_hash_table_lookup(m, p) == NULL) fprintf(stderr, "%s:%d: already freed (@ %p)\n", file, line, p);
  g_hash_table_remove(m, p);
}

static void display_notfreed()
{
  fprintf(stderr, "**********************************************************************\n");
  fprintf(stderr, "* REPORT *************************************************************\n");  
  g_hash_table_foreach(m, (GHFunc) display, NULL);
  fprintf(stderr, "**********************************************************************\n");
}


void mystart()
{
  m = g_hash_table_new(g_direct_hash, NULL);
}

void *_malloc(int size, int line, char *file)
{
  void *p;
  
  p = malloc(size);
  malloced(p, size, line, file);
  
  return p;
}

void _free(void *ptr, int line, char *file)
{
  freed(ptr, line, file);
  free(ptr);
}

void *_realloc(void *ptr, int size, int line, char *file)
{
  void *p;
  
  freed(ptr, line, file);
  p = realloc(ptr, size);
  malloced(p, size, line, file);

  return p;
}

void myexit(int status)
{
  display_notfreed();
  exit(status);
}

char *_strdup(char *s, int line, char *file) 
{
  return strcpy(_malloc(strlen(s) + 1, line, file), s);
}

char *_strconcat(char *a, char *b, int line, char *file)
{
  char *p = strconcat(a, b);
  malloced(p, strlen(a) + strlen(b) + 1, line, file);
  return p;
}

char *_strconcat3(char *a, char *b, char *c, int line, char *file)
{
  char *p = strconcat3(a, b, c);
  malloced(p, strlen(a) + strlen(b) + strlen(c) + 1, line, file);
  return p;
}

void *_anydup(void *p, int size, int line, char *file)
{
  char *r = anydup(p, size);
  malloced(p, size, line, file);
  return r;
}


#else

void mystart() {}

#endif

