/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#include "menu_pop.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>

#define string_width(S) gdk_string_width(menu->style->font, S)



static int stop_key_press_event(GtkWidget *widget) 
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
  return FALSE;
}



extern GtkWidget *create_menu(SfmView *view, menuitem *items, int nb)
{
  int i, m, l, space_size, max, *sizes = int_malloc(nb);
  char tmp[tmpSize];
  GtkWidget *item, *menu = gtk_menu_new();

  gtk_signal_connect(GTK_OBJECT(menu), "key_press_event", (GtkSignalFunc) stop_key_press_event, NULL);

  for (max = i = 0; i < nb; i++) {
    sizes[i] = string_width(items[i].name) + string_width(items[i].shorcut);
    if (sizes[i] > max) max = sizes[i];
  }
  space_size = string_width(" ");
  max += 20;

  for (i = 0; i < nb; i++) {
    l = strlen(items[i].name);
    if (l == 0) {
      item = gtk_menu_item_new();
    } else {
      m = (max - sizes[i]) / space_size;
      memcpy(tmp, items[i].name, l);
      memset(tmp + l, ' ', m);
      strcpy(tmp + m + l, items[i].shorcut);
      item = gtk_menu_item_new_with_label(tmp);
      gtk_widget_set_sensitive(item, 1);
      gtk_signal_connect_object(GTK_OBJECT(item), "activate", (GtkSignalFunc) sfm_view_do_it, (gpointer) items[i].action);
    }
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);
  }
  free(sizes);
  return menu;
}


extern void add_submenu(char *name, GtkWidget *menu, GtkWidget *submenu)
{
  GtkWidget *item;

  item = gtk_menu_item_new_with_label(name);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);
  gtk_menu_append(GTK_MENU(menu), item);
  gtk_widget_show(item);
}
