;;;; $Id: hooks.scm,v 1.2 2000/01/13 07:28:08 gjb Exp $
;;;; Copyright (C) 1999, 2000 Greg J. Badros
;;;;
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;;;; Boston, MA 02111-1307 USA
;;;;

(define-module (app scwm hooks)
  :use-module (app scwm base))

(defmacro-public define-scwm-hook (sym args docstring)
  "Define SYM to be a new scwm hook that takes ARGS arguments.
DOCSTRING is documentation about the hook."
  `(begin (define-public ,sym (make-hook ,args))
	  (set-object-property! ,sym 'doc ,docstring)
	  ,sym))
