// 
// $Id: qaregexpwidget.hpp,v 1.2 1999/08/16 02:01:39 amos Exp $
//
// Definition of QRegExpWidget class
//
// Jan Borsodi <amos@abn.hibu.no>
// Created on: <21-Jul-1999 21:22:47 amos>
//
// Copyright (C) 1999 Jan Borsodi.  All rights reserved.
//

#ifndef QREGEXPWIDGET_HPP
#define QREGEXPWIDGET_HPP

#include <qaregexp.hpp>

#include <qframe.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qstring.h>
#include <qmultilinedit.h>
#include <qtextview.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qmainwindow.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qlistbox.h>

class QaRegExpWidget : public QMainWindow
{
    Q_OBJECT
public:
    QaRegExpWidget( QWidget *parent = 0, const char *name = 0 );
    virtual ~QaRegExpWidget();

    void convertText( QString &s );
    QString toHtml( const QString &s );
    void updateMatch();
    void updateOutput();
    void updateOutputMultiple();

public slots:
    void textChange( const QString &t );
    void valueChange( int val );
    void valueChangeMultiple( int val );
    void multiTextChanged();
    void doNormal();
    void doMultiple();
    void doLoad();
    void doSave();
    void doCase();

private:
    QString wordCharacters();

    QVBoxLayout *Lay;
    QMultiLineEdit *Edit;
    QTextView *TextVu;
    QLabel *ErrLabel;
//    QSpinBox *Sub;
    QListBox *Sub;
    QListBox *Matches;
    QaRegExp Reg;
    QString EditString;
    QWidget *Central;
    bool Multiple;
    int MatchCount;
    int SubMatch;

    QPopupMenu *FileMenu;
    QPopupMenu *MatchMenu;
    QPopupMenu *ModesMenu;
    QPopupMenu *EditMenu;
    int MatchNormalID;
    int MatchMultipleID;
    int MatchCaseID;
    int SubValue;
};

#endif // QREGEXPWIDGET_HPP
