/***************************************************************************
                          settings.h  -  settings for QBrew
                             -------------------                                         
    begin                : September 22nd 1999
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/
#ifndef SETTINGS_H
#define SETTINGS_H

#include <qmap.h>

/**
  *A settings manager for QBrew.
  *It is based on the Store class.
  *@author David Johnson
  */

class Settings {
public:
	/** constructor */
	Settings();
	/** destructor */
	~Settings();
	
	/** insert a setting */
	void insertSetting(const QString &name, const QString &value);
	/** retrieve a setting */
	const QString retrieveSetting(const QString &name);
	/** save settings to file */
	bool saveSettings(const QString &filename, const QString &appname);
	/** load settings from file */
	bool loadSettings(const QString &filename, const QString &appname);	
	
private:
	QMap<QString, QString> map;
};

#endif






