/***************************************************************************
                          miscpage.cpp  -  tabbed dialog page for misc ingr.
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include "qbrewview.h"

#include "miscpage.h"

MiscPage::MiscPage(QWidget *parent, const char *name, QObject *doc, QObject *calc)
	: IngredientPage(parent, name, doc, calc)
{
	currentItem = 0;
	// setup listview
	itemsListView->addColumn(tr("Notes"));
	itemsListView->setColumnAlignment(2, AlignLeft);
	itemsListView->setSorting(0);
	itemsListView->setSorting(1);
	itemsListView->setSorting(2);
	
	// setup widgets
	quantitySpin->setSuffix(tr(" units"));
	notesLabel = new QLabel(tr("Notes"), this, "notesLabel");
	notesEdit = new QLineEdit(this, "notesEdit");
	
	// setup layout
	rowTwoLayout->addWidget(quantityLabel, 0);
	rowTwoLayout->addWidget(quantitySpin, 0, AlignRight);
	rowTwoLayout->addWidget(notesLabel, 0);
	rowTwoLayout->addWidget(notesEdit, 1);
	
	delete spacer;
	rowTwoLayout->addWidget(addButton, 0);
	rowTwoLayout->addWidget(applyButton, 0);
	rowTwoLayout->addWidget(removeButton, 0);
	
	// set the leftmost labels to the same minimum size
	quantityLabel->adjustSize();
	quantityLabel->setMinimumWidth(quantityLabel->width());
	itemLabel->setMinimumWidth(quantityLabel->width());
	
	// fixup tab orders
	QWidget::setTabOrder(itemCombo, quantitySpin);
	QWidget::setTabOrder(quantitySpin, notesEdit);

	// setup connections
	connect(itemCombo,SIGNAL(activated(const QString &)),this,SLOT(slotUpdateEntryItems(const QString &)));	
	connect(addButton, SIGNAL(clicked()), SLOT(slotAddMiscIngredient()));
	connect(applyButton, SIGNAL(clicked()), SLOT(slotApplyMiscIngredient()));
	connect(removeButton, SIGNAL(clicked()), SLOT(slotRemoveMiscIngredient()));
	connect(itemsListView, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotItemSelected(QListViewItem *)));
	// initialize widgets with values
	slotDocumentChanged();
}

MiscPage::~MiscPage() {}

///////////////////////////////////////////////////////////////////////////////
// utility routines

void MiscPage::slotUpdateEntryItems(const QString &name)
{
	// highlight the appropriate entry in the listview, if available
	QListViewItem *item = itemsListView->firstChild();
	while (item != 0) {
		if (item->text(0) == name) {
			itemsListView->setSelected(item, true);
			// this sends the signal selectionChanged()
			return;
		}
		item = item->nextSibling();
	}
	// wasn't in the listview, update from database		
	MiscIngredient *thisMiscIngredient = ((QBrewCalc *)calcdata)->getMisc(name);
	quantitySpin->setValue(thisMiscIngredient->getQuantity());
	notesEdit->setText(thisMiscIngredient->getNotes());
}

void MiscPage::updateListView()
{
	MiscIngredientList *list = ((QBrewDoc *)document)->getMiscIngredientList();
    MiscIngredientIterator it;
    MiscIngredientListItem *item;
	itemsListView->clear();
    for (it=list->begin(); it != list->end(); ++it) {
    	item = new MiscIngredientListItem( itemsListView, (*it).getName(),
    		(*it).getQuantityString(),
    		(*it).getNotes() );
    	item->setMiscIngredientIterator(it);
    }
}

///////////////////////////////////////////////////////////////////////////////
// slots

void MiscPage::slotDocumentChanged()
{
	// received if document has changed
	itemCombo->clear();
	itemCombo->insertStringList(((QBrewCalc *)calcdata)->getMiscList());
	slotUpdateEntryItems(itemCombo->currentText());
	updateListView();
}

void MiscPage::slotAddMiscIngredient()	
{
    MiscIngredientIterator it;
    MiscIngredientListItem *item;
	it = ((QBrewDoc *)document)->addMiscIngredient(itemCombo->currentText(), quantitySpin->value(),
		notesEdit->text());
    item = new MiscIngredientListItem( itemsListView, (*it).getName(),
    	(*it).getQuantityString(),
    	(*it).getNotes() );
	item->setMiscIngredientIterator(it);
}

void MiscPage::slotApplyMiscIngredient()	
{
 	if (currentItem != 0) {
		((QBrewDoc *)document)->applyMiscIngredient(currentItem->getMiscIngredientIterator(),
			itemCombo->currentText(), quantitySpin->value(), notesEdit->text());
		currentItem->setToIterator();
	}
}

void MiscPage::slotRemoveMiscIngredient()	
{
	if (currentItem != 0) {
	((QBrewDoc *)document)->removeMiscIngredient(currentItem->getMiscIngredientIterator()); 	
		delete currentItem;
		currentItem = 0;
	}
}

void MiscPage::slotItemSelected(QListViewItem *item)
{
	currentItem = (MiscIngredientListItem *)item;
	if (item != 0) {
		itemCombo->setEditText(item->text(0));
		quantitySpin->setValue(item->text(1).remove(item->text(1).find('.'), 1).toUInt());
		notesEdit->setText(item->text(2));
	}
}












