/***************************************************************************
                          hopspage.h  -  tabbed dialog page for hops
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef HOPSPAGE_H
#define HOPSPAGE_H

#include <qcheckbox.h>

#include "hops.h"
#include "ingredientpage.h"

/**
  *@author David Johnson
  */
class HopsPage : public IngredientPage  {
   Q_OBJECT
public: 
	/** constructor */
	HopsPage(QWidget *parent, const char *name, QObject *doc, QObject *calc);
	/** destructor */
	~HopsPage();

protected slots:
	/** received if add clicked */	
	void slotAddHops();	
	/** received if remove clicked */	
	void slotRemoveHops();	
	/** received if apply clicked */	
	void slotApplyHops();	
	/** receives if document has changed */
	void slotDocumentChanged();
	/** update the widgets in the entry area */
	void slotUpdateEntryItems(const QString &name);
	/** received if an ingredient was selected */
	void slotItemSelected(QListViewItem *item);
private:
	/** update the list view */
	void updateListView();
	
private:
	QLabel *formLabel;
	QComboBox *formComboBox;
	QLabel *alphaLabel;
	FixedSpinBox *alphaSpin;
	QLabel *timeLabel;
	QSpinBox *timeSpin;
	HopsListItem *currentItem;	
};

#endif





