/***************************************************************************
                          grainpage.h  -  tabbed dialog page for grains
                             -------------------                                         
    begin                : Sun Oct 10 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef GRAINPAGE_H
#define GRAINPAGE_H

#include <qcheckbox.h>

#include "grain.h"
#include "ingredientpage.h"

/**
  *@author David Johnson
  */
class GrainPage : public IngredientPage  {
	Q_OBJECT
public:
	/** constructor */
	GrainPage(QWidget *parent, const char *name, QObject *doc, QObject *calc);
	/** destructor */
	~GrainPage();

protected slots:
	/** recieved if add clicked */	
	void slotAddGrain();	
	/** recieved if remove clicked */	
	void slotRemoveGrain();	
	/** recieved if apply clicked */	
	void slotApplyGrain();	
	/** receives if document has changed */
	void slotDocumentChanged();
	/** update the widgets in the entry area */
	void slotUpdateEntryItems(const QString &name);
	/** received if an ingredient was selected */
	void slotItemSelected(QListViewItem *item);
private:
	/** update the list view */
	void updateListView();
	/** set a combobox to item */
	void setComboItem(QComboBox *combo, const QString &txt);
	
private:
	QLabel *extractLabel;
	FixedSpinBox *extractSpin;
	QLabel *colorLabel;
	FixedSpinBox *colorSpin;
	QLabel *useLabel;
	QComboBox *useComboBox;
	GrainListItem *currentItem;	
};

#endif





