/***************************************************************************
                          grainpage.cpp  -  tabbed dialog page for grains
                             -------------------                                         
    begin                : Sun Oct 10 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include "resource.h"
#include "qbrewview.h"

#include "grainpage.h"

GrainPage::GrainPage(QWidget *parent, const char *name, QObject *doc, QObject *calc)
	: IngredientPage(parent, name, doc, calc)
{
	currentItem = 0;
	
	// setup listview
	itemsListView->addColumn(tr("Extract"));
	itemsListView->addColumn(tr("Color"));
	itemsListView->addColumn(tr("Use"));
	itemsListView->setColumnAlignment(2, AlignRight);
	itemsListView->setColumnAlignment(3, AlignRight);
	itemsListView->setColumnAlignment(4, AlignRight);
	itemsListView->setSorting(0);
	itemsListView->setSorting(1);
	itemsListView->setSorting(2);
	itemsListView->setSorting(3);
	itemsListView->setSorting(4);
	
	// setup widgets
	quantitySpin->setSuffix(tr(" lbs"));
	extractLabel = new QLabel(tr("Extract"), this, "extractLabel");
	extractSpin = new FixedSpinBox(1000, 1100, 1, 3, this, "extractSpin");
	colorLabel = new QLabel(tr("Color"), this, "colorLabel");
	colorSpin = new FixedSpinBox(0, 5000, 10, 1, this, "colorSpin");
	colorSpin->setSuffix(CHAR_LATIN_DEGREE);
	useLabel = new QLabel(tr("Use"), this, "useLabel");
	useComboBox = new QComboBox(false, this, "useComboBox");	
	useComboBox->insertStringList(Grain::getUseStringList());

	// setup layout
	rowTwoLayout->addWidget(quantityLabel, 0);
	rowTwoLayout->addWidget(quantitySpin, 0, AlignRight);
	rowTwoLayout->addWidget(extractLabel, 0);
	rowTwoLayout->addWidget(extractSpin, 0);
	rowTwoLayout->addWidget(colorLabel, 0);
	rowTwoLayout->addWidget(colorSpin, 0);
	rowTwoLayout->addWidget(useLabel, 0);
	rowTwoLayout->addWidget(useComboBox, 0);
	
	rowTwoLayout->addWidget(spacer, 1);
	rowTwoLayout->addWidget(addButton, 0);
	rowTwoLayout->addWidget(applyButton, 0);
	rowTwoLayout->addWidget(removeButton, 0);
	
	// set the leftmost labels to the same minimum size
	quantityLabel->adjustSize();
	quantityLabel->setMinimumWidth(quantityLabel->width());
	itemLabel->setMinimumWidth(quantityLabel->width());
	
	// fixup tab orders
	QWidget::setTabOrder(itemCombo, quantitySpin);
	QWidget::setTabOrder(quantitySpin, extractSpin);
	QWidget::setTabOrder(extractSpin, colorSpin);
	QWidget::setTabOrder(colorSpin, useComboBox);

	// setup connections
	connect(itemCombo,SIGNAL(activated(const QString &)),this,SLOT(slotUpdateEntryItems(const QString &)));	
	connect(addButton, SIGNAL(clicked()), SLOT(slotAddGrain()));
	connect(applyButton, SIGNAL(clicked()), SLOT(slotApplyGrain()));
	connect(removeButton, SIGNAL(clicked()), SLOT(slotRemoveGrain()));
	connect(itemsListView, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotItemSelected(QListViewItem *)));
	// initialize widgets with values
	slotDocumentChanged();
}

GrainPage::~GrainPage() {}

///////////////////////////////////////////////////////////////////////////////
// utility routines

/** TODO: this is a duplicate from QBrewView. Make a global utility routine instead */
void GrainPage::setComboItem(QComboBox *combo, const QString &txt)
{
	int item;
	// search combo box for style string
	for (item = 0; item < combo->count(); item++) {
		if (combo->text(item) == txt) {
			combo->setCurrentItem(item);
			return;
		}
	}
	// if item not found, will set it to the first one
	combo->setCurrentItem(0);
}

void GrainPage::slotUpdateEntryItems(const QString &name)
{
	Grain *thisgrain = ((QBrewCalc *)calcdata)->getGrain(name);
	quantitySpin->setValue(thisgrain->getQuantity());
	extractSpin->setValue(thisgrain->getExtract());
	colorSpin->setValue(thisgrain->getColor());
	/** vary default use according to recipe type */
	int utemp = thisgrain->getUse();
	QString ustr = thisgrain->getUseString();
	if (((QBrewDoc *)document)->getMash()) {
		if (utemp == GRAIN_STEEPED) ustr = tr("mashed");
	} else {
		if (utemp == GRAIN_MASHED) ustr = tr("steeped");
	}
	setComboItem(useComboBox, ustr);
}

void GrainPage::updateListView()
{
	GrainList *list = ((QBrewDoc *)document)->getGrainList();
    GrainIterator it;
    GrainListItem *item;
	itemsListView->clear();
    for (it=list->begin(); it != list->end(); ++it) {
    	item = new GrainListItem( itemsListView, (*it).getName(),
    		(*it).getQuantityString(),
    		(*it).getExtractString(),
    		(*it).getColorString(),
    		(*it).getUseString() );
		item->setGrainIterator(it);
    }
}

///////////////////////////////////////////////////////////////////////////////
// slots

void GrainPage::slotDocumentChanged()
{
	// received if document has changed
	itemCombo->clear();
	itemCombo->insertStringList(((QBrewCalc *)calcdata)->getGrainsList());
	slotUpdateEntryItems(itemCombo->currentText());
	updateListView();
}

void GrainPage::slotAddGrain()	
{
    GrainIterator it;
    GrainListItem *item;
	it = ((QBrewDoc *)document)->addGrain(itemCombo->currentText(), quantitySpin->value(),
		extractSpin->value(), colorSpin->value(), useComboBox->currentText());
    item = new GrainListItem( itemsListView, (*it).getName(),
    	(*it).getQuantityString(),
    	(*it).getExtractString(),
    	(*it).getColorString(),
    	(*it).getUseString() );
	item->setGrainIterator(it);
}

void GrainPage::slotApplyGrain()	
{
 	if (currentItem != 0) {
		((QBrewDoc *)document)->applyGrain(currentItem->getGrainIterator(), itemCombo->currentText(),
			quantitySpin->value(), extractSpin->value(), colorSpin->value(), useComboBox->currentText());
		currentItem->setToIterator();
	}
}

void GrainPage::slotRemoveGrain()	
{
	if (currentItem != 0) {
		((QBrewDoc *)document)->removeGrain(currentItem->getGrainIterator());
		delete currentItem;
		currentItem = 0;
	}
}

void GrainPage::slotItemSelected(QListViewItem *item)
{
	currentItem = (GrainListItem *)item;
	if (item != 0) {
		itemCombo->setEditText(item->text(0));
		quantitySpin->setValue(item->text(1).remove(item->text(1).find('.'), 1).toUInt());
		extractSpin->setValue(item->text(2).remove(item->text(2).find('.'), 1).toUInt());
		colorSpin->setValue(item->text(3).remove(item->text(3).find('.'), 1).toUInt());
		setComboItem(useComboBox, item->text(4));
	}
}


















