/*
** 1998-05-25 -	Header file for the collection of miscellaneous file utilities.
*/

/* This is filled-in by a call to fut_dir_size(). Very informative. */
typedef struct {
	guint	num_dirs;
	guint	num_files;
	guint	num_links;
	guint	num_cdevs;
	guint	num_bdevs;
	guint	num_fifos;
	guint	num_socks;	/* In your topmost drawer? :) */

	guint	num_total;	/* Sum of the above. */

	guint64	num_bytes;	/* For completeness. */
	guint64	num_blocks;
} FUCount;

/* ----------------------------------------------------------------------------------------- */

gint		fut_dir_length(DirPane *dp, const gchar *path, gsize *nsize, guint *num_links);
gint		fut_dir_size(MainInfo *min, const gchar *path, guint64 *bytes, FUCount *fc);
gint		fut_dir_size_progress(MainInfo *min, const gchar *path, guint64 *bytes, FUCount *fc);

const gchar *	fut_locate(const gchar *paths, const gchar *name);
GList *		fut_scan_path(const gchar *paths, gint (*filter)(const gchar *path, const gchar *name), gboolean with_path);
void		fut_free_path(GList *list);
gint		fut_path_component(const gchar *paths, gchar *component);

gsize		fut_copy(gint in, gint out, gsize length, gsize max_chunk);

gboolean	fut_cd(const gchar *new_dir, gchar *old, gsize old_max);

gboolean	fut_exists(const gchar *name);
gboolean	fut_size(const gchar *name, gsize *size);
gboolean	fut_fsize(gint fd, gsize *size);
void		fut_check_fd(const gchar *label);

gboolean	fut_can_read(struct stat *stat, uid_t uid, gid_t gid);
gboolean	fut_can_read_named(const gchar *name);
gboolean	fut_can_write(struct stat *stat, uid_t uid, gid_t gid);
gboolean	fut_can_execute(struct stat *stat, uid_t uid, gid_t gid);

gboolean	fut_locate_executable(const gchar *path, const gchar *name);

gboolean	fut_check_hide(DirPane *dp, const gchar *name);

void		fut_initialize(void);
