/*
** 1998-09-25 -	Header for the new command sequence module. It's a rewrite!
*/

#include "cmdarg.h"

typedef gint (*Command)(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca);
typedef void (*CommandCfg)(MainInfo *min);

void		csq_add_builtin(MainInfo *min, const gchar *name, Command cmd, CommandCfg cmd_cfg);

void		csq_cmdseq_filter_name(gchar *dst, const gchar *src);
const gchar *	csq_cmdseq_unique_name(GHashTable *hash);

const gchar *	csq_cmdseq_map_name(const gchar *name, const gchar *context);

CmdSeq *	csq_cmdseq_new(const gchar *name, guint32 flags);
void		csq_cmdseq_set_name(GHashTable *hash, CmdSeq *cs, char *name);
CmdSeq *	csq_cmdseq_copy(CmdSeq *src);
void		csq_cmdseq_hash(GHashTable **hash, CmdSeq *cs);

void		csq_cmdseq_destroy(CmdSeq *cs);
gint		csq_cmdseq_row_append(CmdSeq *cs, CmdRow *row);
gint		csq_cmdseq_row_move(CmdSeq *cs, CmdRow *row, gint delta);
gint		csq_cmdseq_row_delete(CmdSeq *cs, CmdRow *row);

gint		csq_execute(MainInfo *min, const gchar *name);
gint		csq_execute_format(MainInfo *min, const gchar *fmt, ...);
void		csq_continue(MainInfo *min);
void		csq_handle_ba_flags(MainInfo *min, guint32 flags);

const gchar *	csq_cmdrow_type_to_string(CRType type);
CRType		csq_cmdrow_string_to_type(const gchar *type);

CmdRow *	csq_cmdrow_new(CRType type, const gchar *def, guint32 flags);
CmdRow *	csq_cmdrow_copy(CmdRow *src);
void		csq_cmdrow_set_type(CmdRow *row, CRType type);
void		csq_cmdrow_set_def(CmdRow *row, const gchar *def);
void		csq_cmdrow_destroy(CmdRow *row);

void		csq_init_commands(MainInfo *min);
