/* Copyright (C) 1998 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/*$Id: gp_pthr.c,v 1.1.1.1 1999/02/22 03:04:25 scottc Exp $ */
/* pthreads interface */
#include "std.h"
#include <pthread.h>
#include "gserror.h"
#include "gserrors.h"
#include "gpsync.h"

int
gp_create_thread(gp_thread_creation_callback_t proc, void *proc_data)
{
    pthread_t ignore_thread;
    pthread_attr_t attr;
    int code;

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, 1);
    code = pthread_create(&ignore_thread, &attr, proc, proc_data);
    return (code ? gs_note_error(gs_error_ioerror) : 0);
}
