/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "global.h"
#include "color.h"
#include "menus.h"
#include "gtkhelp.h"
#include "stringfunctions.h"
#include "testinstall.h"
#include "filemanager.h"
#include "iconmanager.h"
#include "namedemultiplexer.h"
#include "extension.h"
#include "shell.h"
#include "pixmap.h"
#include "gui.h"
#include <string.h> 
#include <gtk/gtk.h>
#include "iwc.h"
#include <stdlib.h>
#include <stdio.h>
#include <mntent.h>

#define MENU_INFO	 0
#define MENU_HELP	 1
#define MENU_CONTEXT	 2
#define MENU_CREATEPRG	 3
#define MENU_SAVE	 4
#define MENU_DESKOPT	 5
#define MENU_QUIT	 6
#define MENU_KILL_X	 7
#define MENU_OPTIONS	 8
#define MENU_CREATEFIL	 9
#define MENU_CREATEFOL	10
#define MENU_UPDATE	11
#define MENU_RERECOG	12
#define MENU_SELECTALL	13
#define MENU_S_TYPE	14
#define MENU_S_NAME	15
#define MENU_S_EXT	16
#define MENU_S_DAT_ASC	17
#define MENU_S_DAT_DES	18
#define MENU_S_SIZ_ASC	19
#define MENU_S_SIZ_DES	20
#define MENU_ARRANGE	21
#define MENU_OPEN	22
#define MENU_XTERM	23
#define MENU_ROOTHOME	24
#define MENU_DELETE	25
#define MENU_NONE	26
#define MENU_EXIT	27
#define MENU_PARENT	28
#define MENU_NORMAL	29
#define MENU_DETAIL	30
#define MENU_STRUCTURE	31

char* retstring=NULL;
int retchoose=MENU_NONE;
char** tobefreed=NULL;
int tobefreedc=0;

GtkItemFactory* contextmenu=NULL;

void mycallback(gpointer data, guint i,GtkWidget *widget);

void mycallbacknone(GtkWidget *widget,gpointer data);

static GtkItemFactoryEntry menu_items[] =
{
  {"/DFM for X11/Info", NULL, mycallback, MENU_INFO},
  {"/DFM for X11/Help", NULL, mycallback, MENU_HELP},
  {"/DFM for X11/sep", NULL, NULL, 0,"<Separator>"},
  {"/sep", NULL, NULL, 0,"<Separator>"},
  {"/Mount", NULL, NULL, 0,"<LastBranch>"},
  {"/sep", NULL, NULL, 0,"<Separator>"},
  {"/Open", NULL, NULL, 0,"<Branch>"},
  {"/Options", "<control>O", mycallback, MENU_OPTIONS},
  {"/sep", NULL, NULL, 0,"<Separator>"},
  {"/Create/Folder", NULL, mycallback, MENU_CREATEFOL},
  {"/Create/File", NULL, mycallback, MENU_CREATEFIL},
  {"/Update", "Esc", mycallback, MENU_UPDATE},
  {"/Re-recognize", NULL, mycallback, MENU_RERECOG},
  {"/Select all", "<control>A", mycallback, MENU_SELECTALL},
  {"/sep", NULL, NULL, 0,"<Separator>"},
  {"/Delete", "Del", mycallback, MENU_DELETE},
  {"/sep", NULL, NULL, 0,"<Separator>"},
  {"/Sort/Type", "<control>Y", mycallback, MENU_S_TYPE},
  {"/Sort/Name", NULL, mycallback, MENU_S_NAME},
  {"/Sort/Extension", NULL, mycallback, MENU_S_EXT},
  {"/Sort/sep", NULL, NULL, 0,"<Separator>"},
  {"/Sort/Date Asc", NULL, mycallback, MENU_S_DAT_ASC},
  {"/Sort/Date Desc", NULL, mycallback, MENU_S_DAT_DES},
  {"/Sort/sep", NULL, NULL, 0,"<Separator>"},
  {"/Sort/Size Asc", NULL, mycallback, MENU_S_SIZ_ASC},
  {"/Sort/Size Desc", NULL, mycallback, MENU_S_SIZ_DES},
  {"/Arrange", NULL, mycallback, MENU_ARRANGE},
};

void mycallback(gpointer data, guint i,GtkWidget *widget)
{
  retchoose=i;
  if (i==MENU_OPEN) {
    free(retstring);
    retstring=strdup(data);
  }
  
  gtk_object_destroy(GTK_OBJECT(contextmenu));
  gtk_main_quit();
}

void mycallbackmount(gpointer data, guint i,GtkWidget *widget)
{
  retchoose=MENU_UPDATE;
  usershellsystem(data);
  /*UpdateIcons(False);try slow first*/
  gtk_object_destroy(GTK_OBJECT(contextmenu));
  gtk_main_quit();
}

void mycallbackumount(gpointer data, guint i,GtkWidget *widget)
{
  retchoose=MENU_UPDATE;
  usershellsystem(data);
  /*UpdateIcons(False);*/
  gtk_object_destroy(GTK_OBJECT(contextmenu));
  gtk_main_quit();
}

void mycallbacknone(GtkWidget *widget,gpointer data)
{
  GtkRequisition requisition;
  retchoose=MENU_NONE;
  gtk_widget_size_request(contextmenu->widget,&requisition);  

  gtk_object_destroy(GTK_OBJECT(contextmenu));
  gtk_main_quit();
}

void mygtk_additem(char *path,char *accelerator,
              GtkItemFactoryCallback callback,guint action,char *type,
	      char *point) {
  char* po;
  GtkItemFactoryEntry single;
  if (point!=NULL) {
    tobefreedc++;
    tobefreed=realloc(tobefreed,tobefreedc*sizeof(char*));
    po=strdup(point);
    tobefreed[tobefreedc-1]=po;
  } else 
    po=point;
  single.path=path;
  single.accelerator=accelerator;
  single.callback=callback;
  single.callback_action=action;
  single.item_type=type;
  gtk_item_factory_create_item(contextmenu,&single,po,1);
}

void Menu(char* name,int x,int y,int inwindow)
{
  GtkRequisition requisition;
  int i,j,nr;
  char *text,*text2,*text3,*cmd,*ent;
  char *pos,*icon,*start;
  int x1,y1,x2,y2;
  unsigned int width,height;
  unsigned int border,depth;
  Window root; 
  FILE *pfile,*pfile2;
  
  struct mntent *mnt,*mnt2;
  
  tobefreed=NULL;
  tobefreedc=0;
  contextmenu=gtk_item_factory_new(GTK_TYPE_MENU,"<Main>",NULL);
  gtk_item_factory_create_items(contextmenu,
				sizeof(menu_items) / sizeof(menu_items[0]),
				menu_items,NULL); 
  gtk_signal_connect (GTK_OBJECT (contextmenu->widget), "unmap_event",
                      GTK_SIGNAL_FUNC (mycallbacknone), NULL);
  
  if (GetIsDesktop()==True) {
    mygtk_additem("/DFM for X11/Desktop context menu", NULL, mycallback,
                  MENU_CONTEXT,"<CheckItem>",NULL);
    
    if (GetMainBackground()==True)
      GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(contextmenu,
      "/DFM for X11/Desktop context menu"
      ))->active=True;
    mygtk_additem("/DFM for X11/sep", NULL, NULL, 0,"<Separator>",NULL);
    mygtk_additem("/DFM for X11/Save positions&info", NULL, mycallback,MENU_SAVE,NULL,NULL);
    mygtk_additem("/DFM for X11/Desktop options", NULL, mycallback, MENU_DESKOPT,NULL,NULL);
    mygtk_additem("/DFM for X11/XTerm", NULL, mycallback, MENU_XTERM,NULL,NULL);
    mygtk_additem("/DFM for X11/sep", NULL, NULL, 0,"<Separator>",NULL);
    mygtk_additem("/DFM for X11/Kill X", NULL, mycallback, MENU_KILL_X,NULL,NULL);
    mygtk_additem("/DFM for X11/Quit", NULL, mycallback, MENU_QUIT,NULL,NULL);
    mygtk_additem("/Create/sep", NULL, NULL, 0,"<Separator>",NULL);
    mygtk_additem("/Create/New program icon", NULL, mycallback, MENU_CREATEPRG,NULL,NULL);
    mygtk_additem("/Create/root&home links", NULL, mycallback, MENU_ROOTHOME,NULL,NULL);
  } else 
    mygtk_additem("/DFM for X11/Exit", NULL, mycallback, MENU_EXIT,NULL,NULL);
  if (inwindow==False) { 
    GetFileInfoFromDesktop(name,&pos,&icon,&start);
    if (start!=NULL) {
      nr=NumberOfCmd(start);
      text=malloc(strlen("/Open/")+strlen(start)+1+strlen(" (Structure view)"));
      for (i=0;i<nr;i++) {
        cmd=ExtractCmd(start,i);
        ent=strdup(cmd);
        /* ItemFactory isn't able to display a slash :-( 
           using backslash instead */
        for (j=0;j<strlen(ent);j++)
          if (ent[j]=='/')
            ent[j]='\\';
	    
        strcpy(text,"/Open/");
        strcat(text,ent);
        free(ent);
	if (strcmp(cmd,"dfm !0!")==0)
	  strcat(text," (Normal view)");
	else if (strcmp(cmd,"dfm !0! -detail")==0)
	  strcat(text," (Detail view)");
	else if (strcmp(cmd,"dfm !0! -structure")==0)
	  strcat(text," (Structure view)");
        mygtk_additem(text, NULL, mycallback, MENU_OPEN,NULL,cmd);   
        free(cmd);
      }
      free(text);
    }
    free(pos);
    free(icon);
    free(start);
    if (name[strlen(name)-1]=='/') {
      mygtk_additem("/Open/sep", NULL, NULL, 0,"<Separator>",NULL);
      mygtk_additem("/Open/Normal view", "<control>N", mycallback, MENU_OPEN,NULL,"dfm !0!");
      mygtk_additem("/Open/Detail view", "<control>D", mycallback, MENU_OPEN,NULL,"dfm !0! -detail");
      mygtk_additem("/Open/Structure view", "<control>S", mycallback,MENU_OPEN,NULL,"dfm !0! -structure");
    }
  } else {
    if (GetKindOfWindow()!=NORMAL)
      mygtk_additem("/Open/Normal view", "<control>N", mycallback,MENU_NORMAL,NULL,NULL);
    if (GetKindOfWindow()!=DETAIL)
      mygtk_additem("/Open/Detail view", "<control>D", mycallback,MENU_DETAIL,NULL,NULL);
    if (GetKindOfWindow()!=STRUCTURE)
      mygtk_additem("/Open/Structure view", "<control>S",mycallback,MENU_STRUCTURE,NULL,NULL);
    if (strcmp(GetPath(),"~/")!=0) {
      mygtk_additem("/Open/sep", NULL, NULL, 0,"<Separator>",NULL);
      mygtk_additem("/Open/Parent folder", "<back>", mycallback,MENU_PARENT,NULL,NULL);
    }
    gtk_widget_set_sensitive(gtk_item_factory_get_widget(contextmenu,"/Delete"),FALSE);
    gtk_widget_set_sensitive(gtk_item_factory_get_widget(contextmenu,"/Re-recognize"),FALSE);
    
  }
  
  if ((pfile=fopen("/etc/fstab", "r"))!=NULL) {
    do {
      mnt=getmntent(pfile);
      if (mnt) {
        if (strstr(mnt->mnt_opts,"user")) {
	  text2=strdup(mnt->mnt_dir);
	  cmd=strdup(mnt->mnt_dir);
          for (j=0;j<strlen(cmd);j++)
            if (cmd[j]=='/')
              cmd[j]='\\';
	  text=malloc(strlen("/Mount/")+strlen(cmd)+1);
	  strcpy(text,"/Mount/");
	  strcat(text,cmd);
	  free(cmd);
          if ((pfile2=fopen("/etc/mtab", "r"))!=NULL) {
            do {
              mnt2=getmntent(pfile2);
              text3=NULL;
	      if (mnt2)
	        text3=strstr(mnt->mnt_dir,text2);
            } while (text3==NULL && mnt2!=NULL);
	    if (text3==NULL) {
	      text3=malloc(strlen("mount ")+strlen(text2)+1);
	      strcpy(text3,"mount ");
	      strcat(text3,text2);
              mygtk_additem(text, NULL, mycallbackmount, 0,"<ToggleItem>",text3);
	      free(text3);
	    } else {
	      text3=malloc(strlen("umount ")+strlen(text2)+1);
	      strcpy(text3,"umount ");
	      strcat(text3,text2);
              mygtk_additem(text, NULL, mycallbackumount, 0,"<ToggleItem>",text3);
              GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(contextmenu,
              text
              ))->active=True;
	      free(text3);
	    }
            fclose(pfile2);
          }
	  free(text);      
	  free(text2);      
	}
      }
    } while (mnt!=NULL);
    fclose(pfile);
  }
  /* make sure the menu size is calculated correctly 
     One iteration do only work once. Don't know why.*/
  gtk_main_iteration_do(False);
  gtk_main_iteration_do(False);
  gtk_widget_size_request(contextmenu->widget,&requisition);  
   
  XGetGeometry(GetDisplay(),XDefaultRootWindow(GetDisplay()),&root,&x1,&y1,&width,&height,&border,&depth);
  if (x>width-requisition.width)
    x2=width-requisition.width;
  else
    x2=x;
  if (y<requisition.height)
    y2=0;
  else
    y2=y-requisition.height;
  gtk_item_factory_popup(contextmenu,x2, y2,0,0);

  mygtk_main();
}

void MenuLaunch(Time time,char *fil,int inwindow,int x,int y)
{
  char *text,*filenames;
  char *mainname,*dropname;
  int i,j;
  
  filenames=malloc(strlen(fil)+2);
  if (fil[0]==' ')
    strcpy(filenames,"");
  else
    strcpy(filenames," ");
  strcat(filenames,fil);
  retstring=strdup("");
  
  i=1;
  while (filenames[i]!=0 && filenames[i]!=' ') {
    if (filenames[i]=='\\')
      i++;
    i++;
  }
 
  text=malloc(i);
  strncpy(text,filenames+1,i-1);
  text[i-1]=0;
  mainname=GenerateDeBackslashName(text);
  free(text);
  if (filenames[i]==' ') 
    dropname=strdup(filenames+i);
  else 
    dropname=NULL;
  Menu(mainname,x,y,inwindow);
  
  if (retchoose==MENU_ARRANGE) {
    SortIcons(ARRANGE);
    PlaceIcons();
  } else if (retchoose==MENU_S_TYPE) {
    SortIcons(TYPE);
    PlaceIcons();
  } else if (retchoose==MENU_S_NAME) {
    SortIcons(NAME);
    PlaceIcons();
  } else if (retchoose==MENU_S_EXT) {
    SortIcons(EXTENSION);
    PlaceIcons();
  } else if (retchoose==MENU_S_DAT_ASC) {
    SortIcons(DATEASC);
    PlaceIcons();
  } else if (retchoose==MENU_S_DAT_DES) {
    SortIcons(DATEDESC);
    PlaceIcons();
  } else if (retchoose==MENU_S_SIZ_ASC) {
    SortIcons(SIZEASC);
    PlaceIcons();
  } else if (retchoose==MENU_S_SIZ_DES) {
    SortIcons(SIZEDESC);
    PlaceIcons();
  } else if (retchoose==MENU_INFO) {
    Info();
  } else if (retchoose==MENU_HELP) {
    system("xterm -e man dfm &");
  } else if (retchoose==MENU_CONTEXT) {
    if (GetMainBackground()==True) {
      SetMainBackground(False);
      XUnmapWindow(GetDisplay(),GetWindow());
    } else {
      SetMainBackground(True);
      XMapWindow(GetDisplay(),GetWindow());
    }
  } else if (retchoose==MENU_SAVE) {
    SaveFileInfoFromDesktop();
  } else if (retchoose==MENU_DESKOPT) {
    ExecuteShellcommand("./.dfmdesk/","dfm -setdir !0!",NULL,0);
  } else if (retchoose==MENU_QUIT) {
    if (Question("Really want to leave DFM ?")==2) {
      XClearWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()));
      XFlush(GetDisplay());
      system("killall dfm");
      XCloseDisplay(GetDisplay());
      exit(0);
    }
  } else if (retchoose==MENU_KILL_X) { 
    if (Question("Really want to do a \"killall X\" ?")==2) 
      system("killall X");
  } else if (retchoose==MENU_EXIT) { 
    XCloseDisplay(GetDisplay());
    _exit(0);
  } else if (retchoose==MENU_RERECOG && inwindow==False) { 
    EraseMultipleInfo(filenames);
    UpdateIcons(False);
  } else if (retchoose==MENU_SELECTALL) { 
    SetAllMarks();
  } else if (retchoose==MENU_DELETE) { 
    EraseCall(filenames,True,False);
    UpdateIcons(True);
  } else if (retchoose==MENU_CREATEFOL) { 
    NewFolder();
  } else if (retchoose==MENU_CREATEFIL) {
    NewFile();
  } else if (retchoose==MENU_CREATEPRG) {
    NewProgram();
  } else if (retchoose==MENU_ROOTHOME) {
    makehomelinks();      
    UpdateIcons(False);
  } else if (retchoose==MENU_UPDATE) {
    UpdateIcons(False);
  } else if (retchoose==MENU_XTERM) { 
    text=strdup(GetPath());
    if (text[0]=='~' && text[1]=='/')
      text[0]='.';
    chdir(text);
    system("xterm -sb -sl 500 &");
    chdir((char*)getenv("HOME"));
    free(text);
  } else if (retchoose==MENU_OPTIONS) {
    text=malloc(strlen("dfm -setfile  &")+strlen(filenames)+1);
    if (inwindow==True)
      strcpy(text,"dfm -setdir ");
    else
      strcpy(text,"dfm -setfile ");
    strcat(text,filenames);
    strcat(text," &");
    for(i=0;i<strlen(text)-2;i++)
      if (text[i]==' ' && text[i+1]=='~' && text[i+2]=='/')
	text[i+1]='.';
    usershellsystem(text);
    free(text);
  } else if (retchoose==MENU_NORMAL) {
    ExecuteShellcommand(GetPath(),"dfm !0!",NULL,0);
  } else if (retchoose==MENU_DETAIL) {
    ExecuteShellcommand(GetPath(),"dfm !0! -detail",NULL,0);
  } else if (retchoose==MENU_STRUCTURE) {
    ExecuteShellcommand(GetPath(),"dfm !0! -structure",NULL,0);
  } else if (retchoose==MENU_PARENT) {
    text=strdup(GetPath());
    j=0;
    for (i=0;i<(strlen(text)-1);i++)
      if (text[i]=='/') 
        j=i;
    text[j+1]=0;
    if (GetKindOfWindow()==DETAIL)
      ExecuteShellcommand(text,"dfm !0! -detail",NULL,0);
    else
      ExecuteShellcommand(text,"dfm !0!",NULL,0);
    free(text);
  } else if (retchoose==MENU_OPEN) {
    ExecuteShellWithFollowLink(mainname,retstring,dropname,0);
    UnsetMarks();
  }
  for (i=0;i<tobefreedc;i++)
    free(tobefreed[i]);
  free(tobefreed);
  tobefreed=NULL;
  free(dropname);
  free(mainname);  
  free(retstring);
  free(filenames);
}
