/* this file is a part of Ami software, (C) Hwang chi-deok 1999 */

#include "config.h"
#include "cp.h"
#include "ami.h"
#include "hangulinput.h"
#include "conf.h"
#include "keyparse.h"

static GList *activate_list = NULL;

static void about_ami(void);
static void warn_no_effect(char *message);
static gint cp_delete( GtkWidget *widget, void *data );
static GtkTooltips *tooltip;
static guint update_id = 0;

static void
keyboard_toggle_cb(GtkWidget *w, gpointer data)
{
    if (GTK_TOGGLE_BUTTON(w)->active) {
	ami_keyboard = GPOINTER_TO_INT(data);
	ami_hangul_keyboard_set(ami_keyboard);
    }
}

static void
ekeyboard_toggle_cb(GtkWidget *w)
{
    if (GTK_TOGGLE_BUTTON(w)->active) {
	ami_ekeyboard = 1;
    } else {
	ami_ekeyboard = 2;
    }
}

static void
editing_mode_toggle_cb(GtkWidget *w, gpointer data)
{
    if (GTK_TOGGLE_BUTTON(w)->active) {
	ami_editing_mode = GPOINTER_TO_INT(data);
    } 
}

static void
hanja_subst_mode_toggle_cb(GtkWidget *w, gpointer data)
{
    if (GTK_TOGGLE_BUTTON(w)->active) {
	ami_hanja_subst_mode = ami_hanja_def_subst_mode = GPOINTER_TO_INT(data);
    }
}

static void
esc_mode_toggle_cb(GtkWidget *w, gpointer data)
{
    esc_han_toggle = GTK_TOGGLE_BUTTON(w)->active;
}

static void
unique_han_toggle_cb(GtkWidget *w, gpointer data)
{
    warn_no_effect("ѱ   ƹ̸ ٽ ž߸ ȿ ֽϴ.");
    unique_han = GTK_TOGGLE_BUTTON(w)->active;
}

static void
entry_changed(GtkWidget *w)
{
    gtk_object_set_data(GTK_OBJECT(w), "changed", GINT_TO_POINTER(1));
}

static void
activate_cb(GtkWidget *w)
{
    gtk_signal_emit(GTK_OBJECT(w), update_id);
}

static void
key_setting_activate(GtkWidget *w, char *kind)
{
    char *key;
    if (!gtk_object_get_data(GTK_OBJECT(w), "changed")) return;
    gtk_object_set_data(GTK_OBJECT(w), "changed", NULL);
    key = gtk_entry_get_text(GTK_ENTRY(w));
    if (!strcmp(kind, "ѿ")) {
	make_trigger_keys(&trigger_keys, key);
	warn_no_effect("ѿȯŰ  ٽ ƹ̸ ϼž߸ ȿ ֽϴ.");
    } else if (!strcmp(kind, "")) {
	make_trigger_keys(&hanja_keys, key);
    } else if (!strcmp(kind, "Ư")) {
	make_trigger_keys(&special_char_keys, key);
    } else if (!strcmp(kind, " ")) {
	make_trigger_keys(&flush_keys, key);
    }
}

static void
label_setting_activate(GtkEntry *w, gchar **label)
{
    if (!gtk_object_get_data(GTK_OBJECT(w), "changed")) return;
    gtk_object_set_data(GTK_OBJECT(w), "changed", NULL);
    g_free(*label);
    *label = gtk_entry_get_text(w);
}

static void
support_status_toggled(GtkWidget *w)
{
    warn_no_effect("â  ƹ̸ ٽ ž߸ ȿ ֽϴ.");
    support_status = GTK_TOGGLE_BUTTON(w)->active;
}

static void
underline_mode_toggled(GtkWidget *w)
{
    ami_use_underline = GTK_TOGGLE_BUTTON(w)->active;
}

static void
save_conf(GtkWidget *w, gpointer data)
{
    GList *list = activate_list;
    while(list) {
	gtk_signal_emit(GTK_OBJECT(list->data), update_id);
	list = list->next;
    }
    ami_config_save_file(NULL);
}

void
set_keyboard(void)
{
    char *s;
    if (ami_keyboard < 2 || ami_keyboard > 4) {
	if ((s = g_getenv("AMI_KEYBOARD")) == NULL) 
	    s = g_getenv("HANGUL_KEYBOARD_TYPE");
	if (s) {
	    if (*s == '2') ami_hangul_keyboard_set(2);
	    else if (!strncmp(s, "3FINAL", 6)) ami_hangul_keyboard_set(4);
	    else ami_hangul_keyboard_set(3);
	} else {
	    ami_hangul_keyboard_set(2);
	}
    } else {
	ami_hangul_keyboard_set(ami_keyboard);
    }
}

static GtkWidget *
create_keyboard_setting(void)
{
    /* Ű  */
    GtkWidget *vbox0, *vbox1, *frame, *hbox;
    GtkWidget *qwerty, *dvorak;
    GtkWidget *button1, *button2, *button3;
    GSList *group;
    int keyboard;

    vbox0 = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox0), 5);

    frame = gtk_frame_new("ѱ ");
    gtk_box_pack_start(GTK_BOX(vbox0), frame, FALSE, FALSE, 5);

    vbox1 = gtk_vbox_new(TRUE, 2);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);
    button1 = gtk_radio_button_new_with_label(NULL, "ι");
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(button1));
    gtk_container_add(GTK_CONTAINER(vbox1), button1);

    button2 = gtk_radio_button_new_with_label(group, " 390");
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(button2));
    gtk_container_add(GTK_CONTAINER(vbox1), button2);

    button3 = gtk_radio_button_new_with_label(group, " ");
    gtk_container_add(GTK_CONTAINER(vbox1), button3);

    keyboard = ami_hangul_keyboard_get();
    switch(keyboard) {
	case 2:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1), TRUE);
	    break;
	case 3:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button2), TRUE);
	    break;
	default:
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button3), TRUE);
	    break;
    }
    gtk_signal_connect(GTK_OBJECT(button1), "toggled", (GtkSignalFunc)keyboard_toggle_cb, GINT_TO_POINTER(2));
    gtk_signal_connect(GTK_OBJECT(button2), "toggled", (GtkSignalFunc)keyboard_toggle_cb, GINT_TO_POINTER(3));
    gtk_signal_connect(GTK_OBJECT(button3), "toggled", (GtkSignalFunc)keyboard_toggle_cb, GINT_TO_POINTER(4));

    frame = gtk_frame_new(" ");
    gtk_box_pack_start(GTK_BOX(vbox0), frame, FALSE, FALSE, 5);

    hbox = gtk_hbox_new(TRUE, 2);
    gtk_container_add(GTK_CONTAINER(frame), hbox);
    qwerty = gtk_radio_button_new_with_label(NULL, "Qwerty");
    gtk_container_add(GTK_CONTAINER(hbox), qwerty);
    dvorak = gtk_radio_button_new_with_label(
	gtk_radio_button_group(GTK_RADIO_BUTTON(qwerty)), "Dvorak");
    gtk_container_add(GTK_CONTAINER(hbox), dvorak);
    if (ami_ekeyboard == 1) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(qwerty), TRUE);
    } else {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dvorak), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(qwerty), "toggled", (GtkSignalFunc)ekeyboard_toggle_cb, NULL);
    return vbox0;
}

static GtkWidget *
create_input_setting(void)
{
    GtkWidget *vbox0, *vbox1, *frame, *hbox;
    GtkWidget *wbutton, *swbutton, *cbutton;
    GtkWidget *esc;
    GtkWidget *b;
    GSList *group;
    gchar **hanja_formats;
    int i;

    vbox0 = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox0), 5);

    frame = gtk_frame_new("Է ");
    gtk_box_pack_start(GTK_BOX(vbox0), frame, FALSE, FALSE, 0);

    vbox1 = gtk_vbox_new(TRUE, 2);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);

    wbutton = gtk_radio_button_new_with_label(NULL, "ܾ: ̵");
    gtk_container_add(GTK_CONTAINER(vbox1), wbutton);
    swbutton = gtk_radio_button_new_with_label(
	gtk_radio_button_group(GTK_RADIO_BUTTON(wbutton)), "ܾ: ̵Ұ");
    gtk_container_add(GTK_CONTAINER(vbox1), swbutton);
    cbutton = gtk_radio_button_new_with_label(
	gtk_radio_button_group(GTK_RADIO_BUTTON(swbutton)), "ڴ");
    gtk_container_add(GTK_CONTAINER(vbox1), cbutton);
    if (ami_editing_mode == AMI_EDITING_WORD_MODE) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wbutton), TRUE);
    } else if (ami_editing_mode == AMI_EDITING_SIMPLE_WORD_MODE) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(swbutton), TRUE);
    } else {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cbutton), TRUE);
    }

    gtk_signal_connect(GTK_OBJECT(wbutton), "toggled", (GtkSignalFunc)editing_mode_toggle_cb, GINT_TO_POINTER(AMI_EDITING_WORD_MODE));
    gtk_signal_connect(GTK_OBJECT(swbutton), "toggled", (GtkSignalFunc)editing_mode_toggle_cb, GINT_TO_POINTER(AMI_EDITING_SIMPLE_WORD_MODE));
    gtk_signal_connect(GTK_OBJECT(cbutton), "toggled", (GtkSignalFunc)editing_mode_toggle_cb, GINT_TO_POINTER(AMI_EDITING_CHAR_MODE));

    frame = gtk_frame_new(" ġȯ ");
    gtk_box_pack_start(GTK_BOX(vbox0), frame, FALSE, FALSE, 0);
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), hbox);

    hanja_formats = g_strsplit(ami_hanja_subst_format, ":", -1);
    group = NULL;
    for(i=0;hanja_formats[i] != NULL; i++) {
	b = gtk_radio_button_new_with_label(group, hanja_formats[i]);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(b));
	gtk_container_add(GTK_CONTAINER(hbox), b);
	if (ami_hanja_def_subst_mode == (i+1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b), TRUE);
	gtk_signal_connect(GTK_OBJECT(b), "toggled", 
		(GtkSignalFunc)hanja_subst_mode_toggle_cb, 
		GINT_TO_POINTER(i+1));
    }
    g_strfreev(hanja_formats);

    esc = gtk_check_button_new_with_label("Escape ѱ ȯ");
    gtk_box_pack_start(GTK_BOX(vbox0), esc, FALSE, FALSE, 5);
    if (esc_han_toggle) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(esc), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(esc), "toggled", (GtkSignalFunc)esc_mode_toggle_cb, NULL);

    esc = gtk_check_button_new_with_label(" ѿ ");
    gtk_box_pack_start(GTK_BOX(vbox0), esc, FALSE, FALSE, 5);
    if (unique_han) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(esc), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(esc), "toggled", (GtkSignalFunc)unique_han_toggle_cb, NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltip), esc, "ѱ   ƹ̸ ٽ ž߸ ȿ ֽϴ.", NULL);

    return vbox0;
}

static GtkWidget *
create_appearance_setting(void)
{
    GtkWidget *vbox, *frame, *hbox, *status;
    GtkWidget *l, *entry, *under;

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    status = gtk_check_button_new_with_label("â ");
    gtk_box_pack_start(GTK_BOX(vbox), status, FALSE, FALSE, 5);
    if (support_status) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(status), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(status), "toggled", 
    	(GtkSignalFunc)support_status_toggled, NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltip), status, "â  ƹ̸ ٽ ž߸ ȿ ֽϴ.", NULL);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new("ѱۻ¶:");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry), hangul_mode_label);
    gtk_widget_set_usize(entry, 100, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)label_setting_activate, &hangul_mode_label);
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new("¶:");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry), english_mode_label);
    gtk_widget_set_usize(entry, 100, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)label_setting_activate, &english_mode_label);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    under = gtk_check_button_new_with_label("Էâ  ");
    gtk_box_pack_start(GTK_BOX(vbox), under, FALSE, FALSE, 5);
    if (ami_use_underline) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(under), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(under), "toggled", (GtkSignalFunc)underline_mode_toggled, NULL);

    return vbox;
}

static GtkWidget *
create_key_setting(void)
{
    GtkWidget *vbox, *frame, *hbox;
    GtkWidget *l, *entry;
    gchar *key_desc;

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new("ѿȯ");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    key_desc = trigger_keys_to_str(trigger_keys);
    gtk_entry_set_text(GTK_ENTRY(entry), key_desc);
    gtk_widget_set_usize(entry, 150, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)key_setting_activate, "ѿ");
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new("ںȯ");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    key_desc = trigger_keys_to_str(hanja_keys);
    gtk_entry_set_text(GTK_ENTRY(entry), key_desc);
    gtk_widget_set_usize(entry, 150, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)key_setting_activate, "");
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new("ƯԷ");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    key_desc = trigger_keys_to_str(special_char_keys);
    gtk_entry_set_text(GTK_ENTRY(entry), key_desc);
    gtk_widget_set_usize(entry, 150, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)key_setting_activate, "Ư");
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    l = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    key_desc = trigger_keys_to_str(flush_keys);
    gtk_entry_set_text(GTK_ENTRY(entry), key_desc);
    gtk_widget_set_usize(entry, 150, -1);
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", 
    	(GtkSignalFunc)activate_cb, NULL);
    gtk_signal_connect(GTK_OBJECT(entry), "update", 
    	(GtkSignalFunc)key_setting_activate, " ");
    gtk_signal_connect(GTK_OBJECT(entry), "changed",
    	(GtkSignalFunc)entry_changed, NULL);
    activate_list = g_list_prepend(activate_list, entry);

    return vbox;
}


GtkWidget *
create_cp(void)
{
    GtkWidget *notebook;
    GtkWidget *vbox, *hbox;
    GtkWidget *b;
    GtkWidget *sep;

    set_keyboard();
    tooltip = gtk_tooltips_new();
    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
    notebook = gtk_notebook_new();
    gtk_container_add(GTK_CONTAINER(vbox), notebook);
    update_id = gtk_object_class_user_signal_new(gtk_type_class (GTK_TYPE_ENTRY),
    	"update", 0, gtk_marshal_NONE__NONE,
	GTK_TYPE_NONE, 0);
    {
	/* Ű  */
	GtkWidget *keyw, *keylabel;
	keylabel = gtk_label_new("Ű");
	keyw = create_keyboard_setting();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), keyw, keylabel);
    }
    {
	GtkWidget *inputw, *inputlabel;
	inputlabel = gtk_label_new("Է");
	inputw = create_input_setting();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), inputw, inputlabel);
    }
    {
	GtkWidget *keyw, *keylabel;
	keylabel = gtk_label_new("Ű");
	keyw = create_key_setting();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), keyw, keylabel);
    }
    {
	GtkWidget *box, *label;
	label = gtk_label_new("");
	box = create_appearance_setting();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);
    }

    sep = gtk_hseparator_new();
    gtk_container_add(GTK_CONTAINER(vbox), sep);

    {
	GtkWidget *h, *dummy;
	h = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(vbox), h);
	gtk_container_set_border_width(GTK_CONTAINER(h), 0);
	dummy = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(h), dummy, TRUE, TRUE, 0);

	hbox = gtk_hbox_new(TRUE, 3);
	gtk_box_pack_end(GTK_BOX(h), hbox, FALSE, FALSE, 0);
    }

    b = gtk_button_new_with_label("ƹ̶?");
    gtk_container_add(GTK_CONTAINER(hbox), b);
    gtk_signal_connect(GTK_OBJECT(b), "clicked", (GtkSignalFunc)about_ami, NULL);

    b = gtk_button_new_with_label("");
    gtk_container_add(GTK_CONTAINER(hbox), b);
    gtk_signal_connect(GTK_OBJECT(b), "clicked", (GtkSignalFunc)save_conf, NULL);

    if (ami_run_mode == AMI_NORMAL_RUN) {
	b = gtk_button_new_with_label("");
	gtk_container_add(GTK_CONTAINER(hbox), b);
	gtk_signal_connect(GTK_OBJECT(b), "clicked", (GtkSignalFunc)cp_quit, NULL);
    } else {
	b = gtk_button_new_with_label("ݱ");
	gtk_container_add(GTK_CONTAINER(hbox), b);
	gtk_signal_connect(GTK_OBJECT(b), "clicked", (GtkSignalFunc)cp_delete, NULL);
    }

    gtk_widget_show_all(vbox);

    return vbox;
}

static void
about_ami(void)
{
    GtkWidget *win, *label;
    GString *str;

    win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(win), "ƹ̶?");
    gtk_container_set_border_width(GTK_CONTAINER(win), 5);
    str = g_string_new(NULL);
    g_string_sprintf(str, "ƹ  %s\n", VERSION);
    g_string_append(str, 
	"\nƹ̴ Ȳġ(cdhwang@sr.hei.co.kr) \n"
	"gtk+ ̿Ͽ  \nGnu General Public License Version 2"
	" \n Ӱ Ͻ  ִ ѱԷ±Դϴ.\n\n"
        "gtk+  Ϳ    \n Ѵ.\n"
	"gtk+  ڼ  \n"
	"http://www.gtk.org  ֽϴ.");
    label = gtk_label_new(str->str);
    g_string_free(str, TRUE);
    gtk_container_add(GTK_CONTAINER(win), label);
    gtk_widget_show_all(win);
}

static void warn_no_effect(char *message)
{
    /* FIXME */
    g_print("%s\n", message);
}

void
cp_quit(void)
{
    IMCloseIM(xims);
    gtk_main_quit();
}

static gint cp_delete( GtkWidget *widget, void *data )
{
    gtk_widget_hide(cp_win); /* hide cp_win */
    return TRUE;
}