#ifndef BALLOON_H
#define BALLOON_H

/*
 * To use:
 * 1. set extern globals (MyName, dpy, screen)
 * 2. parse config file, calling balloon_parse() at each line
 * 3. call balloon_setup()
 * 4. call balloon_handle_event() inside event loop
 *
 * Notes:
 *  EnterNotify and LeaveNotify must be selected for parent windows
 *  balloons may be created (with balloon_new()) at any point
 */

typedef struct Balloon {
	struct Balloon* next;	/* next balloon in the list */
	Window parent;			/* window balloon should pop up over */
	char* text;				/* text to display in balloon */
} Balloon;

extern Bool balloon_show;

Bool balloon_parse(char *tline, FILE * fd);
void balloon_setup(void);
Balloon* balloon_new(Window parent);
Balloon* balloon_new_with_text(Window parent, char* text);
Balloon* balloon_find(Window parent);
void balloon_delete(Balloon* balloon);
void balloon_set_text(Balloon* balloon, char* text);
Bool balloon_handle_event(XEvent* event);

#endif /* BALLOON_H */
