##############################################################################
# 
# Zope Public License (ZPL) Version 0.9.6
# ---------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Any use, including use of the Zope software to operate a website,
#    must either comply with the terms described below under
#    "Attribution" or alternatively secure a separate license from
#    Digital Creations.  Digital Creations will not unreasonably
#    deny such a separate license in the event that the request
#    explains in detail a valid reason for withholding attribution.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# Attribution
# 
#   Individuals or organizations using this software as a web
#   site ("the web site") must provide attribution by placing
#   the accompanying "button" on the website's main entry
#   point.  By default, the button links to a "credits page"
#   on the Digital Creations' web site. The "credits page" may
#   be copied to "the web site" in order to add other credits,
#   or keep users "on site". In that case, the "button" link
#   may be updated to point to the "on site" "credits page".
#   In cases where this placement of attribution is not
#   feasible, a separate arrangment must be concluded with
#   Digital Creations.  Those using the software for purposes
#   other than web sites must provide a corresponding
#   attribution in locations that include a copyright using a
#   manner best suited to the application environment.  Where
#   attribution is not possible, or is considered to be
#   onerous for some other reason, a request should be made to
#   Digital Creations to waive this requirement in writing.
#   As stated above, for valid requests, Digital Creations
#   will not unreasonably deny such requests.
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################
"""Db connection implementation"""
__version__='$Revision: 1.9 $'[11:-2]

import MySQL, regex, sys
from string import strip, split, find, join
from time import gmtime, strftime

failures=calls = 0

nonselect_desc=[
    ('Query',  'meta', "string", 62, ''),
    ('Status', 'meta', "string", 12, ''),
    ('Calls',  'meta', "string", 12, ''),
    ]

class DB:

    defs={
        "short": "i", "long": "i", "char": "s", "double": "n", "decimal": "n",
        "float": "n", "tiny blob": "t", "medium blob": "t", "long blob": "t",
        "blob": "t", "date": "d", "time": "s", "datetime": "d",
        "timestamp": "d", "varchar": "t", "string": "t",
        }

    Database_Error=MySQL.error

    def __init__(self,connection):
        self.connection=connection

        info=split(connection)
        if info and len(info) < 4:
            while len(info) < 3: info.append('')
            dbhost=split(info[0],'@')
            [user, pw]=info[1:]
            if dbhost and len(dbhost) < 3:
                if len(dbhost) == 1: db, host = dbhost[0], 'localhost'
                else: [db, host] = dbhost
                
                c=MySQL.connect(host,user,pw)
                c.selectdb(db)
                self.db=c
                return

        raise self.Database_Error, (
            'Invalid connection string, <code>%s</code>.\n'
            'The connection should consist of a database name,\n'
            'user name, and password separated by spaces.\n'
            'The database name may include a host specification\n'
            'by following the database name with an @ symbol and a\n'
            'host name.  A sample connection string is:\n'
            '<pre>\n'
            'sample@cooldata.com public spam\n'
            '</pre>\n'
            'If the password is ommitted, an empty string will be used.'
            )

    def query(self,query_string,
              max_rows=9999999,
              select_m=regex.compile('[\0- ]*select[\0- ]+',
                                     regex.casefold).match,
              ):
        db=self.db
        try:
            queries=filter(None, map(strip,split(query_string, '\0')))
            if not queries: raise 'Query Error', 'empty query'
            result=()
            desc=None
            for qs in queries:
                c=db.query(qs)
                try:
                    desc=c.fields()
                    r=c.fetchrows()
                except: r=None
                if not r: continue
                if result:
                    raise 'Query Error', (
                        'select in multiple sql-statement query'
                        )
                result=r
        except self.Database_Error, mess:
            raise sys.exc_type, sys.exc_value, sys.exc_traceback

        if desc is None: return (), ()

        items=[]
        func=items.append
        defs=self.defs
        for d in desc:
            item={'name': d[0],
                  'type': defs[d[2]],
                  'width': d[3],
                 }
            func(item)
        return items, result
