// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        remote.h
//
// Purpose:     interface to VRweb remote calls
//
// Created:      6 Dec 1995   Michael Pichler
//
// Changed:      7 Dec 1995   Michael Pichler
//
// $Id: remote.h,v 1.4 1997/02/25 17:03:58 mpichler Exp $
//
//</file>



#ifndef harmony_scene_remote_h
#define harmony_scene_remote_h

#include <IV-X11/xdisplay.h>
class EventRep;
class RString;


// program identification:

extern const char* const RemoteVersionProperty;  // e.g. "_PROGRAM_VERSION"
extern const char* const RemoteCommandProperty;  // e.g. "_PROGRAM_COMMAND"


// identification:

void remoteSetVersion (DisplayRep* d, WindowRep* w, const char* version);

// sets X-property RemoteVersionProperty for this program,
// in case version is NULL, RemoteVersionProperty is deleted;
// requires a bound window


// sender:

int remoteSendCommand (DisplayRep*, const char* command);

// sets X-property RemoteCommandProperty on a window with
// RemoteVersionProperty set;
// to be called before window mapping or identification;
// returns non-zero if successful

unsigned long remoteGetWindowID (DisplayRep*);

// get ID of remote window (parent window managed by WM)


// receiver:

int remoteReceiveCommand (DisplayRep* d, WindowRep* w, const EventRep* e, RString& command);

// reads RemoteCommandProperty (usually called on property_notify)
// or nil if another property notify event arrived
// returns non-zero if successful and sets cmd string
// 0 otherwise (other property notify event)

#endif
