/*  Screem:  spell.c,
 *  handles spell checking of pages
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>

#include "editor.h"
#include "site.h"
#include "page.h"

extern GtkWidget *app;
extern Site *current_site;
extern Page *current_page;

typedef struct _Word {
	gchar *word;
	gint pos;
} Word;

static gint offset = 0;
static GList *words;

static guint idle_;

static GList* splitText( gchar *text ); /* returns a list of the individual
					   words, ignoring HTML tags */

static void spellStartCheck( GtkWidget *sc );
void spell_check( void );


/**********************************************************************/
static void spellCheckDone( GtkWidget *widget, GdkEvent *event, GnomeSpell *sc)
{
	gtk_widget_hide( widget );
	gtk_window_set_modal( GTK_WINDOW( widget ), FALSE );

	/* clear the list of words */
}
/**********************************************************************/
static void spellCheckClicked( GtkWidget *widget, gint button, GnomeSpell *sc )
{
	/*	gnome_spell_kill( sc );*/
	gtk_widget_hide( widget );
	gtk_window_set_modal( GTK_WINDOW( widget ), FALSE );

	/* clear the list of words */

}
/**********************************************************************/
static void handleCheck( GtkWidget *widget, GnomeSpellInfo *sp )
{
	/* struct GnomeSpellInfo {
	   gchar* original;
	   gchar* replacement;
	   gchar* word;
	   guint offset;
	   GSList * words;
	   };
	*/
	Word *word = words->data;

	/* if we didn't change it then return */
	if( sp->replacement ) {
	 	/* delete word at position word->pos in the editor */
		screem_editor_delete_forward( word->pos + offset, 
					      strlen( word->word ) );
		/* now insert the replacement */
		screem_editor_insert( word->pos + offset, sp->replacement );
		offset += ( strlen( sp->replacement ) - strlen( word->word ) );
	}

	words = words->next;
	idle_ = gtk_idle_add( (GtkFunction) spellStartCheck, widget );
}
/**********************************************************************/
void spell_check()
{
	static GtkWidget *dialog = NULL;
	GtkWidget *sc;
	Page *page;
	
	if( current_site ) {
		page = screem_site_get_current_page( current_site );
	} else 
		page = current_page;
	
	g_return_if_fail( page != NULL );
      
	/* need to split p->data up into individual words, ignoring tags,
	   although it needs to check things like alt attributes inside
	   tags */
	screem_editor_buffer_text();
	words = splitText( page->data );
	
	sc = gnome_spell_new();

	dialog = gnome_dialog_new( _( "Spell check page" ),
				   GNOME_STOCK_BUTTON_CLOSE,
				   NULL );
	gtk_object_set_data( GTK_OBJECT( dialog ), "dialog", 
			     (gpointer)&dialog );
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dialog )->vbox ),
                            sc, TRUE, TRUE, GNOME_PAD);

	gtk_window_set_modal( GTK_WINDOW( dialog ), TRUE );

	gtk_widget_show_all( dialog );
	gtk_signal_connect( GTK_OBJECT( sc ), "handled_word",
			    GTK_SIGNAL_FUNC( handleCheck ), 0 );
	gtk_signal_connect( GTK_OBJECT( dialog ), "delete_event",
                            spellCheckDone, sc );
        gtk_signal_connect( GTK_OBJECT( dialog ), "clicked",
                            spellCheckClicked, sc );

	offset = 0;

	spellStartCheck( sc );
}
/**********************************************************************/
/* splits text up into its individual words, ignoring html tags,
   FIXME: should really handle any text within tag attributes such as alt
   in an <img> tag */
static GList* splitText( gchar *text )
{
	GList *words;
	GList *list;
	gchar c;
	gchar *start;
	gchar *word;
	gint len;
	gint i;
	gint wordLen;
	Word *w;

	words = g_list_alloc();
	list = words;
	len = strlen( text );

       	for( i = 0, start = text; i < len; i ++ ) {
		c = *( text + i );
		if( ( c == ' ' ) || ( c == '<' ) || ( c == '\n' ) ||
		    ( c == '&' ) || ( c == ';' ) || ( c == '/' ) ) {
			if( start != text + i ) {
				/* we have come to the end of a word */
				wordLen = text + i - start;
				word = g_strndup( start, wordLen );
				w = (Word*)g_malloc( sizeof( Word ) );
				w->word = word;
				w->pos = start - text;
				list->data = w;
				g_list_append( words, NULL );
				list = list->next;
			}
			start = text + i + 1;
		}

		/* stopped at the start of a tag, advance forward until we
		   hit the end of the tag */
		if( c == '<' ) {
			while( ( c != '>' ) && ( i < len ) ) {
				i ++;
				c = *( text + i );
			}
			start = text + i + 1;
		} else if( c == '&' ) {
			/* we stopped at a char encoding element */
			while( ( c != ';' ) && ( i < len ) ) {
				i ++;
				c = *( text + i );
			}
			start = text + i + 1;
		}
	}

	return words;
}
/**************************************************************************/
static void spellStartCheck( GtkWidget *sc )
{
	Word *word;
	gint result;

	gtk_idle_remove( idle_ );

	for( ; words->data; words = words->next ) {
		word = words->data;
		result = gnome_spell_check( GNOME_SPELL( sc ), word->word );
		if( result ) {
			screem_editor_set_pos( word->pos + offset );
			screem_editor_select_region( word->pos + offset,
						     word->pos + offset + 
						     strlen( word->word ) );
			break;
		}
	}

}
