/*  Screem:  pageWizard.c,
 *  A page druid for guiding users through the process of creating a page
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>

#include <glade/glade.h>

#include "editMenu.h"
#include "editor.h"
#include "fileops.h"
#include "preferences.h"
#include "preview.h"
#include "page.h"
#include "pageUI.h"
#include "siteTree.h"
#include "siteTreeUI.h"
#include "support.h"

extern GtkWidget *app;
extern Site *current_site;
extern Page *current_page;
extern Preferences *cfg;

void page_druid_canceled( GtkWidget *widget );
void page_druid_finished(GnomeDruidPage *druid_page, GtkWidget *druid );

gboolean page_druid_next1( GnomeDruidPage *druid_page, GtkWidget *druid );
gboolean page_druid_next2( GnomeDruidPage *druid_page, GtkWidget *druid );
gboolean page_druid_next3( GnomeDruidPage *druid_page, GtkWidget *druid );

static gchar *path;
static gchar *title;
static gchar *author;
static gchar *template;
static gchar *background;
static gboolean overide_template;
static gboolean is_frameset;

/* first element is a flag, as to whether or not we are to use the data 
   the rest are the rgb values */
static guint8 bg[ 4 ];
static guint8 t[ 4 ];
static guint8 l[ 4 ];
static guint8 v[ 4 ];
static guint8 a[ 4 ];

static GladeXML *xml;
static Page *page;

/*
 * screem_page_wizard:
 * @page:  the page struct to use
 *
 * opens the page wizard dialog
 *
 * return values: none
 */
void screem_page_wizard( Page *p )
{
	GtkWidget *toggle;
	GtkWidget *object;

	xml = glade_xml_new( GLADE_PATH"/pagedruid.glade", 
                             "page_druid_window" );

	/* yep, its kludge time as Glade doesn't support this now */

	/* page 1 */
	toggle = glade_xml_get_widget( xml, "use_template" );
	object = glade_xml_get_widget( xml, "template_path_entry" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	/* page 2 */
	toggle = glade_xml_get_widget( xml, "bgcolor_check" );
	object = glade_xml_get_widget( xml, "bgcolor_picker" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	toggle = glade_xml_get_widget( xml, "text_check" );
	object = glade_xml_get_widget( xml, "text_picker" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	toggle = glade_xml_get_widget( xml, "link_check" );
	object = glade_xml_get_widget( xml, "link_picker" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	toggle = glade_xml_get_widget( xml, "vlink_check" );
	object = glade_xml_get_widget( xml, "vlink_picker" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	toggle = glade_xml_get_widget( xml, "alink_check" );
	object = glade_xml_get_widget( xml, "alink_picker" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	/* page 3 */
	toggle = glade_xml_get_widget( xml, "background_check" );
	object = glade_xml_get_widget( xml, "background_entry" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

        glade_xml_signal_autoconnect( xml );

	page = p;
}

void page_druid_canceled( GtkWidget *widget )
{
	GtkWidget *window;

	window = glade_xml_get_widget( xml, "page_druid_window" );

	gtk_widget_destroy( window );
	screem_page_destroy( page );
}

void page_druid_finished(GnomeDruidPage *widget, GtkWidget *druid )
{
	GtkWidget *window;

	gchar *string;
	gchar *temp;

	window = glade_xml_get_widget( xml, "page_druid_window" );
	gtk_widget_destroy( window );

	screem_page_set_pathname( page, path );

	if( template ) {
		/* we have a tempate, copy to the pages pathname */
		if(! copy_file( template, screem_page_get_pathname( page ) )) {
			screem_page_destroy( page );
			return;
		}
		/* succesfuly copying, load the template */
		screem_page_load( page );
	} else {
		/* create a basic page structure */
		if( ! is_frameset ) {
			page->data = g_strdup_printf("<HTML>\n<HEAD>\n<TITLE></TITLE>\n</HEAD>\n<BODY>\n</BODY>\n</HTML>\n");
		} else {
			page->data = g_strdup_printf("<HTML>\n<HEAD>\n<TITLE></TITLE>\n</HEAD>\n<NOFRAMES>\n<BODY>\n</BODY>\n</NOFRAMES>\n</HTML>\n");
		}
	}

	/* now fill in the details that were set */

	/* first the title */
	string = g_strdup_printf( "<TITLE>%s</TITLE>", title );
	temp = find_text( page->data, "<[tT][iI][tT][lL][eE][^>]*>.*</[tT][iI][tT][lL][eE]>", string );
	if( temp ) {
		g_free( title );
		title = NULL;
		page->data = temp;
	}

	/* now the author */
	g_free( string );
	string = g_strdup_printf( "<meta name=\"author\" content=\"%s\">", 
				  author );
	temp = find_text( page->data, "<[Mm][Ee][Tt][Aa].*name=\"[Aa][Uu][Tt][Hh][Oo][Rr]\"[^>]*>", string );
	if( temp ) {
		g_free( author );
		author = NULL;
		page->data = temp;
	}

	/* construct a body/noframes tag if we aren't using a template or
	   if we are overiding the template */
	g_free( string );
	if( ( ! template ) || overide_template ) {
		gchar *bgstring;
		gchar *tstring;
		gchar *lstring;
		gchar *vstring;
		gchar *astring;

		if( bg[ 0 ] ) {
			bgstring = g_strdup_printf(" bgcolor=\"#%.2x%.2x%.2x\"",
						   bg[ 1 ], bg[ 2 ], bg[ 3 ]);
		} else {
			bgstring = g_strdup( "" );
		}
		if( t[ 0 ] ) {
			tstring = g_strdup_printf( " text=\"#%.2x%.2x%.2x\"",
						   t[ 1 ], t[ 2 ], t[ 3 ] );
		} else {
			tstring = g_strdup( "" );
		}
		if( l[ 0 ] ) {
			lstring = g_strdup_printf( " link=\"#%.2x%.2x%.2x\"",
						   l[ 1 ], l[ 2 ], l[ 3 ] );
		} else {
			lstring = g_strdup( "" );
		}
		if( v[ 0 ] ) {
			vstring = g_strdup_printf( " vlink=\"#%.2x%.2x%.2x\"",
						   v[ 1 ], v[ 2 ], v[ 3 ] );
		} else {
			vstring = g_strdup( "" );
		}
		if( a[ 0 ] ) {
			astring = g_strdup_printf( " alink=\"#%.2x%.2x%.2x\"",
						   a[ 1 ], a[ 2 ], a[ 3 ] );
		} else {
			astring = g_strdup( "" );
		}
		string = g_strdup_printf( "<BODY%s%s%s%s%s>",
					  bgstring, tstring, lstring,
					  vstring, astring );
		g_free( bgstring );
		g_free( tstring );
		g_free( lstring );

		temp = find_text( page->data, "<[bB][oO][dD][yY][^>]*>",
				  string );
		if( temp ) {
			g_free( author );
			author = NULL;
			page->data = temp;
		}
	}

	/* now check to see what we didn't able insert and insert them */
	g_free( string );

	/* save the page */
	if( ! screem_page_save( page ) ) {
		screem_page_destroy( page );
		return;
	}

	screem_page_destroy( page );
	if( current_site ) {
		screem_site_add_page( current_site, path );
		page = screem_site_locate_page( current_site, path );
		refresh_file_tree();
		screem_page_insert( page );
	} else {
		screem_page_open_with_filename( path );
	}
}

gboolean page_druid_next1( GnomeDruidPage *druid_page, GtkWidget *druid )
{
	GtkWidget *path_entry;
	GtkWidget *title_entry;
	GtkWidget *author_entry;
	GtkWidget *template_entry;

	GladeXML *message;

	path_entry = glade_xml_get_widget( xml, "page_pathname" );
	title_entry = glade_xml_get_widget( xml, "page_title" );
	author_entry = glade_xml_get_widget( xml, "page_author" );
	template_entry = glade_xml_get_widget( xml, "template_path_entry" );

	path = g_strdup( gtk_entry_get_text( GTK_ENTRY( path_entry ) ) );
	title = g_strdup( gtk_entry_get_text( GTK_ENTRY( title_entry ) ) );
	author = g_strdup( gtk_entry_get_text( GTK_ENTRY( author_entry ) ) );

	if( GTK_WIDGET_IS_SENSITIVE( template_entry ) ) {
		template_entry = gnome_file_entry_gtk_entry( GNOME_FILE_ENTRY( template_entry ) );
		template = g_strdup( gtk_entry_get_text( GTK_ENTRY( template_entry ) ) );
	} else {
		template = NULL;
	}

	/* we must have a path and title */
	if( ( ! strlen( path ) ) || ( ! strlen( title ) ) ) {
		message = glade_xml_new( GLADE_PATH"/pagedruid.glade",
					 "message1" );
		/* FIXME: Doesn't run modal despite being set to be modal in
		   glade */
                return TRUE;
	}

	return FALSE;
}

gboolean page_druid_next2( GnomeDruidPage *druid_page, GtkWidget *druid )
{
	GtkWidget *overide;
	GtkWidget *frameset;
	GtkWidget *bgcp;
	GtkWidget *tcp;
	GtkWidget *lcp;
	GtkWidget *vcp;
	GtkWidget *acp;
	guint8 junk;

	overide = glade_xml_get_widget( xml, "overide" );
	frameset = glade_xml_get_widget( xml, "frameset" );

	bgcp = glade_xml_get_widget( xml, "bgcolor_picker" );
	tcp = glade_xml_get_widget( xml, "text_picker" );
	lcp = glade_xml_get_widget( xml, "link_picker" );
	vcp = glade_xml_get_widget( xml, "vlink_picker" );
	acp = glade_xml_get_widget( xml, "alink_picker" );

	overide_template = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( overide ) );
	is_frameset = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( frameset ) );

	if( ( bg[ 0 ] = GTK_WIDGET_IS_SENSITIVE( bgcp ) ) ) {
		gnome_color_picker_get_i8( GNOME_COLOR_PICKER( bgcp ),
					   &bg[ 1 ], &bg[ 2 ], &bg[ 3 ],
					   &junk );
	}
	if( ( t[ 0 ] = GTK_WIDGET_IS_SENSITIVE( tcp ) ) ) {
		gnome_color_picker_get_i8( GNOME_COLOR_PICKER( tcp ),
					   &t[ 1 ], &t[ 2 ], &t[ 3 ],
					   &junk );
	}
	if( ( l[ 0 ] = GTK_WIDGET_IS_SENSITIVE( lcp ) ) ) {
		gnome_color_picker_get_i8( GNOME_COLOR_PICKER( lcp ),
					   &l[ 1 ], &l[ 2 ], &l[ 3 ],
					   &junk );
	}
	if( ( v[ 0 ] = GTK_WIDGET_IS_SENSITIVE( vcp ) ) ) {
		gnome_color_picker_get_i8( GNOME_COLOR_PICKER( vcp ),
					   &v[ 1 ], &v[ 2 ], &v[ 3 ],
					   &junk );
	}
	if( ( a[ 0 ] = GTK_WIDGET_IS_SENSITIVE( acp ) ) ) {
		gnome_color_picker_get_i8( GNOME_COLOR_PICKER( acp ),
					   &a[ 1 ], &a[ 2 ], &a[ 3 ],
					   &junk );
	}

	return FALSE;
}

gboolean page_druid_next3( GnomeDruidPage *druid_page, GtkWidget *druid )
{
	GtkWidget *background_img;

	background_img = glade_xml_get_widget( xml, "background_path" );
	if( GTK_WIDGET_IS_SENSITIVE( background_img ) ) {
		background = g_strdup( gtk_entry_get_text( GTK_ENTRY( background_img ) ) );
	}
	
	return FALSE;
}
